/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.utils;

import com.suncode.plugin.datasource.text.enums.SplitMode;
import com.suncode.plugin.datasource.text.utils.BomUtils;
import com.suncode.plugin.datasource.text.utils.CharsetOption;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TextDataReader {
    public static List<String> readLines(String filePath, SplitMode splitMode, CharsetOption charsetOption) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        try (Stream<String> stream = TextDataReader.streamSplit(path, splitMode, charsetOption);){
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public static Stream<String> streamSplit(Path path, SplitMode splitMode, CharsetOption option) throws IOException {
        BufferedReader reader = TextDataReader.newBufferedReader(path, option);
        if (SplitMode.NEW_LINE.equals((Object)splitMode)) {
            return (Stream)reader.lines().onClose(() -> TextDataReader.closeQuietly(reader));
        }
        return (Stream)Stream.of(TextDataReader.readAll(reader)).onClose(() -> TextDataReader.closeQuietly(reader));
    }

    private static BufferedReader newBufferedReader(Path path, CharsetOption option) throws IOException {
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        if (option.isWithBom()) {
            inputStream = BomUtils.skipBomIfPresent(inputStream);
        }
        return new BufferedReader(new InputStreamReader(inputStream, option.getCharset()));
    }

    private static String readAll(BufferedReader reader) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        while ((n = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    private static void closeQuietly(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TextDataReader() {
    }
}

