/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.component;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.datasource.text.TextDataSourceSpringContext;
import com.suncode.plugin.datasource.text.enums.FileLocation;
import com.suncode.plugin.datasource.text.enums.NewLineMode;
import com.suncode.plugin.datasource.text.enums.SplitMode;
import com.suncode.plugin.datasource.text.enums.WriteMode;
import com.suncode.plugin.datasource.text.parameters.InputParameter;
import com.suncode.plugin.datasource.text.parameters.enums.ParameterType;
import com.suncode.plugin.datasource.text.utils.CharsetOption;
import com.suncode.plugin.datasource.text.utils.CharsetUtils;
import com.suncode.plugin.datasource.text.utils.TextDataReader;
import com.suncode.plugin.datasource.text.utils.TextDataWriter;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TextDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(TextDataSource.class);
    private static final String PLUSWORKFLOW_HOME_TAG = "{PWFL_HOME}";
    private static final String PLUSWORKFLOW_WORKING_DIRECTORY_TAG = "{WORKING_DIRECTORY}";
    private static final String FILE_CONTENT_PARAMETER_ID = "fileContent";
    private static final String FILE_ID_PARAMETER_ID = "fileId";
    private static final String ADMINISTRATOR_DEFAULT_USERNAME = "admin";
    private final Set<InputParameter> inputParameters;
    private final String filePath;
    private final WriteMode writeMode;
    private final String tabularDataSeparator;
    private final CharsetOption charsetOption;
    private final NewLineMode newLineMode;
    private final String fileId;
    private final SplitMode readSplitMode;
    private final FileLocation fileLocation;
    private final String filename;
    private final boolean executeDocumentClassActions;
    private final String documentClassName;
    private final FileService fileService;
    private final DocumentService documentService;
    private final DocumentClassService documentClassService;
    private final DocumentClassIndexFinder documentClassIndexFinder = TextDataSourceSpringContext.getBean(DocumentClassIndexFinder.class);
    private final DocumentClassActionService documentClassActionService;

    public TextDataSource(Parameters parameters) {
        this.fileService = TextDataSourceSpringContext.getBean(FileService.class);
        this.documentClassActionService = TextDataSourceSpringContext.getBean(DocumentClassActionService.class);
        this.documentService = TextDataSourceSpringContext.getBean(DocumentService.class);
        this.documentClassService = TextDataSourceSpringContext.getBean(DocumentClassService.class);
        this.tabularDataSeparator = (String)parameters.get("tabularDataSeparator", String.class);
        this.writeMode = WriteMode.valueOf((String)Optional.ofNullable(parameters.get("writeMode", String.class)).orElse((String)parameters.getRaw("writeMode").getParameter().getDefaultValue()));
        this.filePath = this.buildPathToFile((String)parameters.get("filePath", String.class));
        this.inputParameters = this.buildInputParameters((String[])parameters.get("inputParameterId", String[].class), (String[])parameters.get("inputParameterName", String[].class), (String[])parameters.get("inputParameterType", String[].class));
        this.charsetOption = this.getCharsetOption((String)parameters.get("charset", String.class));
        this.newLineMode = NewLineMode.valueOf((String)Optional.ofNullable(parameters.get("newLineMode", String.class)).orElse((String)parameters.getRaw("newLineMode").getParameter().getDefaultValue()));
        this.fileId = (String)parameters.get(FILE_ID_PARAMETER_ID, String.class);
        this.readSplitMode = SplitMode.valueOf((String)Optional.ofNullable(parameters.get("readSplitMode", String.class)).orElse((String)parameters.getRaw("readSplitMode").getParameter().getDefaultValue()));
        this.fileLocation = FileLocation.valueOf((String)Optional.ofNullable(parameters.get("fileLocation", String.class)).orElse((String)parameters.getRaw("fileLocation").getParameter().getDefaultValue()));
        this.filename = (String)parameters.get("filename", String.class);
        this.executeDocumentClassActions = (Boolean)Optional.ofNullable(parameters.get("executeDocumentClassActions", Boolean.class)).orElse((Boolean)parameters.getRaw("executeDocumentClassActions").getParameter().getDefaultValue());
        this.documentClassName = (String)parameters.get("documentClassName", String.class);
    }

    private void applyFilters(List<Map<String, Object>> result, Map<String, String> filters) {
        filters.forEach((key, value) -> result.removeIf(map -> !((String)map.get(key)).toUpperCase().contains(value.toUpperCase())));
    }

    private List<Map<String, Object>> applyPagination(List<Map<String, Object>> result, Pagination pagination) {
        if (pagination == null) {
            return result;
        }
        return result.subList(pagination.getStart(), Math.min(pagination.getStart() + pagination.getLimit(), result.size()));
    }

    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        switch (this.getOperation()) {
            case READ: {
                return this.executeReadOperation(parameters, filters, pagination);
            }
            case INSERT: {
                return this.executeInsertOperation(parameters);
            }
        }
        throw new UnsupportedOperationException("DataSource operation not supported");
    }

    private CountedResult<Map<String, Object>> executeInsertOperation(Map<String, String> parameters) throws IOException {
        List<String> fileContentLines = this.resolveLineContent(parameters);
        if (FileLocation.ARCHIVE.equals((Object)this.fileLocation)) {
            String resolvedFilename = this.replaceInputParameter(this.filename, ParameterType.PATH_PARAM, this.inputParameters, parameters);
            String resolvedDocumentClassName = this.replaceInputParameter(this.documentClassName, ParameterType.PATH_PARAM, this.inputParameters, parameters);
            byte[] bytes = TextDataWriter.writeData(fileContentLines, this.charsetOption, this.newLineMode);
            DocumentDefinition documentDefinition = new DocumentDefinition();
            documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            documentDefinition.setFileName(resolvedFilename);
            documentDefinition.setUserName(ADMINISTRATOR_DEFAULT_USERNAME);
            DocumentClass documentClass = this.documentClassService.getDocumentClass(resolvedDocumentClassName, new String[0]);
            documentDefinition.setDocumentClassId(documentClass.getId());
            Map<Long, Object> indices = this.buildIndicesMap(documentClass.getId(), parameters, this.inputParameters);
            if (!indices.isEmpty()) {
                documentDefinition.setIndexes(indices);
            }
            WfDocument wfDocument = this.documentService.addDocument(documentDefinition);
            if (this.executeDocumentClassActions) {
                this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
            }
            ArrayList result = new ArrayList();
            HashMap<String, Long> fileId = new HashMap<String, Long>();
            fileId.put(FILE_ID_PARAMETER_ID, wfDocument.getFile().getId());
            result.add(fileId);
            return new CountedResult((long)result.size(), result);
        }
        String resolvedFilePath = this.resolveFilePath(parameters);
        log.info("Resolved file path: {}", (Object)resolvedFilePath);
        TextDataWriter.writeData(fileContentLines, resolvedFilePath, this.charsetOption, this.writeMode, this.newLineMode);
        return new CountedResult(0L, new ArrayList());
    }

    private CountedResult<Map<String, Object>> executeReadOperation(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) throws IOException {
        String resolvedFilePath = this.resolveFilePath(parameters);
        log.info("Resolved file path: {}", (Object)resolvedFilePath);
        ArrayList<String> lines = new ArrayList<String>(TextDataReader.readLines(resolvedFilePath, this.readSplitMode, this.charsetOption));
        if (lines.isEmpty()) {
            return new CountedResult(0L, new ArrayList());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        IntStream.range(0, lines.size()).forEach(index -> {
            HashMap line = new HashMap();
            line.put(FILE_CONTENT_PARAMETER_ID, lines.get(index));
            result.add(line);
        });
        this.applyFilters(result, filters);
        return new CountedResult((long)result.size(), this.applyPagination(result, pagination));
    }

    public String replaceInputParameter(String parameter, ParameterType parameterType, Set<InputParameter> inputParameters, Map<String, String> parameters) {
        for (InputParameter inputParameter : inputParameters) {
            if (!inputParameter.getParameterType().equals((Object)parameterType)) continue;
            parameter = parameter.replace("{" + inputParameter.getId() + "}", parameters.get(inputParameter.getId()));
        }
        return parameter;
    }

    private Map<Long, Object> buildIndicesMap(long documentClassId, Map<String, String> parameters, Set<InputParameter> inputParameters) {
        List classIndices = this.documentClassIndexFinder.findByDocumentClass(Long.valueOf(documentClassId));
        HashMap<Long, Object> indicesMap = new HashMap<Long, Object>();
        inputParameters.stream().filter(inputParameter -> ParameterType.INDEX_PARAM.equals((Object)inputParameter.getParameterType())).forEach(inputParameter -> {
            String indexName = inputParameter.getId();
            Optional<DocumentClassIndex> classIndex = classIndices.stream().filter(documentClassIndex -> documentClassIndex.getName().equalsIgnoreCase(indexName)).findAny();
            if (!classIndex.isPresent()) {
                log.info("Skipping incorrect index: {}", (Object)indexName);
                return;
            }
            String indexValue = (String)parameters.get(indexName);
            indicesMap.put(classIndex.get().getId(), classIndex.get().getType().parse(indexValue));
        });
        return indicesMap;
    }

    public Set<DataSourceParameter> getInputParameters() {
        return this.inputParameters.stream().map(inputParameter -> new DataSourceParameter(inputParameter.getId(), inputParameter.getName())).collect(Collectors.toSet());
    }

    public Set<DataSourceParameter> getOutputParameters() {
        switch (this.getOperation()) {
            case READ: {
                return Collections.singleton(new DataSourceParameter(FILE_CONTENT_PARAMETER_ID, "File content"));
            }
            case INSERT: {
                return Collections.singleton(new DataSourceParameter(FILE_ID_PARAMETER_ID, "File ID"));
            }
        }
        throw new UnsupportedOperationException("DataSource operation not supported");
    }

    private List<String> resolveLineContent(Map<String, String> parameters) {
        return this.inputParameters.stream().filter(inputParameter -> ParameterType.LINE_PARAM.equals((Object)inputParameter.getParameterType())).map(inputParameter -> (String)parameters.get(inputParameter.getId())).map(parameterContent -> parameterContent.split("\\R")).flatMap(Arrays::stream).map(parameterContent -> parameterContent.split(this.tabularDataSeparator)).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    private String resolveFilePath(Map<String, String> parameters) {
        boolean useFileId = StringUtils.isNotBlank((CharSequence)this.fileId);
        String basePath = useFileId ? this.fileId : this.filePath;
        String replacedPath = this.replaceInputParameter(basePath, ParameterType.PATH_PARAM, this.inputParameters, parameters);
        if (!useFileId) {
            return replacedPath;
        }
        long fileId = Long.parseLong(replacedPath);
        return this.fileService.getFile(Long.valueOf(fileId), new String[0]).getFullPath();
    }

    private String buildPathToFile(String filePath) {
        if (filePath.contains(PLUSWORKFLOW_HOME_TAG) && filePath.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            throw new IllegalArgumentException("File path only needs one {PWFL_HOME} or {WORKING_DIRECTORY} tag");
        }
        return filePath.replace(PLUSWORKFLOW_HOME_TAG, System.getProperty("plusworkflow.home")).replace(PLUSWORKFLOW_WORKING_DIRECTORY_TAG, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
    }

    private Set<InputParameter> buildInputParameters(String[] id, String[] name, String[] type) {
        Assert.isTrue((id.length == name.length && id.length == type.length ? 1 : 0) != 0, (String)"Parameters lists length mismatch!");
        return IntStream.range(0, id.length).mapToObj(i -> new InputParameter(id[i], name[i], ParameterType.valueOf(type[i]))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private CharsetOption getCharsetOption(String charset) {
        return CharsetUtils.buildCharsetOptionList().stream().filter(charsetOption -> StringUtils.equalsIgnoreCase((CharSequence)charsetOption.toString(), (CharSequence)charset)).findAny().orElseThrow(() -> new IllegalArgumentException("Incorrect charset selected"));
    }
}

