/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.api;

import com.suncode.plugin.datasource.text.enums.NewLineMode;
import com.suncode.plugin.datasource.text.utils.CharsetUtils;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class TextDatasourceController {
    @ResponseBody
    @RequestMapping(value={"/charset"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getCharset(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        List charsets = CharsetUtils.buildCharsetOptionList().stream().filter(entry -> StringUtils.containsIgnoreCase((CharSequence)entry.toString(), (CharSequence)query)).map(entry -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", entry.toString());
            return map;
        }).collect(Collectors.toList());
        int to = Math.min(start + limit, charsets.size());
        return new CountedResult((long)charsets.size(), charsets.subList(start, to));
    }

    @ResponseBody
    @RequestMapping(value={"/newline"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getNewLineMode() {
        List newLineModes = Arrays.stream(NewLineMode.values()).map(entry -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", entry.name());
            return map;
        }).collect(Collectors.toList());
        return new CountedResult((long)newLineModes.size(), newLineModes);
    }
}

