/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.utils;

import com.suncode.plugin.datasource.text.utils.CharsetOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CharsetUtils {
    public static List<CharsetOption> buildCharsetOptionList() {
        ArrayList<CharsetOption> list = new ArrayList<CharsetOption>();
        Map<String, Charset> filtered = Charset.availableCharsets().entrySet().stream().filter(entry -> !((String)entry.getKey()).toLowerCase().contains("bom")).filter(entry -> !((String)entry.getKey()).toLowerCase().startsWith("x-utf")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        filtered.values().forEach(charset -> list.add(new CharsetOption((Charset)charset, false)));
        list.add(new CharsetOption(StandardCharsets.UTF_8, true));
        list.add(new CharsetOption(StandardCharsets.UTF_16LE, true));
        list.add(new CharsetOption(StandardCharsets.UTF_16BE, true));
        list.add(new CharsetOption(Charset.forName("UTF-32LE"), true));
        list.add(new CharsetOption(Charset.forName("UTF-32BE"), true));
        return list;
    }

    private CharsetUtils() {
    }
}

