/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;

public final class BomUtils {
    public static void writeBom(OutputStream out, Charset charset) throws IOException {
        String charsetName;
        switch (charsetName = charset.name().toUpperCase(Locale.ROOT)) {
            case "UTF-8": {
                out.write(new byte[]{-17, -69, -65});
                return;
            }
            case "UTF-16LE": {
                out.write(new byte[]{-1, -2});
                return;
            }
            case "UTF-16BE": {
                out.write(new byte[]{-2, -1});
                return;
            }
            case "UTF-32LE": {
                out.write(new byte[]{-1, -2, 0, 0});
                return;
            }
            case "UTF-32BE": {
                out.write(new byte[]{0, 0, -2, -1});
            }
        }
    }

    public static boolean fileHasBom(Path path, Charset charset) throws IOException {
        if (!Files.exists(path, new LinkOption[0]) || Files.size(path) == 0L) {
            return false;
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            byte[] bytes = new byte[4];
            int buffer = inputStream.read(bytes);
            String charsetName = charset.name().toUpperCase(Locale.ROOT);
            if (buffer >= 3 && charsetName.equals("UTF-8")) {
                boolean bl = bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
                return bl;
            }
            if (buffer >= 2 && charsetName.equals("UTF-16LE")) {
                boolean bl = bytes[0] == -1 && bytes[1] == -2;
                return bl;
            }
            if (buffer >= 2 && charsetName.equals("UTF-16BE")) {
                boolean bl = bytes[0] == -2 && bytes[1] == -1;
                return bl;
            }
            if (buffer >= 4 && charsetName.equals("UTF-32LE")) {
                boolean bl = bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0;
                return bl;
            }
            if (buffer >= 4 && charsetName.equals("UTF-32BE")) {
                boolean bl = bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private BomUtils() {
    }
}

