/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.functions;

import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.annotation.Function;
import com.suncode.pwfl.core.function.annotation.Functions;
import com.suncode.pwfl.core.function.annotation.FunctionsScript;

@Functions
@FunctionsScript(value="dist/datasources/text/TextDataSourceFunctions/functions.js")
public class TextDataSourceFunctions {
    @Function(value="Text.padRight", accessibility=Function.FunctionAccessibility.ALL)
    public String padRight(String input, String character, int length) {
        return this.pad(input, character, length, false);
    }

    @Function(value="Text.padLeft", accessibility=Function.FunctionAccessibility.ALL)
    public String padLeft(String input, String character, int length) {
        return this.pad(input, character, length, true);
    }

    @Function(value="Text.padRight", accessibility=Function.FunctionAccessibility.ALL)
    public String[] padRight(String[] input, String character, int length) {
        if (input == null) {
            return new String[0];
        }
        String[] result = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = this.pad(input[i], character, length, false);
        }
        return result;
    }

    @Function(value="Text.padLeft", accessibility=Function.FunctionAccessibility.ALL)
    public String[] padLeft(String[] input, String character, int length) {
        if (input == null) {
            return new String[0];
        }
        String[] result = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = this.pad(input[i], character, length, true);
        }
        return result;
    }

    private String pad(String input, String character, int length, boolean atStart) {
        int paddingNeeded = length - input.length();
        if (paddingNeeded <= 0) {
            return input;
        }
        char paddingChar = character.charAt(0);
        StringBuilder padding = new StringBuilder(paddingNeeded);
        for (int i = 0; i < paddingNeeded; ++i) {
            padding.append(paddingChar);
        }
        return atStart ? padding.append(input).toString() : input + padding;
    }
}

