/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.utils;

import com.suncode.plugin.datasource.text.enums.WriteMode;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class TextDataWriter {
    public static void writeData(List<String> lines, String filePath, WriteMode writeMode) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        boolean append = WriteMode.APPEND.equals((Object)writeMode);
        if (append) {
            TextDataWriter.handleNewLine(path);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    private static void handleNewLine(Path path) throws IOException {
        byte last;
        if (Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L && (last = Files.readAllBytes(path)[(int)(Files.size(path) - 1L)]) != 10 && last != 13) {
            Files.write(path, System.lineSeparator().getBytes(), StandardOpenOption.APPEND);
        }
    }

    private TextDataWriter() {
    }
}

