/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.component;

import com.suncode.plugin.datasource.text.enums.WriteMode;
import com.suncode.plugin.datasource.text.parameters.InputParameter;
import com.suncode.plugin.datasource.text.parameters.enums.ParameterType;
import com.suncode.plugin.datasource.text.utils.TextDataWriter;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TextDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(TextDataSource.class);
    private static final String PLUSWORKFLOW_HOME_TAG = "{PWFL_HOME}";
    private static final String PLUSWORKFLOW_WORKING_DIRECTORY_TAG = "{WORKING_DIRECTORY}";
    private final Set<InputParameter> inputParameters;
    private final String pathToFile;
    private final WriteMode writeMode;
    private final String tabularDataSeparator;

    public TextDataSource(Parameters parameters) {
        this.tabularDataSeparator = (String)parameters.get("tabularDataSeparator", String.class);
        this.writeMode = WriteMode.valueOf((String)parameters.get("writeMode", String.class));
        this.pathToFile = this.buildPathToFile((String)parameters.get("filePath", String.class));
        this.inputParameters = this.buildInputParameters((String[])parameters.get("inputParameterId", String[].class), (String[])parameters.get("inputParameterName", String[].class), (String[])parameters.get("inputParameterType", String[].class));
    }

    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        if (!DataSourceOperation.INSERT.equals((Object)this.getOperation())) {
            throw new UnsupportedOperationException("DataSource operation not supported");
        }
        String resolvedFilePath = this.resolveFilePath(parameters);
        log.info("Resolved file path: {}", (Object)resolvedFilePath);
        List<String> lines = this.resolveLineContent(parameters);
        TextDataWriter.writeData(lines, resolvedFilePath, this.writeMode);
        return new CountedResult(0L, new ArrayList());
    }

    public Set<DataSourceParameter> getInputParameters() {
        return this.inputParameters.stream().map(inputParameter -> new DataSourceParameter(inputParameter.getId(), inputParameter.getName())).collect(Collectors.toSet());
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return Collections.emptySet();
    }

    private List<String> resolveLineContent(Map<String, String> parameters) {
        return this.inputParameters.stream().filter(inputParameter -> ParameterType.LINE_PARAM.equals((Object)inputParameter.getParameterType())).map(inputParameter -> (String)parameters.get(inputParameter.getId())).map(parameterContent -> parameterContent.split("\\R")).flatMap(Arrays::stream).map(parameterContent -> parameterContent.split(this.tabularDataSeparator)).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    private String resolveFilePath(Map<String, String> parameters) {
        StringBuilder resolvedPathToFile = new StringBuilder(this.pathToFile);
        this.inputParameters.stream().filter(inputParameter -> ParameterType.PATH_PARAM.equals((Object)inputParameter.getParameterType())).forEach(inputParameter -> this.replaceAll(resolvedPathToFile, "{" + inputParameter.getId() + "}", (String)parameters.get(inputParameter.getId())));
        return resolvedPathToFile.toString();
    }

    private void replaceAll(StringBuilder stringBuilder, String target, String replacement) {
        int start;
        while ((start = stringBuilder.indexOf(target)) != -1) {
            stringBuilder.replace(start, start + target.length(), replacement);
        }
    }

    private String buildPathToFile(String filePath) {
        if (filePath.contains(PLUSWORKFLOW_HOME_TAG) && filePath.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            throw new IllegalArgumentException("File path only needs one {PWFL_HOME} or {WORKING_DIRECTORY} tag");
        }
        return filePath.replace(PLUSWORKFLOW_HOME_TAG, System.getProperty("plusworkflow.home")).replace(PLUSWORKFLOW_WORKING_DIRECTORY_TAG, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
    }

    private Set<InputParameter> buildInputParameters(String[] id, String[] name, String[] type) {
        Assert.isTrue((id.length == name.length && id.length == type.length ? 1 : 0) != 0, (String)"Parameters lists length mismatch!");
        return IntStream.range(0, id.length).mapToObj(i -> new InputParameter(id[i], name[i], ParameterType.valueOf(type[i]))).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

