/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.symfonia.intergration.jdbc;

import com.plusmpm.CUF.database.externalDBConf.ExternalDBConf;
import com.plusmpm.CUF.database.externalDBConf.ExternalDBConfManager;
import com.suncode.plugin.symfonia.intergration.autotask.ExportC2FK;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ExternalConnectionManager {
    public static Logger log = Logger.getLogger(ExportC2FK.class);

    public static Connection getExternalDBConnection(String externalDBConfName) {
        Connection dbConnection = null;
        ExternalDBConf dbConfs = null;
        try {
            dbConfs = (ExternalDBConf)ExternalDBConfManager.getExternalDBConfForName((String)externalDBConfName).get(0);
            Class.forName(dbConfs.getDriver());
        }
        catch (Exception e) {
            log.debug((Object)("Niepoprawny sterownik lub nie mo\u017cna pobrac konfiguracji polaczenia o nazwie: " + externalDBConfName));
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            dbConnection = DriverManager.getConnection(dbConfs.getUrl(), dbConfs.getLogin(), dbConfs.getPassword());
            if (dbConnection != null && !dbConnection.isClosed()) {
                log.info((Object)("Uzyskano polaczenie z : " + dbConfs.getUrl()));
            } else {
                log.error((Object)"Brak polaczenia z zewnetrzna baza");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return dbConnection;
    }

    public static void executeUpdateQuery(Connection con, String sQuery) throws Exception {
        try (Statement stmt = null;){
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.supportsTransactionIsolationLevel(1)) {
                con.setTransactionIsolation(1);
            }
            stmt = con.createStatement();
            int affected = stmt.executeUpdate(sQuery);
            log.debug((Object)("Affected records: " + affected));
        }
    }

    public static void disconnect(Connection con) {
        try {
            if (con != null && !con.isClosed()) {
                con.close();
                log.info((Object)"Polaczenie z baza zamkniete");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

