/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.symfonia.intergration.algorythm;

import com.suncode.dbexplorer.database.DatabaseSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProcedureExecC2FK {
    public static Logger log = Logger.getLogger(ProcedureExecC2FK.class);
    private static final String PROC_QUERY_IMPORT_DK = "exec FK.sp_C21_importDK";
    private static final String PROC_QUERY_IMPORT_KH = "exec FK.sp_C21_importKH";
    private static final String PROC_QUERY_IMPORT_ES = "exec FK.sp_C21_importES";

    public Boolean sp_C21_importDK(DatabaseSession dbSession) throws SQLException {
        return this.procedureExec(dbSession, PROC_QUERY_IMPORT_DK);
    }

    public Boolean sp_C21_importDK(Connection con) throws SQLException {
        return this.procedureExec(con, PROC_QUERY_IMPORT_DK);
    }

    public Boolean sp_C21_importKH(DatabaseSession dbSession) throws SQLException {
        return this.procedureExec(dbSession, PROC_QUERY_IMPORT_KH);
    }

    public Boolean sp_C21_importKH(Connection con) throws SQLException {
        return this.procedureExec(con, PROC_QUERY_IMPORT_KH);
    }

    public Boolean sp_C21_importES(Connection con) throws SQLException {
        return this.procedureExec(con, PROC_QUERY_IMPORT_ES);
    }

    public Boolean sp_C21_importES(DatabaseSession dbSession) throws SQLException {
        return this.procedureExec(dbSession, PROC_QUERY_IMPORT_ES);
    }

    private Boolean procedureExec(DatabaseSession dbSession, String query) throws SQLException {
        boolean isOK = false;
        Connection conn = dbSession.getConnection();
        isOK = this.procedureExec(query, isOK, conn);
        return isOK;
    }

    private Boolean procedureExec(Connection conn, String query) throws SQLException {
        boolean isOK = false;
        isOK = this.procedureExec(query, isOK, conn);
        return isOK;
    }

    private Boolean procedureExec(String query, boolean isOK, Connection conn) throws SQLException {
        try {
            log.debug((Object)("ProcedureExecute:\t" + query));
            PreparedStatement pstmQuery = conn.prepareStatement(query);
            ResultSet rs = pstmQuery.executeQuery();
            isOK = true;
            this.resultLogs(rs);
        }
        catch (SQLException e) {
            log.debug((Object)("Error: " + e.getClass().getSimpleName()));
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return isOK;
    }

    private void resultLogs(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numColumns = rsmd.getColumnCount();
        while (rs.next()) {
            StringBuilder sBuilder = new StringBuilder("");
            for (int i = 1; i < numColumns + 1; ++i) {
                String columnName = rsmd.getColumnName(i);
                String oneValue = rs.getString(columnName);
                columnName = columnName.toLowerCase();
                if (oneValue == null) {
                    oneValue = "";
                }
                sBuilder.append("\t").append(columnName).append("\t:\t").append(oneValue).append("\n");
            }
            log.debug((Object)sBuilder.toString());
        }
    }
}

