/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.symfonia.intergration.algorythm;

import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.dbexplorer.database.SessionUnit;
import com.suncode.plugin.symfonia.intergration.algorythm.FormData;
import com.suncode.plugin.symfonia.intergration.algorythm.ProcedureExecC2FK;
import com.suncode.plugin.symfonia.intergration.algorythm.RejVatPojo;
import com.suncode.plugin.symfonia.intergration.dbexplorer.CRUD_C21_Dokumenty_Impl;
import com.suncode.plugin.symfonia.intergration.dbexplorer.CRUD_C21_rejVat_Impl;
import com.suncode.plugin.symfonia.intergration.dbexplorer.CRUD_C21_zapisy_Impl;
import com.suncode.plugin.symfonia.intergration.dbexplorer.CRUD_Symfonia;
import com.suncode.plugin.symfonia.intergration.entity.AbstractSymfoniaTable;
import com.suncode.plugin.symfonia.intergration.entity.C21_Dokumenty;
import com.suncode.plugin.symfonia.intergration.entity.C21_rejVat;
import com.suncode.plugin.symfonia.intergration.entity.C21_zapisy;
import com.suncode.plugin.symfonia.intergration.entity.SYS_NUMDOK;
import com.suncode.plugin.symfonia.intergration.exceptions.NoRecordException;
import com.suncode.plugin.symfonia.intergration.services.SYS_NUMDOK_Service;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.joda.time.DateTime;
import org.springframework.transaction.annotation.Transactional;

public class AlgorythmDB {
    public static Logger log = Logger.getLogger(AlgorythmDB.class);
    private FormData formData;
    private Short rokId;
    private Double wkwota;
    private Database db;
    private Database dbSystem;
    private Integer idDokumentu;
    private SYS_NUMDOK_Service sysNumDokService;

    public AlgorythmDB(FormData formData, Database db, Database dbSystem, SYS_NUMDOK_Service sysNumDokService) {
        this.db = db;
        this.dbSystem = dbSystem;
        this.formData = formData;
        this.rokId = this.getCurrentRokID();
        this.sysNumDokService = sysNumDokService;
        this.idDokumentu = this.getMaxDocID("id", "[FK].[C21_dokumenty]", formData.getProcessId());
        if (formData.getNumerDokumentu() == null) {
            formData.setNumerDokumentu(this.getNewNumerDokumentu(formData.getProcessId()));
        }
    }

    public void process() throws SQLException {
        try {
            log.debug((Object)"Algorytm Process");
            log.debug((Object)"Create C21_Dokumenty");
            C21_Dokumenty c21_dokumenty = this.createC21_Dokumenty();
            log.debug((Object)c21_dokumenty.toString());
            this.save21Dokumenty(c21_dokumenty);
            log.debug((Object)"Get actualy id for C21_Dokumenty");
            this.idDokumentu = this.getID(new CRUD_C21_Dokumenty_Impl(), c21_dokumenty);
            log.debug((Object)this.idDokumentu);
            log.debug((Object)"Create C21_Zapisy");
            List<C21_zapisy> c21ZapisyList = this.createC21_zapisy();
            this.saveC21Zapisy(c21ZapisyList, c21_dokumenty);
            if (!this.formData.getDocumentNOT().booleanValue()) {
                List<C21_rejVat> c21RejVatList = this.createC21RejVat();
                this.saveC21rejVat(c21RejVatList, c21ZapisyList, c21_dokumenty);
            }
            if (this.formData.getCzyAutoProcedura().booleanValue()) {
                this.db.withinSession(new SessionUnit(){

                    public Void doWork(DatabaseSession session) throws Exception {
                        AlgorythmDB.this.updateStatusDoc(session);
                        log.debug((Object)"Auto procedure sp_C21_importDK");
                        ProcedureExecC2FK procedure = new ProcedureExecC2FK();
                        Boolean isOK = procedure.sp_C21_importDK(session);
                        log.debug((Object)"TICK TAK");
                        log.debug((Object)("Procedure execute is OK?? : \t" + isOK));
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)"\n\n\nDELETE\n\n");
            log.debug((Object)("idDokumentu:" + this.idDokumentu));
            DatabaseSession session = this.db.openSession();
            log.debug((Object)"Delete rejVat");
            CRUD_Symfonia crudSymfonia = new CRUD_C21_rejVat_Impl();
            try {
                crudSymfonia.delete(session, "dokId", this.idDokumentu);
            }
            catch (NoRecordException e1) {
                log.debug((Object)e1.getMessage());
            }
            log.debug((Object)"Delete zapisy");
            crudSymfonia = new CRUD_C21_zapisy_Impl();
            try {
                crudSymfonia.delete(session, "dokId", this.idDokumentu);
            }
            catch (NoRecordException e1) {
                log.debug((Object)e1.getMessage());
            }
            log.debug((Object)"Delete Dokumenty");
            crudSymfonia = new CRUD_C21_Dokumenty_Impl();
            try {
                log.debug((Object)("Delete \t" + this.idDokumentu));
                crudSymfonia.delete(session, this.idDokumentu);
            }
            catch (NoRecordException e1) {
                log.debug((Object)e1.getMessage());
            }
            session.commit();
            if (session.isActive()) {
                session.getConnection().close();
            }
            throw e;
        }
    }

    private Integer getID(CRUD_Symfonia crud, AbstractSymfoniaTable table) throws SQLException {
        DatabaseSession session = this.db.openSession();
        Integer id = crud.getID(session, table);
        session.getConnection().close();
        return id;
    }

    private void updateStatusDoc(DatabaseSession session) throws Exception {
        log.debug((Object)"Update Status dok ");
        log.debug((Object)("idDokumentu:" + this.idDokumentu));
        log.debug((Object)"Update status C21_Dokumenty");
        CRUD_C21_Dokumenty_Impl crudSymfonia = new CRUD_C21_Dokumenty_Impl();
        crudSymfonia.updateStatus(session, this.idDokumentu, 0);
    }

    @Transactional
    protected void saveC21rejVat(final List<C21_rejVat> c21RejVatList, List<C21_zapisy> c21_zapisy, C21_Dokumenty c21_dokumenty) {
        this.db.withinSession(new SessionUnit(){
            private CRUD_Symfonia crudSymfonia;

            public Void doWork(DatabaseSession session) throws Exception {
                for (C21_rejVat c21_rejVat : c21RejVatList) {
                    this.crudSymfonia = new CRUD_C21_rejVat_Impl();
                    log.debug((Object)("Save C21_rejVat id:\t" + c21_rejVat.getId()));
                    this.crudSymfonia.create(session, (AbstractSymfoniaTable)c21_rejVat);
                }
                return null;
            }
        });
    }

    @Transactional
    protected void save21Dokumenty(final C21_Dokumenty c21_dokumenty) {
        this.db.withinSession(new SessionUnit(){
            private CRUD_C21_Dokumenty_Impl crudSymfonia;

            public Void doWork(DatabaseSession session) throws Exception {
                this.crudSymfonia = new CRUD_C21_Dokumenty_Impl();
                log.debug((Object)"Save  C21_dokumenty to DB");
                this.crudSymfonia.create(session, (AbstractSymfoniaTable)c21_dokumenty);
                return null;
            }
        });
    }

    @Transactional
    protected void saveC21Zapisy(final List<C21_zapisy> resoultList, C21_Dokumenty c21_dokumenty) {
        this.db.withinSession(new SessionUnit(){
            private CRUD_Symfonia crudSymfonia;

            public Void doWork(DatabaseSession session) throws Exception {
                for (C21_zapisy c21_zapisy1 : resoultList) {
                    this.crudSymfonia = new CRUD_C21_zapisy_Impl();
                    log.debug((Object)("Save C21_Zapis id:\t" + c21_zapisy1.getId()));
                    this.crudSymfonia.create(session, (AbstractSymfoniaTable)c21_zapisy1);
                }
                return null;
            }
        });
    }

    public C21_Dokumenty createC21_Dokumenty() {
        this.wkwota = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) ? 0.0 : this.formData.getKwotaDokumentuWWalucie();
        C21_Dokumenty c21_dok = new C21_Dokumenty(this.idDokumentu, this.rokId, this.formData.getSkrotDokumentu(), this.formData.getDataWrowadzeniaDokumentu(), this.formData.getKwotaDokumentuWPLN(), this.wkwota);
        c21_dok.setKontrahent(this.formData.getIdentyfikatorKontrahenta());
        c21_dok.setNumer(this.formData.getNumerDokumentu());
        c21_dok.setNazwa(this.formData.getNazwaDokumentu());
        c21_dok.setTresc(this.formData.getTresc());
        c21_dok.setDatadok(this.formData.getDataDokumentu());
        c21_dok.setDataOper(this.formData.getDataOperacjiGospodarczej());
        c21_dok.setDatawpl(this.formData.getDataWplywu());
        c21_dok.setWaluta(this.formData.getWaluta());
        c21_dok.setNazwaKor(this.formData.getNazwaKor());
        c21_dok.setSygnatura(this.formData.getSygnatura());
        c21_dok.setTerminPlatnosci(this.formData.getTerminPlatnosci());
        c21_dok.setTypRozrachunku(this.formData.getTypRozrachunkuDokumenty());
        this.assignIfNotNull(c21_dok::setMppFlags, this.formData.getMppFlags());
        this.assignIfNotNull(c21_dok::setKontoPlatnosci, this.formData.getKontoPlatnosci());
        this.assignIfNotNull(c21_dok::setDaneKh, this.formData.getDaneKh());
        this.assignIfNotNull(c21_dok::setKhNazwa, this.formData.getKhNazwa());
        this.assignIfNotNull(c21_dok::setKhNip, this.formData.getKhNip());
        this.assignIfNotNull(c21_dok::setKhKraj, this.formData.getKhKraj());
        this.assignIfNotNull(c21_dok::setKhMiejscowosc, this.formData.getKhMiejscowosc());
        this.assignIfNotNull(c21_dok::setKhUlica, this.formData.getKhUlica());
        this.assignIfNotNull(c21_dok::setKhDom, this.formData.getKhDom());
        this.assignIfNotNull(c21_dok::setKhLokal, this.formData.getKhLokal());
        this.assignIfNotNull(c21_dok::setKhKodPocztowy, this.formData.getKhKodPocztowy());
        this.assignIfNotNull(c21_dok::setKhPoczta, this.formData.getKhPoczta());
        this.assignIfNotNull(c21_dok::setZnacznik, this.formData.getZnacznik());
        this.assignIfNotNull(c21_dok::setKursCitPit, this.formData.getKursCitPit());
        this.assignIfNotNull(c21_dok::setKursVat, this.formData.getKursVat());
        this.assignIfNotNull(c21_dok::setDataOdprawy, this.formData.getDataOdprawy());
        this.assignIfNotNull(c21_dok::setNumerKsef, this.formData.getNumerKsef());
        this.assignIfNotNull(c21_dok::setDataWystawieniaKsef, this.formData.getDataWystawieniaKsef());
        this.assignIfNotNull(c21_dok::setPochodzenie, this.formData.getPochodzenie());
        this.assignIfNotNull(c21_dok::setZnacznikTran, this.formData.getZnacznikTran());
        this.assignIfNotNull(c21_dok::setGuidEarch, this.formData.getGuidEarch());
        this.assignIfNotNull(c21_dok::setNumerKsefKor, this.formData.getNumerKsefKor());
        log.debug((Object)("C21_Dokumenty " + c21_dok.toString()));
        return c21_dok;
    }

    private List<C21_zapisy> createC21_zapisy() {
        Object integerList;
        Number kwotaCzastkowa;
        Number number;
        Object c21_zapisy2;
        Object zapisy201;
        Double[] kwotaNettoCzastkowa = this.formData.getKwotaCzastkowa();
        String[] kontoSymfonia = this.formData.getKontoSymfonia();
        String[] mpk = this.formData.getMpkSymfonia();
        Double[] kwotaWWalucieCzastkowa = this.formData.getKwotaWWalucieCzastkowa();
        Integer idZapisy = this.getMaxID("id", "[FK].[C21_zapisy]");
        idZapisy = idZapisy == null ? 0 : idZapisy;
        ArrayList<C21_zapisy> resoultList = new ArrayList<C21_zapisy>();
        Short rozbicie = 0;
        String[] opisZapisy = this.formData.getOpis();
        if (this.formData.getGrupowaniePoKontoSymfonia().booleanValue()) {
            int i;
            HashMap<Object, Object> grupaKontoSymfonia = new HashMap<Object, Object>();
            zapisy201 = null;
            c21_zapisy2 = null;
            for (i = 0; i < kontoSymfonia.length; ++i) {
                Object integerList2;
                String kontoSynt = kontoSymfonia[i];
                if (!grupaKontoSymfonia.containsKey(kontoSynt)) {
                    Integer n = idZapisy;
                    Number number2 = idZapisy = Integer.valueOf(idZapisy + 1);
                    Short s = rozbicie;
                    rozbicie = (short)(rozbicie + 1);
                    number2 = rozbicie;
                    Double d = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? kwotaNettoCzastkowa[i] : kwotaWWalucieCzastkowa[i];
                    c21_zapisy2 = new C21_zapisy(idZapisy, this.idDokumentu, (short)0, rozbicie, (short)0, (short)0, kwotaNettoCzastkowa[i], d);
                    integerList2 = this.readSynt(kontoSymfonia[i]);
                    ((C21_zapisy)c21_zapisy2).setSynt(integerList2.get(0));
                    ((C21_zapisy)c21_zapisy2).setPoz1(integerList2.get(1));
                    ((C21_zapisy)c21_zapisy2).setPoz2(integerList2.get(2));
                    ((C21_zapisy)c21_zapisy2).setPoz3(integerList2.get(3));
                    ((C21_zapisy)c21_zapisy2).setPoz4(integerList2.get(4));
                    ((C21_zapisy)c21_zapisy2).setPoz5(integerList2.get(5));
                    ((C21_zapisy)c21_zapisy2).setWaluta(this.formData.getWaluta());
                    ((C21_zapisy)c21_zapisy2).setOpis(opisZapisy != null && opisZapisy.length > i ? opisZapisy[i] : null);
                    if (integerList2.get(0) == 301) {
                        ((C21_zapisy)c21_zapisy2).setTypRozrachunku((short)1);
                        ((C21_zapisy)c21_zapisy2).setTerminPlatnosci(this.formData.getTerminPlatnosci());
                    }
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar01, this.formData.getWymiar01());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar02, this.formData.getWymiar02());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar03, this.formData.getWymiar03());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar04, this.formData.getWymiar04());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar05, this.formData.getWymiar05());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar06, this.formData.getWymiar06());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar07, this.formData.getWymiar07());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar08, this.formData.getWymiar08());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar09, this.formData.getWymiar09());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar10, this.formData.getWymiar10());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setKurs, this.formData.getKurs());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setZnacznikTran, this.formData.getZnacznikTran());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                    grupaKontoSymfonia.put(kontoSynt, c21_zapisy2);
                } else {
                    c21_zapisy2 = (C21_zapisy)grupaKontoSymfonia.get(kontoSynt);
                    Double d = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? kwotaNettoCzastkowa[i] : kwotaWWalucieCzastkowa[i];
                    ((C21_zapisy)c21_zapisy2).setKwota(((C21_zapisy)c21_zapisy2).getKwota() + d);
                    ((C21_zapisy)c21_zapisy2).setWkwota(((C21_zapisy)c21_zapisy2).getWkwota() + kwotaWWalucieCzastkowa[i]);
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar01, this.formData.getWymiar01());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar02, this.formData.getWymiar02());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar03, this.formData.getWymiar03());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar04, this.formData.getWymiar04());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar05, this.formData.getWymiar05());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar06, this.formData.getWymiar06());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar07, this.formData.getWymiar07());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar08, this.formData.getWymiar08());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar09, this.formData.getWymiar09());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setWymiar10, this.formData.getWymiar10());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setKurs, this.formData.getKurs());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setZnacznikTran, this.formData.getZnacznikTran());
                    this.assignIfNotNull(((C21_zapisy)c21_zapisy2)::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                }
                if (i != 0) continue;
                String string = this.formData.getKonto201();
                log.debug((Object)"konto rozrachunkowe");
                log.debug((Object)string);
                integerList2 = rozbicie;
                number = rozbicie = Short.valueOf((short)(rozbicie + 1));
                integerList2 = idZapisy;
                idZapisy = idZapisy + 1;
                number = idZapisy;
                kwotaCzastkowa = this.formData.getKwotaBrutto();
                Double wKwotaCzastkowa = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? (Number)kwotaCzastkowa : (Number)this.formData.getKwotaBruttoWalucie();
                List<Integer> list = this.readSynt(string);
                zapisy201 = new C21_zapisy(idZapisy, this.idDokumentu, (short)0, rozbicie, (short)1, (short)0, (Double)kwotaCzastkowa, wKwotaCzastkowa);
                ((C21_zapisy)zapisy201).setSynt(list.get(0));
                ((C21_zapisy)zapisy201).setPoz1(list.get(1));
                ((C21_zapisy)zapisy201).setPoz2(list.get(2));
                ((C21_zapisy)zapisy201).setPoz3(list.get(3));
                ((C21_zapisy)zapisy201).setPoz4(list.get(4));
                ((C21_zapisy)zapisy201).setPoz5(list.get(5));
                ((C21_zapisy)zapisy201).setWaluta(this.formData.getWaluta());
                if (list.get(0) == 204 && this.formData.getWaluta() != null && !this.formData.getWaluta().equalsIgnoreCase("PLN")) {
                    ((C21_zapisy)zapisy201).setTypRozrachunku((short)1);
                    ((C21_zapisy)zapisy201).setTerminPlatnosci(this.formData.getTerminPlatnosci());
                }
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar01, this.formData.getWymiar01());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar02, this.formData.getWymiar02());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar03, this.formData.getWymiar03());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar04, this.formData.getWymiar04());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar05, this.formData.getWymiar05());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar06, this.formData.getWymiar06());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar07, this.formData.getWymiar07());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar08, this.formData.getWymiar08());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar09, this.formData.getWymiar09());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setWymiar10, this.formData.getWymiar10());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setKurs, this.formData.getKurs());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setZnacznikTran, this.formData.getZnacznikTran());
                this.assignIfNotNull(((C21_zapisy)zapisy201)::setKontoPlatnosci, this.formData.getKontoPlatnosci());
            }
            i = 0;
            for (C21_zapisy c21_zapisy : grupaKontoSymfonia.values()) {
                resoultList.add(c21_zapisy);
                if (i != 0) continue;
                resoultList.add((C21_zapisy)zapisy201);
                ++i;
            }
        } else {
            for (int i = 0; i < kontoSymfonia.length; ++i) {
                log.debug((Object)"kontoSymfonia");
                log.debug((Object)kontoSymfonia[i]);
                zapisy201 = rozbicie;
                rozbicie = (short)(rozbicie + 1);
                c21_zapisy2 = rozbicie;
                zapisy201 = idZapisy;
                idZapisy = idZapisy + 1;
                c21_zapisy2 = idZapisy;
                Double wkwotaCzastkowa = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? kwotaNettoCzastkowa[i] : kwotaWWalucieCzastkowa[i];
                Object c21_zapisy = new C21_zapisy(idZapisy, this.idDokumentu, (short)0, rozbicie, (short)0, (short)0, kwotaNettoCzastkowa[i], wkwotaCzastkowa);
                List<Integer> integerList4 = this.readSynt(kontoSymfonia[i]);
                ((C21_zapisy)c21_zapisy).setSynt(integerList4.get(0));
                ((C21_zapisy)c21_zapisy).setPoz1(integerList4.get(1));
                ((C21_zapisy)c21_zapisy).setPoz2(integerList4.get(2));
                ((C21_zapisy)c21_zapisy).setPoz3(integerList4.get(3));
                ((C21_zapisy)c21_zapisy).setPoz4(integerList4.get(4));
                ((C21_zapisy)c21_zapisy).setPoz5(integerList4.get(5));
                ((C21_zapisy)c21_zapisy).setWaluta(this.formData.getWaluta());
                ((C21_zapisy)c21_zapisy).setOpis(opisZapisy != null && opisZapisy.length > i ? opisZapisy[i] : null);
                if (integerList4.get(0) == 301) {
                    ((C21_zapisy)c21_zapisy).setTypRozrachunku((short)1);
                    ((C21_zapisy)c21_zapisy).setTerminPlatnosci(this.formData.getTerminPlatnosci());
                }
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar01, this.formData.getWymiar01());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar02, this.formData.getWymiar02());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar03, this.formData.getWymiar03());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar04, this.formData.getWymiar04());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar05, this.formData.getWymiar05());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar06, this.formData.getWymiar06());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar07, this.formData.getWymiar07());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar08, this.formData.getWymiar08());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar09, this.formData.getWymiar09());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar10, this.formData.getWymiar10());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setKurs, this.formData.getKurs());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setZnacznikTran, this.formData.getZnacznikTran());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                resoultList.add((C21_zapisy)c21_zapisy);
                if (i != 0) continue;
                String konto201 = this.formData.getKonto201();
                log.debug((Object)"konto 201");
                log.debug((Object)konto201);
                Short s = rozbicie;
                rozbicie = (short)(rozbicie + 1);
                kwotaCzastkowa = rozbicie;
                Integer n = idZapisy;
                idZapisy = idZapisy + 1;
                kwotaCzastkowa = idZapisy;
                Double d = this.formData.getKwotaBrutto();
                Double wKwotaCzastkowa = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? d : this.formData.getKwotaBruttoWalucie();
                c21_zapisy = new C21_zapisy(idZapisy, this.idDokumentu, (short)0, rozbicie, (short)1, (short)0, d, wKwotaCzastkowa);
                integerList4 = this.readSynt(konto201);
                ((C21_zapisy)c21_zapisy).setSynt(integerList4.get(0));
                ((C21_zapisy)c21_zapisy).setPoz1(integerList4.get(1));
                ((C21_zapisy)c21_zapisy).setPoz2(integerList4.get(2));
                ((C21_zapisy)c21_zapisy).setPoz3(integerList4.get(3));
                ((C21_zapisy)c21_zapisy).setPoz4(integerList4.get(4));
                ((C21_zapisy)c21_zapisy).setPoz5(integerList4.get(5));
                ((C21_zapisy)c21_zapisy).setWaluta(this.formData.getWaluta());
                if (integerList4.get(0) == 204 && this.formData.getWaluta() != null && !this.formData.getWaluta().equalsIgnoreCase("PLN")) {
                    ((C21_zapisy)c21_zapisy).setTypRozrachunku((short)1);
                    ((C21_zapisy)c21_zapisy).setTerminPlatnosci(this.formData.getTerminPlatnosci());
                }
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar01, this.formData.getWymiar01());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar02, this.formData.getWymiar02());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar03, this.formData.getWymiar03());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar04, this.formData.getWymiar04());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar05, this.formData.getWymiar05());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar06, this.formData.getWymiar06());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar07, this.formData.getWymiar07());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar08, this.formData.getWymiar08());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar09, this.formData.getWymiar09());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setWymiar10, this.formData.getWymiar10());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setKurs, this.formData.getKurs());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setZnacznikTran, this.formData.getZnacznikTran());
                this.assignIfNotNull(((C21_zapisy)c21_zapisy)::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                resoultList.add((C21_zapisy)c21_zapisy);
            }
        }
        Double kwotaVat = 0.0;
        Double[] vatCzastkowy = this.formData.getVatCzastkowy();
        for (Double d : vatCzastkowy) {
            kwotaVat = kwotaVat + d;
        }
        if ((kwotaVat != 0.0 || StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN")) && !this.formData.getDocumentNOT().booleanValue()) {
            Object integerList5;
            String konto221 = this.formData.getKonto221();
            if (konto221 != null) {
                Double[] wVatCzastkowy;
                log.debug((Object)"konto 221");
                log.debug((Object)konto221);
                Number integerList4 = rozbicie;
                Number konto201 = rozbicie = Short.valueOf((short)(rozbicie + 1));
                integerList4 = idZapisy;
                idZapisy = idZapisy + 1;
                konto201 = idZapisy;
                Double wkwotaVat = 0.0;
                for (Double d : wVatCzastkowy = this.formData.getWVatCzastkowy()) {
                    wkwotaVat = wkwotaVat + d;
                }
                Double d = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? kwotaVat : wkwotaVat;
                C21_zapisy c21_zapisy3 = new C21_zapisy(idZapisy, this.idDokumentu, (short)0, rozbicie, (short)0, (short)0, kwotaVat, d);
                integerList5 = this.readSynt(konto221);
                c21_zapisy3.setWaluta(this.formData.getWaluta());
                c21_zapisy3.setSynt((Integer)integerList5.get(0));
                c21_zapisy3.setPoz1((Integer)integerList5.get(1));
                c21_zapisy3.setPoz2((Integer)integerList5.get(2));
                c21_zapisy3.setPoz3((Integer)integerList5.get(3));
                c21_zapisy3.setPoz4((Integer)integerList5.get(4));
                c21_zapisy3.setPoz5((Integer)integerList5.get(5));
                this.assignIfNotNull(c21_zapisy3::setWymiar01, this.formData.getWymiar01());
                this.assignIfNotNull(c21_zapisy3::setWymiar02, this.formData.getWymiar02());
                this.assignIfNotNull(c21_zapisy3::setWymiar03, this.formData.getWymiar03());
                this.assignIfNotNull(c21_zapisy3::setWymiar04, this.formData.getWymiar04());
                this.assignIfNotNull(c21_zapisy3::setWymiar05, this.formData.getWymiar05());
                this.assignIfNotNull(c21_zapisy3::setWymiar06, this.formData.getWymiar06());
                this.assignIfNotNull(c21_zapisy3::setWymiar07, this.formData.getWymiar07());
                this.assignIfNotNull(c21_zapisy3::setWymiar08, this.formData.getWymiar08());
                this.assignIfNotNull(c21_zapisy3::setWymiar09, this.formData.getWymiar09());
                this.assignIfNotNull(c21_zapisy3::setWymiar10, this.formData.getWymiar10());
                this.assignIfNotNull(c21_zapisy3::setKurs, this.formData.getKurs());
                this.assignIfNotNull(c21_zapisy3::setZnacznikTran, this.formData.getZnacznikTran());
                this.assignIfNotNull(c21_zapisy3::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                resoultList.add(c21_zapisy3);
            } else {
                String[] konto221Lista = this.formData.getKonto221Lista();
                Map<String, Double> pogrupowaneKontoVAT = this.groupKontoVat(konto221Lista, vatCzastkowy);
                for (String kontoVat : pogrupowaneKontoVAT.keySet()) {
                    log.debug((Object)" konto221Lista");
                    integerList5 = rozbicie;
                    Short s = rozbicie = Short.valueOf((short)(rozbicie + 1));
                    integerList5 = idZapisy;
                    Integer n = idZapisy = Integer.valueOf(idZapisy + 1);
                    Double vat = pogrupowaneKontoVAT.get(kontoVat);
                    C21_zapisy c21_zapisy = new C21_zapisy(idZapisy, this.idDokumentu, (short)1, rozbicie, (short)0, (short)0, vat, 0.0);
                    integerList = this.readSynt(kontoVat);
                    c21_zapisy.setWaluta(this.formData.getWaluta());
                    c21_zapisy.setSynt(integerList.get(0));
                    c21_zapisy.setPoz1(integerList.get(1));
                    c21_zapisy.setPoz2(integerList.get(2));
                    c21_zapisy.setPoz3(integerList.get(3));
                    c21_zapisy.setPoz4(integerList.get(4));
                    c21_zapisy.setPoz5(integerList.get(5));
                    this.assignIfNotNull(c21_zapisy::setWymiar01, this.formData.getWymiar01());
                    this.assignIfNotNull(c21_zapisy::setWymiar02, this.formData.getWymiar02());
                    this.assignIfNotNull(c21_zapisy::setWymiar03, this.formData.getWymiar03());
                    this.assignIfNotNull(c21_zapisy::setWymiar04, this.formData.getWymiar04());
                    this.assignIfNotNull(c21_zapisy::setWymiar05, this.formData.getWymiar05());
                    this.assignIfNotNull(c21_zapisy::setWymiar06, this.formData.getWymiar06());
                    this.assignIfNotNull(c21_zapisy::setWymiar07, this.formData.getWymiar07());
                    this.assignIfNotNull(c21_zapisy::setWymiar08, this.formData.getWymiar08());
                    this.assignIfNotNull(c21_zapisy::setWymiar09, this.formData.getWymiar09());
                    this.assignIfNotNull(c21_zapisy::setWymiar10, this.formData.getWymiar10());
                    this.assignIfNotNull(c21_zapisy::setKurs, this.formData.getKurs());
                    this.assignIfNotNull(c21_zapisy::setZnacznikTran, this.formData.getZnacznikTran());
                    this.assignIfNotNull(c21_zapisy::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                    resoultList.add(c21_zapisy);
                }
            }
        }
        rozbicie = 0;
        if (this.formData.getZapisRownolegly().booleanValue()) {
            for (int i = 0; i < mpk.length; ++i) {
                String konto490;
                log.debug((Object)" mpk");
                log.debug((Object)mpk[i]);
                Integer konto221Lista = idZapisy;
                Integer pogrupowaneKontoVAT = idZapisy = Integer.valueOf(idZapisy + 1);
                Double kwotaCzastkowa3 = kwotaNettoCzastkowa[i];
                Double wkwotaCzastkowa = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? kwotaCzastkowa3 : kwotaWWalucieCzastkowa[i];
                C21_zapisy c21_zapisy = new C21_zapisy(idZapisy, this.idDokumentu, (short)1, rozbicie, (short)0, this.formData.getZapsisRwonoleglyDla5(), kwotaCzastkowa3, wkwotaCzastkowa);
                List<Integer> integerList2 = this.readSynt(mpk[i]);
                c21_zapisy.setWaluta(this.formData.getWaluta());
                c21_zapisy.setSynt(integerList2.get(0));
                c21_zapisy.setPoz1(integerList2.get(1));
                c21_zapisy.setPoz2(integerList2.get(2));
                c21_zapisy.setPoz3(integerList2.get(3));
                c21_zapisy.setPoz4(integerList2.get(4));
                c21_zapisy.setPoz5(integerList2.get(5));
                c21_zapisy.setOpis(opisZapisy != null && opisZapisy.length > i ? opisZapisy[i] : null);
                if (integerList2.get(0) == 301) {
                    c21_zapisy.setTypRozrachunku((short)1);
                    c21_zapisy.setTerminPlatnosci(this.formData.getTerminPlatnosci());
                }
                this.assignIfNotNull(c21_zapisy::setWymiar01, this.formData.getWymiar01());
                this.assignIfNotNull(c21_zapisy::setWymiar02, this.formData.getWymiar02());
                this.assignIfNotNull(c21_zapisy::setWymiar03, this.formData.getWymiar03());
                this.assignIfNotNull(c21_zapisy::setWymiar04, this.formData.getWymiar04());
                this.assignIfNotNull(c21_zapisy::setWymiar05, this.formData.getWymiar05());
                this.assignIfNotNull(c21_zapisy::setWymiar06, this.formData.getWymiar06());
                this.assignIfNotNull(c21_zapisy::setWymiar07, this.formData.getWymiar07());
                this.assignIfNotNull(c21_zapisy::setWymiar08, this.formData.getWymiar08());
                this.assignIfNotNull(c21_zapisy::setWymiar09, this.formData.getWymiar09());
                this.assignIfNotNull(c21_zapisy::setWymiar10, this.formData.getWymiar10());
                this.assignIfNotNull(c21_zapisy::setKurs, this.formData.getKurs());
                this.assignIfNotNull(c21_zapisy::setZnacznikTran, this.formData.getZnacznikTran());
                this.assignIfNotNull(c21_zapisy::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                resoultList.add(c21_zapisy);
                if (i == 0 && (konto490 = this.formData.getKonto490()) != null) {
                    log.debug((Object)"konto490");
                    Short s = rozbicie;
                    rozbicie = (short)(rozbicie + 1);
                    integerList = rozbicie;
                    Integer n = idZapisy;
                    idZapisy = idZapisy + 1;
                    integerList = idZapisy;
                    Double d = this.formData.getKwotaNetto();
                    Double wkwotaCzastkowa490 = StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? d : this.formData.getKwotaNettoWalucie();
                    C21_zapisy c21_zapisy490 = new C21_zapisy(idZapisy, this.idDokumentu, (short)1, rozbicie, (short)1, this.formData.getZapsisRwonoleglyDla4(), d, wkwotaCzastkowa490);
                    List<Integer> integerList490 = this.readSynt(konto490);
                    c21_zapisy490.setWaluta(this.formData.getWaluta());
                    c21_zapisy490.setSynt(integerList490.get(0));
                    c21_zapisy490.setPoz1(integerList490.get(1));
                    c21_zapisy490.setPoz2(integerList490.get(2));
                    c21_zapisy490.setPoz3(integerList490.get(3));
                    c21_zapisy490.setPoz4(integerList490.get(4));
                    c21_zapisy490.setPoz5(integerList490.get(5));
                    this.assignIfNotNull(c21_zapisy490::setWymiar01, this.formData.getWymiar01());
                    this.assignIfNotNull(c21_zapisy490::setWymiar02, this.formData.getWymiar02());
                    this.assignIfNotNull(c21_zapisy490::setWymiar03, this.formData.getWymiar03());
                    this.assignIfNotNull(c21_zapisy490::setWymiar04, this.formData.getWymiar04());
                    this.assignIfNotNull(c21_zapisy490::setWymiar05, this.formData.getWymiar05());
                    this.assignIfNotNull(c21_zapisy490::setWymiar06, this.formData.getWymiar06());
                    this.assignIfNotNull(c21_zapisy490::setWymiar07, this.formData.getWymiar07());
                    this.assignIfNotNull(c21_zapisy490::setWymiar08, this.formData.getWymiar08());
                    this.assignIfNotNull(c21_zapisy490::setWymiar09, this.formData.getWymiar09());
                    this.assignIfNotNull(c21_zapisy490::setWymiar10, this.formData.getWymiar10());
                    this.assignIfNotNull(c21_zapisy490::setKurs, this.formData.getKurs());
                    this.assignIfNotNull(c21_zapisy490::setZnacznikTran, this.formData.getZnacznikTran());
                    this.assignIfNotNull(c21_zapisy490::setKontoPlatnosci, this.formData.getKontoPlatnosci());
                    resoultList.add(c21_zapisy490);
                }
                number = rozbicie;
                Short s = rozbicie = Short.valueOf((short)(rozbicie + 1));
            }
        }
        for (C21_zapisy c21_zapisy22 : resoultList) {
            log.debug((Object)("C21_zapisy: \t" + c21_zapisy22.toString()));
        }
        return resoultList;
    }

    private List<C21_rejVat> createC21RejVat() {
        Map<Double, RejVatPojo> groupRates = this.groupRates();
        ArrayList<C21_rejVat> result = new ArrayList<C21_rejVat>();
        Integer id = this.getMaxID("id", "FK.C21_rejVat") + 1;
        Integer rejId = this.formData.getRejId();
        for (Double rate : groupRates.keySet()) {
            RejVatPojo rateObj = groupRates.get(rate);
            DateTime okres = this.formData.getOkres();
            Double netto = rateObj.getKwotaNetto();
            Double wNetto = rateObj.getWKwotaNetto();
            Double brutto = netto + rateObj.getKwotaVat();
            Double wBrutto = wNetto + rateObj.getWKwotaVat();
            C21_rejVat c21RejVat = new C21_rejVat();
            c21RejVat.setDokId(this.idDokumentu);
            c21RejVat.setOczek(0);
            c21RejVat.setAbc((short)1);
            c21RejVat.setNienaliczany((short)0);
            c21RejVat.setZnacznik(null);
            c21RejVat.setVat(rateObj.getKwotaVat());
            c21RejVat.setVatWaluta(StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? rateObj.getKwotaVat() : rateObj.getWKwotaVat());
            c21RejVat.setOkres(okres);
            c21RejVat.setBrutto(brutto);
            c21RejVat.setBruttoWaluta(StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? brutto : wBrutto);
            c21RejVat.setId(id);
            c21RejVat.setNetto(netto);
            c21RejVat.setNettoWaluta(StringUtils.isBlank((CharSequence)this.formData.getWaluta()) || this.formData.getWaluta().equalsIgnoreCase("PLN") ? netto : wNetto);
            c21RejVat.setRejId(rejId);
            c21RejVat.setStawka(rate);
            this.assignIfNotNull(c21RejVat::setAtrJpkV7, this.formData.getAtrJpkV7());
            this.assignIfNotNull(c21RejVat::setKrajDostawy, this.formData.getKrajDostawy());
            this.assignIfNotNull(c21RejVat::setKrajWysylki, this.formData.getKrajWysylki());
            this.assignIfNotNull(c21RejVat::setRodzajDostawy, this.formData.getRodzajDostawy());
            this.assignIfNotNull(c21RejVat::setKorektaOss, this.formData.getKorektaOSS());
            result.add(c21RejVat);
            Integer n = id;
            Integer n2 = id = Integer.valueOf(id + 1);
        }
        return result;
    }

    private Map<Double, RejVatPojo> groupRates() {
        HashMap<Double, RejVatPojo> result = new HashMap<Double, RejVatPojo>();
        Double[] stawki = this.formData.getStawki();
        Double[] netto = this.formData.getKwotaCzastkowa();
        Double[] kwotaVat = this.formData.getVatCzastkowy();
        Double[] wKwotaVat = this.formData.getWVatCzastkowy();
        Double[] wNetto = this.formData.getKwotaWWalucieCzastkowa();
        for (int i = 0; i < stawki.length; ++i) {
            Double stawka = stawki[i];
            if (!result.containsKey(stawka)) {
                result.put(stawka, new RejVatPojo());
            }
            RejVatPojo rejVatPojo = (RejVatPojo)result.get(stawka);
            if (i < netto.length && netto[i] != null) {
                rejVatPojo.setKwotaNetto(netto[i] + rejVatPojo.getKwotaNetto());
            }
            if (i < kwotaVat.length && kwotaVat[i] != null) {
                rejVatPojo.setKwotaVat(kwotaVat[i] + rejVatPojo.getKwotaVat());
            }
            if (i < wKwotaVat.length && wKwotaVat[i] != null) {
                rejVatPojo.setWKwotaVat(wKwotaVat[i] + rejVatPojo.getWKwotaVat());
            }
            if (i < wNetto.length && wNetto[i] != null) {
                rejVatPojo.setWKwotaNetto(wNetto[i] + rejVatPojo.getWKwotaNetto());
            }
            result.put(stawka, rejVatPojo);
        }
        return result;
    }

    private Map<String, Double> groupKontoVat(String[] kontoVatLista, Double[] vatCzastkowy) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < kontoVatLista.length; ++i) {
            String key = kontoVatLista[i];
            if (!result.containsKey(key)) {
                result.put(key, new Double(0.0));
            }
            Double vat = 0.0;
            if (i < vatCzastkowy.length && vatCzastkowy[i] != null) {
                vat = vatCzastkowy[i];
            }
            result.put(key, (Double)result.get(key) + vat);
        }
        return result;
    }

    private Integer getMaxID(String idName, String tableName) {
        log.debug((Object)"getMaxID()");
        Integer result = 0;
        try {
            DatabaseSession dbSession = this.db.openSession();
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT max( \"").append(idName).append("\" ) FROM ").append(tableName).append(" ;");
            String sqlQueryString = sBuilder.toString();
            SQLQuery sqlQuery = dbSession.hibernateSession().createSQLQuery(sqlQueryString);
            Object maxId = sqlQuery.uniqueResult();
            result = (Integer)maxId;
            dbSession.getConnection().close();
        }
        catch (Exception e) {
            result = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return result == null ? 0 : result;
    }

    private Integer getMaxDocID(String idName, String tableName, String processId) {
        log.debug((Object)"getMaxID()");
        Integer result = 0;
        try {
            DatabaseSession dbSession = this.db.openSession();
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT max( \"").append(idName).append("\" ) FROM ").append(tableName).append(" ;");
            String sqlQueryString = sBuilder.toString();
            SQLQuery sqlQuery = dbSession.hibernateSession().createSQLQuery(sqlQueryString);
            Object maxId = sqlQuery.uniqueResult();
            result = maxId != null ? Integer.valueOf((Integer)maxId + 1) : null;
            dbSession.getConnection().close();
        }
        catch (Exception e) {
            result = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        result = this.checkReserveDocID(result, processId);
        return result == null ? 0 : result;
    }

    private Integer getMaxNumerDokumentu() {
        log.debug((Object)"getMaxNumerDokumentu()");
        Integer result = 0;
        log.debug((Object)"TICK TAK");
        try {
            DatabaseSession dbSession = this.db.openSession();
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT max(a.numer) numer FROM ( SELECT max(numer) numer FROM FK.dokumenty UNION SELECT max(numer) numer FROM FK.C21_dokumenty ) a");
            String sqlQueryString = sBuilder.toString();
            SQLQuery sqlQuery = dbSession.hibernateSession().createSQLQuery(sqlQueryString);
            Object maxId = sqlQuery.uniqueResult();
            result = (Integer)maxId;
            dbSession.getConnection().close();
        }
        catch (Exception e) {
            result = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return result == null ? 0 : result;
    }

    private Integer getNewNumerDokumentu(String processId) {
        log.debug((Object)"getMaxNumerDokumentu()");
        Integer result = 0;
        try {
            DatabaseSession dbSession = this.db.openSession();
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT MAX(numer) AS numer FROM FK.dokumenty ").append("WHERE rokId = :rokId AND skrot = :skrot");
            String sqlQueryString = sBuilder.toString();
            log.debug((Object)sqlQueryString);
            SQLQuery sqlQuery = dbSession.hibernateSession().createSQLQuery(sqlQueryString);
            sqlQuery.setParameter("rokId", (Object)this.rokId);
            sqlQuery.setParameter("skrot", (Object)this.formData.getSkrotDokumentu());
            Object maxId = sqlQuery.uniqueResult();
            result = maxId != null ? Integer.valueOf((Integer)maxId + 1) : 1;
            dbSession.getConnection().close();
        }
        catch (Exception e) {
            result = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
        result = this.checkReserveNumber(result, processId, this.formData.getSkrotDokumentu(), this.rokId);
        return result == null ? 1 : result;
    }

    @Transactional
    protected Integer checkReserveNumber(Integer result, String processId, String skrotDokumentu, Short rokId) {
        log.debug((Object)"checkReserveDocID");
        try {
            DatabaseSession dbSession = this.dbSystem.openSession();
            SYS_NUMDOK processEntity = this.sysNumDokService.getEntityByProcessId(processId);
            if (processEntity == null) {
                SYS_NUMDOK maxNumDOcEntity = this.sysNumDokService.getMaxNumDocBySkrotAndRok(skrotDokumentu, rokId);
                if (maxNumDOcEntity != null && maxNumDOcEntity.getNumerDoc() >= result) {
                    result = maxNumDOcEntity.getNumerDoc() + 1;
                }
                SYS_NUMDOK entity = new SYS_NUMDOK();
                entity.setProcessID(processId);
                entity.setNumerDoc(result);
                entity.setSkrotDokumentu(skrotDokumentu);
                entity.setRokId(rokId);
                log.debug((Object)"Save to cust table");
                this.sysNumDokService.save(entity);
                dbSession.getConnection().close();
                log.debug((Object)("Number dok: " + result));
                return result;
            }
            if (processEntity.getNumerDoc() == null) {
                SYS_NUMDOK maxNumDOcEntity = this.sysNumDokService.getMaxNumDocBySkrotAndRok(skrotDokumentu, rokId);
                if (maxNumDOcEntity != null && maxNumDOcEntity.getNumerDoc() >= result) {
                    result = maxNumDOcEntity.getNumerDoc() + 1;
                }
                processEntity.setNumerDoc(result);
                processEntity.setSkrotDokumentu(skrotDokumentu);
                processEntity.setRokId(rokId);
                log.debug((Object)"Update to cust table");
                this.sysNumDokService.update(processEntity);
                dbSession.getConnection().close();
                return result;
            }
            log.debug((Object)("Return saved value " + processEntity.getNumerDoc()));
            return processEntity.getNumerDoc();
        }
        catch (Exception e) {
            result = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Transactional
    protected Integer checkReserveDocID(Integer docId, String processId) {
        log.debug((Object)"checkReserveDocID");
        try {
            DatabaseSession dbSession = this.dbSystem.openSession();
            SYS_NUMDOK processEntity = this.sysNumDokService.getEntityByProcessId(processId);
            if (processEntity == null) {
                SYS_NUMDOK maxNumDOcEntity = this.sysNumDokService.getMaxDokId();
                if (maxNumDOcEntity != null && maxNumDOcEntity.getDokID() >= docId) {
                    docId = maxNumDOcEntity.getDokID() + 1;
                }
                SYS_NUMDOK entity = new SYS_NUMDOK();
                entity.setDokID(docId);
                entity.setProcessID(processId);
                log.debug((Object)"Save cust table");
                this.sysNumDokService.save(entity);
                dbSession.getConnection().close();
                log.debug((Object)("DokId: " + docId));
                return docId;
            }
            if (processEntity.getDokID() == null) {
                SYS_NUMDOK maxNumDOcEntity = this.sysNumDokService.getMaxDokId();
                if (maxNumDOcEntity != null && maxNumDOcEntity.getDokID() >= docId) {
                    docId = maxNumDOcEntity.getDokID() + 1;
                }
                processEntity.setDokID(docId);
                log.debug((Object)("Number dok: " + docId));
                log.debug((Object)"Update cust table");
                this.sysNumDokService.update(processEntity);
                dbSession.getConnection().close();
                return docId;
            }
            log.debug((Object)("Return saved value" + processEntity.getNumerDoc()));
            return processEntity.getDokID();
        }
        catch (Exception e) {
            docId = 0;
            log.debug((Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private Short getCurrentRokID() {
        log.debug((Object)"getCurrentRokID()");
        short currentRokID = -1;
        String tableName = this.formData.getTableNameRokID();
        log.debug((Object)"TICK TAK");
        try {
            DatabaseSession dbSession = this.dbSystem.openSession();
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("SELECT rok, rokid FROM ").append(tableName).append(" WHERE id=1");
            String sqlQueryString = sBuilder.toString();
            SQLQuery sqlQuery = dbSession.hibernateSession().createSQLQuery(sqlQueryString);
            Object[] result = (Object[])sqlQuery.uniqueResult();
            log.debug((Object)"Read value:");
            Short startYear = (Short)result[0];
            Short startRokID = (Short)result[1];
            log.debug((Object)("StartYear\t" + startYear + "\tStartRokId\t" + startRokID));
            currentRokID = (short)(this.formData.getRokKsiegowania().shortValue() - startYear + startRokID);
            dbSession.getConnection().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.debug((Object)("currenrRokID:\t" + currentRokID));
        return currentRokID;
    }

    private List<Integer> readSynt(String syntString) {
        String[] splitArray;
        log.debug((Object)("Read Synt: " + syntString));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String string : splitArray = syntString.split("-")) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            result.add(Integer.parseInt(string));
        }
        for (int i = result.size(); i < 6; ++i) {
            result.add(0);
        }
        return result;
    }

    private <T> void assignIfNotNull(Consumer<T> setter, T value) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

