/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.tools;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.suncode.plugin.scheduldedtask.workflow.utils.WorkflowArrayUtils;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    private static final Logger log = LoggerFactory.getLogger(Converter.class);

    public static ListMultimap<String, Object> convertMapListToMultimap(List<Map<String, Object>> listOfMaps) {
        ArrayListMultimap transformedMap = ArrayListMultimap.create();
        listOfMaps.stream().flatMap(row -> row.entrySet().stream()).forEachOrdered(arg_0 -> Converter.lambda$convertMapListToMultimap$1((ListMultimap)transformedMap, arg_0));
        return transformedMap;
    }

    public static String cellToString(Cell cell) {
        if (cell != null) {
            if (cell.getCellType() == CellType.FORMULA) {
                switch (cell.getCachedFormulaResultType()) {
                    case NUMERIC: {
                        return String.valueOf(cell.getNumericCellValue());
                    }
                    case BOOLEAN: {
                        boolean booleanValue = cell.getBooleanCellValue();
                        return Boolean.toString(booleanValue);
                    }
                }
                String str = cell.getStringCellValue();
                return Converter.removeQuotes(str);
            }
            return cell.getStringCellValue();
        }
        return null;
    }

    public static Object excelToString(Cell cell, IndexType type) throws ParseException {
        if (cell == null || StringUtils.isBlank((CharSequence)cell.toString())) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                if (cell.getCellType() == CellType.BOOLEAN) {
                    return cell.getBooleanCellValue();
                }
                if (cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() != CellType.NUMERIC) {
                    String str = cell.getStringCellValue();
                    return Converter.removeQuotes(str);
                }
                return cell.getStringCellValue();
            }
            case DATETIME: {
                Date date;
                if (cell.getCellType() == CellType.STRING) {
                    String str = cell.toString();
                    date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
                } else {
                    date = cell.getDateCellValue();
                }
                return date == null ? null : new Timestamp(date.getTime());
            }
            case LIST: {
                String str = cell.getStringCellValue();
                if (cell.getCellType() == CellType.FORMULA) {
                    str = Converter.removeQuotes(str);
                }
                return str;
            }
            case DOUBLE: {
                return cell.getNumericCellValue();
            }
            case LONG: {
                Double number = cell.getNumericCellValue();
                return number.longValue();
            }
            case DATE: {
                if (cell.getCellType() == CellType.STRING) {
                    String str = cell.toString();
                    return new SimpleDateFormat("yyyy-MM-dd").parse(str);
                }
                return cell.getDateCellValue();
            }
            case STRING: {
                if (cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() != CellType.NUMERIC) {
                    String str = cell.getStringCellValue();
                    return Converter.removeQuotes(str);
                }
                if (cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() == CellType.NUMERIC) {
                    Double number = cell.getNumericCellValue();
                    return Double.toString(number);
                }
                return cell.getStringCellValue();
            }
        }
        log.debug("Not supported type: " + type);
        return null;
    }

    public static Object convertObject2ProcessObj(Object toConvert, ProcessIndex processIndex) throws ParseException {
        if (toConvert == null) {
            return null;
        }
        log.debug("\n" + toConvert + "\t" + processIndex.getType().toString());
        String stringValue = toConvert.toString();
        switch (processIndex.getType()) {
            case BOOLEAN: {
                return !StringUtils.isBlank((CharSequence)stringValue) && ("true".equalsIgnoreCase(stringValue) || stringValue.equals("1"));
            }
            case DATE: {
                if (StringUtils.isBlank((CharSequence)stringValue)) {
                    return null;
                }
                if (toConvert instanceof Timestamp) {
                    Timestamp stamp = (Timestamp)toConvert;
                    return new Date(stamp.getTime());
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                return df.parse(stringValue);
            }
            case DOUBLE: {
                return StringUtils.isBlank((CharSequence)stringValue) ? 0.0 : Double.parseDouble(stringValue);
            }
            case INTEGER: {
                return StringUtils.isBlank((CharSequence)stringValue) ? 0L : Long.parseLong(stringValue);
            }
            case STRING: {
                if (StringUtils.isBlank((CharSequence)stringValue)) {
                    return null;
                }
                if (toConvert instanceof Timestamp) {
                    Timestamp stamp = (Timestamp)toConvert;
                    return new SimpleDateFormat("yyyy-MM-dd").format(stamp);
                }
                return stringValue;
            }
        }
        throw new IllegalArgumentException("Unknown index type!");
    }

    private static String removeQuotes(String str) {
        int beginIndex = 0;
        int endIndex = str.length();
        if ('\"' == str.charAt(beginIndex)) {
            ++beginIndex;
        }
        if ('\"' == str.charAt(endIndex - 1)) {
            --endIndex;
        }
        return StringUtils.substring((String)str, (int)beginIndex, (int)endIndex);
    }

    public static Object dbObjectToPWFLObject(Object toConvert, Type<?> type) throws IllegalArgumentException {
        if (toConvert instanceof String) {
            return type.convert((String)toConvert);
        }
        if (type == Types.BOOLEAN) {
            return toConvert;
        }
        if (type == Types.INTEGER) {
            return ((Number)toConvert).longValue();
        }
        if (type == Types.FLOAT) {
            return ((Number)toConvert).doubleValue();
        }
        if (type == Types.DATE) {
            Date date = null;
            if (toConvert instanceof Timestamp) {
                Timestamp stamp = (Timestamp)toConvert;
                date = new Date(stamp.getTime());
            } else {
                date = (Date)toConvert;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            return new LocalDate((Object)df.format(date));
        }
        if (type == Types.DATETIME) {
            Date dateTime;
            if (toConvert instanceof Timestamp) {
                Timestamp stamp = (Timestamp)toConvert;
                dateTime = new Date(stamp.getTime());
            } else {
                dateTime = (Date)toConvert;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return LocalDateTime.parse((String)df.format(dateTime), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (type == Types.STRING) {
            return toConvert;
        }
        throw new IllegalArgumentException("Z\u0142y typ parametru: " + type);
    }

    public static Object[] dbArrayToPWFLArray(Object[] toConvert, Type<?> type) throws IllegalArgumentException {
        return Arrays.stream(toConvert).map(dbValue -> dbValue == null ? null : Converter.dbObjectToPWFLObject(dbValue, Converter.getSingleType(type))).toArray(size -> WorkflowArrayUtils.createTableOfType(size, type));
    }

    private static Type<?> getSingleType(Type<?> type) {
        if (type == Types.STRING_ARRAY || type == Types.STRING) {
            return Types.STRING;
        }
        if (type == Types.INTEGER_ARRAY || type == Types.INTEGER) {
            return Types.INTEGER;
        }
        if (type == Types.FLOAT_ARRAY || type == Types.FLOAT) {
            return Types.FLOAT;
        }
        if (type == Types.DATE_ARRAY || type == Types.DATE) {
            return Types.DATE;
        }
        if (type == Types.DATETIME_ARRAY || type == Types.DATETIME) {
            return Types.DATETIME;
        }
        if (type == Types.BOOLEAN_ARRAY || type == Types.BOOLEAN) {
            return Types.BOOLEAN;
        }
        throw new IllegalArgumentException("Unknown variable type: " + type);
    }

    private static /* synthetic */ void lambda$convertMapListToMultimap$1(ListMultimap transformedMap, Map.Entry entry) {
        transformedMap.put(entry.getKey(), entry.getValue());
    }
}

