/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.exceptions.InvalidDatasourceIDException;
import com.suncode.plugin.scheduldedtask.tools.JsonConverter;
import com.suncode.plugin.scheduldedtask.tools.PropertyInjector;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.datasource.DataSourceService;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class InvokeDatasource {
    @Autowired
    private DataSourceService datasourceService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.invoke-datasource")).name("scheduledtask.invoke-datasource.name")).description("scheduledtask.invoke-datasource.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).parameter().id("datasourceId").name("scheduledtask.invoke-datasource.param.datasourceId.name").description("scheduledtask.invoke-datasource.param.datasourceId.desc").type((Type)Types.STRING).create()).parameter().id("datasourceParameters").name("scheduledtask.invoke-datasource.param.datasourceParameters.name").description("scheduledtask.invoke-datasource.param.datasourceParameters.desc").optional().type((Type)Types.STRING).create();
    }

    public void execute(@Param String datasourceId, @Param String datasourceParameters, ScheduledTaskInstanceInfo taskInstanceInfo, Logger taskLog) {
        Map<String, String> params = this.injectProperties(this.getParametersMap(datasourceParameters), taskInstanceInfo);
        DataSourceInstance instance = this.datasourceService.getDataSource(datasourceId);
        if (instance == null) {
            throw new InvalidDatasourceIDException("Datasource not found!");
        }
        if (params.size() != instance.getInputParameters().size()) {
            taskLog.info((Object)"Parameters count error!");
            taskLog.info((Object)("Required parameters: " + instance.getInputParameters().stream().map(DataSourceParameter::getName).collect(Collectors.joining(", "))));
            taskLog.info((Object)("Given parameters: " + params.keySet().stream().collect(Collectors.joining(", "))));
            throw new IllegalArgumentException("Parameters count error!");
        }
        instance.execute(params, null);
    }

    private Map<String, String> injectProperties(Map<String, String> params, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        return params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.injectScheduledTaskProperties(scheduledTaskInstanceInfo)));
    }

    private Function<Map.Entry<String, String>, String> injectScheduledTaskProperties(ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        return entryMap -> {
            String withLastExecutionTime = PropertyInjector.injectLastExecutionDate((String)entryMap.getValue(), scheduledTaskInstanceInfo);
            String withLastInstanceExecutionTime = PropertyInjector.injectLastInstanceExecutionDate(withLastExecutionTime, scheduledTaskInstanceInfo);
            return PropertyInjector.injectCurrentTime(withLastInstanceExecutionTime);
        };
    }

    private Map<String, String> getParametersMap(String datasourceParameters) {
        return JsonConverter.convertJsonToMap(datasourceParameters);
    }
}

