/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.db.entities.ImportedDocument;
import com.suncode.plugin.scheduldedtask.exceptions.CancelImportDocumentTaskException;
import com.suncode.plugin.scheduldedtask.schemas.ImportDocFromXlsxCfg;
import com.suncode.plugin.scheduldedtask.schemas.ImportSheetsData;
import com.suncode.plugin.scheduldedtask.service.ImportedDocumentService;
import com.suncode.plugin.scheduldedtask.tools.Converter;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class ImportDocumentsFromXlsx {
    private static final Logger log = LoggerFactory.getLogger(ImportDocumentsFromXlsx.class);
    private static final String FILEPATH = "FilePath";
    @Autowired
    private DocumentClassActionService docClassActionService;
    @Autowired
    private ImportedDocumentService importedDocService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService docClassService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.import-doc-from-xlsx")).name("scheduledtask.import-doc-from-xlsx.name")).description("scheduledtask.import-doc-from-xlsx.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).cancelable().parameter().id("xlsx-path").name("scheduledtask.import-doc-from-xlsx.xlsx-path.name").description("scheduledtask.import-doc-from-xlsx.xlsx-path.desc").type((Type)Types.STRING).create()).parameter().id("doc-class-name").name("scheduledtask.import-doc-from-xlsx.doc-class-name.name").description("scheduledtask.import-doc-from-xlsx.doc-class-name.desc").type((Type)Types.STRING).create()).parameter().id("save-as-new-version").name("scheduledtask.import-doc-from-xlsx.save-as-new-version.name").description("scheduledtask.import-doc-from-xlsx.save-as-new-version.desc").type((Type)Types.STRING).defaultValue((Object)"true").create()).parameter().id("skip-check-imported-document").name("scheduledtask.import-doc-from-xlsx.skip-check-imported-document.name").description("scheduledtask.import-doc-from-xlsx.skip-check-imported-document.desc").type((Type)Types.STRING).optional().defaultValue((Object)"false").create()).parameter().id("run-document-class-action").name("scheduledtask.import-doc-from-xlsx.run-document-class-action.name").description("scheduledtask.import-doc-from-xlsx.run-document-class-action.desc").type((Type)Types.STRING).optional().defaultValue((Object)"true").create();
    }

    public String execute(@Param(value="xlsx-path") String xlsxPath, @Param(value="doc-class-name") String docClassName, @Param(value="save-as-new-version") String saveAsNewVersionStr, @Param(value="skip-check-imported-document") String skipCheckImportedDocStr, @Param(value="run-document-class-action") String runDocClassActionStr, CancelationHandler cancelation, ScheduledTaskInstanceInfo scheduledTaskInfo, org.apache.log4j.Logger taskLog) throws Exception {
        ImportDocFromXlsxCfg cfg = null;
        try {
            File fileXlsx = new File(xlsxPath);
            this.checkExistFile(xlsxPath, fileXlsx, taskLog);
            String directoryPath = fileXlsx.getParent();
            DocumentClass docClasss = this.docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
            this.checkExistDocClass(docClassName, docClasss, taskLog);
            cfg = ImportDocFromXlsxCfg.builder().saveAsNewVersion(StringUtils.isBlank((CharSequence)saveAsNewVersionStr) || Boolean.parseBoolean(saveAsNewVersionStr)).skipCheckImportedDo(Boolean.valueOf(skipCheckImportedDocStr)).runDocClassAction(StringUtils.isBlank((CharSequence)runDocClassActionStr) || Boolean.valueOf(runDocClassActionStr) != false).cancellation(cancelation).taskLog(taskLog).fileXlsx(fileXlsx).directoryPath(directoryPath).documentClass(docClasss).build();
            this.intiLog(cfg, scheduledTaskInfo);
            Map<String, DocumentClassIndex> indexesMap = this.readIndexes(cfg.getDocumentClass());
            List<ImportSheetsData> importDatas = this.spreatSheetReader(cfg);
            taskLog.debug((Object)("Number of rows to process: " + importDatas.size()));
            this.importDocument(cfg, indexesMap, importDatas);
            String fullSummary = cfg.getStatistics().generateSummary();
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
            taskLog.info((Object)fullSummary);
            return MessageFormat.format("Imported: {0}, Failed: {1}, Skipped: {2}", cfg.getStatistics().getSuccessfulImports(), cfg.getStatistics().getFailedImports(), cfg.getStatistics().getSkippedRows());
        }
        catch (CancelImportDocumentTaskException cancelEx) {
            if (cfg != null) {
                String fullSummary = cfg.getStatistics().generateSummary();
                taskLog.info((Object)("Task cancelled. " + scheduledTaskInfo.getName() + "\n" + fullSummary));
                return MessageFormat.format("Cancelled. Imported: {0}, Failed: {1}, Skipped: {2}", cfg.getStatistics().getSuccessfulImports(), cfg.getStatistics().getFailedImports(), cfg.getStatistics().getSkippedRows());
            }
            return "Task cancelled before initialization";
        }
    }

    private void intiLog(ImportDocFromXlsxCfg cfg, ScheduledTaskInstanceInfo scheduledTaskInfo) {
        org.apache.log4j.Logger taskLog = cfg.getTaskLog();
        taskLog.debug((Object)("Start: " + scheduledTaskInfo.getName()));
        StringBuilder sb = new StringBuilder();
        sb.append("Run with parameters:\n").append("\txlsxPath:\t").append(cfg.getFileXlsx().getAbsolutePath()).append("\n").append("\tdocClassName:\t").append(cfg.getDocumentClass().getName()).append("\n").append("\tsaveAsNewVersion:\t").append(cfg.getSaveAsNewVersion()).append("\n").append("\tskipCheckImportedDoc:\t").append(cfg.getSkipCheckImportedDo()).append("\n").append("\trunDocClassActionS:\t").append(cfg.getRunDocClassAction()).append("\n");
        taskLog.debug((Object)sb.toString());
    }

    private void checkExistDocClass(String docClassName, DocumentClass docClasss, org.apache.log4j.Logger taskLog) throws Exception {
        if (docClasss == null) {
            taskLog.debug((Object)("Incorrect param docClassName:" + docClassName));
            throw new Exception("Incorrect param docClassName:" + docClassName);
        }
    }

    private void checkExistFile(String xlsxPath, File fileXlsx, org.apache.log4j.Logger taskLog) throws Exception {
        if (!fileXlsx.exists()) {
            taskLog.debug((Object)("Incorrect param xlsxPath:" + xlsxPath));
            throw new Exception("Incorrect param xlsxPath:" + xlsxPath);
        }
    }

    private void importDocument(ImportDocFromXlsxCfg cfg, Map<String, DocumentClassIndex> indexesMap, List<ImportSheetsData> importDatas) throws CancelImportDocumentTaskException {
        for (ImportSheetsData importSheetsData : importDatas) {
            if (cfg.getCancellation().isCanceled().booleanValue()) {
                throw new CancelImportDocumentTaskException("Cancel", cfg.getStatistics().getSuccessfulImports());
            }
            if (cfg.getSkipCheckImportedDo().booleanValue() || !this.importedDocService.isImported(importSheetsData.getPathFile(), cfg.getDocumentClass().getName()).booleanValue()) {
                ImportedDocument entity = this.createEntity(importSheetsData, cfg.getDocumentClass().getName());
                this.importedDocService.updateOrSave(entity);
                try {
                    Map<Long, Object> idx = this.prepareIndexes(importSheetsData, indexesMap, cfg.getTaskLog());
                    WfDocument document = this.importDocument(cfg, importSheetsData, idx);
                    if (cfg.getRunDocClassAction().booleanValue()) {
                        this.docClassActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
                    }
                    cfg.getStatistics().incrementSuccessful();
                    this.setSuccessEntity(entity, document);
                }
                catch (Exception e) {
                    String errorMsg = "Row " + importSheetsData.getNrRow() + ". " + e.getMessage() + "Skip document";
                    this.setFailureEntity(entity, errorMsg);
                    cfg.getStatistics().addFailedFile(importSheetsData.getPathFile(), e.getMessage(), importSheetsData.getNrRow());
                    cfg.getTaskLog().error((Object)errorMsg);
                    log.error(errorMsg, (Throwable)e);
                }
                this.importedDocService.updateOrSave(entity);
                continue;
            }
            String msg = "Already imported";
            cfg.getTaskLog().debug((Object)("Row " + importSheetsData.getNrRow() + ". " + msg));
            cfg.getStatistics().addSkippedFile(importSheetsData.getPathFile(), msg, importSheetsData.getNrRow());
        }
    }

    private ImportSheetsData readRow(ImportDocFromXlsxCfg cfg, int indexRow, Map<String, Cell> dataRow) {
        String filePath;
        cfg.getStatistics().incrementTotal();
        String string = filePath = dataRow.get(FILEPATH) == null ? null : Converter.cellToString(dataRow.get(FILEPATH));
        if (StringUtils.isBlank(filePath)) {
            cfg.getTaskLog().debug((Object)("Row " + (indexRow + 1) + ": Blank " + FILEPATH + " skip"));
            cfg.getStatistics().addSkippedFile(filePath, "Empty file path", indexRow);
            return null;
        }
        try {
            String importFilePath = filePath;
            File file = new File(importFilePath).getAbsoluteFile();
            if (!file.exists() && !(file = new File(importFilePath = cfg.getDirectoryPath() + File.separator + filePath).getAbsoluteFile()).exists()) {
                String msg = "File not found at " + filePath + " or " + importFilePath;
                cfg.getTaskLog().info((Object)("Row " + (indexRow + 1) + ": " + msg));
                cfg.getStatistics().addFailedFile(filePath, msg, indexRow);
                return null;
            }
            return this.buildImportData(cfg, indexRow, dataRow, importFilePath);
        }
        catch (Exception e) {
            String errorMsg = "Row " + (indexRow + 1) + ": Error processing " + FILEPATH + " [" + e.getMessage() + "]";
            cfg.getTaskLog().error((Object)errorMsg);
            log.error(errorMsg, (Throwable)e);
            cfg.getStatistics().addFailedFile(filePath, e.getMessage(), indexRow);
            return null;
        }
    }

    private void setFailureEntity(ImportedDocument entity, String msg) {
        entity.setErrorMsg(msg);
        entity.setImported(false);
        entity.setUpdateTime(new Timestamp(DateTime.now().getMillis()));
    }

    private void setSuccessEntity(ImportedDocument entity, WfDocument document) {
        entity.setDocId(document.getId());
        entity.setErrorMsg("");
        entity.setImported(true);
        entity.setUpdateTime(new Timestamp(DateTime.now().getMillis()));
        entity.setVersion(Long.valueOf(document.getVersion().getVersion()));
    }

    private ImportSheetsData buildImportData(ImportDocFromXlsxCfg cfg, int indexRow, Map<String, Cell> dataRow, String importFilePath) {
        ImportSheetsData importData = new ImportSheetsData();
        importData.setPathFile(importFilePath);
        importData.setDocClassName(cfg.getDocumentClass().getName());
        importData.setDocClassId(cfg.getDocumentClass().getId());
        importData.setRowData(dataRow);
        importData.setNrRow(Long.valueOf(indexRow));
        return importData;
    }

    private Map<String, DocumentClassIndex> readIndexes(DocumentClass documentClass) {
        Set indexes = documentClass.getIndexes();
        HashMap<String, DocumentClassIndex> indexesMap = new HashMap<String, DocumentClassIndex>();
        for (DocumentClassIndex documentClassIndex : indexes) {
            indexesMap.put(documentClassIndex.getName(), documentClassIndex);
        }
        return indexesMap;
    }

    private ImportedDocument createEntity(ImportSheetsData importSheetsData, String docClassName) {
        ImportedDocument entity = new ImportedDocument();
        entity.setImported(false);
        entity.setFilePath(importSheetsData.getPathFile());
        entity.setUpdateTime(new Timestamp(DateTime.now().getMillis()));
        entity.setDocClassName(docClassName);
        return entity;
    }

    private WfDocument importDocument(ImportDocFromXlsxCfg cfg, ImportSheetsData importSheetsData, Map<Long, Object> idx) throws Exception {
        try {
            File file = new File(importSheetsData.getPathFile());
            DocumentDefinition definition = new DocumentDefinition();
            definition.setDocumentClassId(importSheetsData.getDocClassId());
            definition.setFileName(file.getName());
            definition.setUserName("admin");
            definition.setIndexes(idx);
            definition.setInputStream((InputStream)new FileInputStream(file));
            definition.setSaveAsNewVersion(cfg.getSaveAsNewVersion().booleanValue());
            WfDocument document = this.documentService.addDocument(definition);
            cfg.getTaskLog().debug((Object)("Row " + importSheetsData.getNrRow() + ". Success imported file. docID:\t" + document.getId() + " version " + document.getVersion().getVersion()));
            return document;
        }
        catch (Exception e) {
            Exception e1 = e;
            while (StringUtils.isNotBlank((CharSequence)e1.getMessage())) {
                e1 = (Exception)e1.getCause();
            }
            String errorMsg = "Error adding documents [" + e1.getMessage() + "]. ";
            throw new Exception(errorMsg, e);
        }
    }

    private Map<Long, Object> prepareIndexes(ImportSheetsData importSheetsData, Map<String, DocumentClassIndex> indexesMap, org.apache.log4j.Logger taskLog) throws Exception {
        HashMap<Long, Object> idx = new HashMap<Long, Object>();
        Map<String, Cell> data = importSheetsData.getRowData();
        String indexNameError = "";
        try {
            Iterator<String> iterator = indexesMap.keySet().iterator();
            while (iterator.hasNext()) {
                String indexName;
                indexNameError = indexName = iterator.next();
                if (!data.containsKey(indexName)) continue;
                DocumentClassIndex docClassIndex = indexesMap.get(indexName);
                Object value = Converter.excelToString(data.get(indexName), docClassIndex.getType());
                idx.put(docClassIndex.getId(), value);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error preparing indexes [index:\t" + indexNameError + " error:\t" + e.getMessage() + "]. ";
            throw new Exception(errorMsg, e);
        }
        return idx;
    }

    public List<ImportSheetsData> spreatSheetReader(ImportDocFromXlsxCfg cfg) throws Exception {
        ArrayList<ImportSheetsData> result = new ArrayList<ImportSheetsData>();
        try (FileInputStream is = new FileInputStream(cfg.getFileXlsx());){
            Sheet sheet = WorkbookFactory.create((InputStream)is).getSheetAt(0);
            int nrRows = sheet.getLastRowNum();
            HashMap<Long, String> headerSheet = new HashMap<Long, String>();
            boolean headerRow = true;
            for (Row row : sheet) {
                if (cfg.getCancellation().isCanceled().booleanValue()) {
                    throw new CancelImportDocumentTaskException("Cancel");
                }
                if (row == null) continue;
                if (headerRow) {
                    this.buildHeaderColumns(headerSheet, row);
                    this.checkFilePathColumn(cfg.getTaskLog(), headerSheet);
                    headerRow = false;
                    continue;
                }
                ImportSheetsData importedData = this.buildDataToImport(sheet, nrRows, headerSheet, row, cfg);
                if (importedData == null) continue;
                result.add(importedData);
            }
        }
        return result;
    }

    private ImportSheetsData buildDataToImport(Sheet sheet, int nrRows, Map<Long, String> headerSheet, Row row, ImportDocFromXlsxCfg cfg) throws CancelImportDocumentTaskException {
        HashMap<String, Cell> mapRow = new HashMap<String, Cell>();
        short nrCells = row.getLastCellNum();
        for (long indexCell = 0L; indexCell < (long)nrCells; ++indexCell) {
            String columnName = headerSheet.get(indexCell);
            if (StringUtils.isBlank((CharSequence)columnName)) continue;
            Cell cell = row.getCell((int)indexCell);
            mapRow.put(columnName, cell);
        }
        return this.readRow(cfg, row.getRowNum(), mapRow);
    }

    private void buildHeaderColumns(Map<Long, String> headerSheet, Row row) {
        for (int indexCell = 0; indexCell <= row.getLastCellNum(); ++indexCell) {
            Cell cell = row.getCell(indexCell);
            String columnName = Converter.cellToString(cell);
            if (!StringUtils.isNotBlank((CharSequence)columnName)) continue;
            headerSheet.put(Long.valueOf(indexCell), columnName.trim());
        }
    }

    private void checkFilePathColumn(org.apache.log4j.Logger taskLog, Map<Long, String> headerSheet) throws Exception {
        if (!headerSheet.containsValue(FILEPATH)) {
            taskLog.debug((Object)"No column: \tFilePath");
            throw new Exception("\"No column:FilePath");
        }
    }
}

