/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.service;

import com.suncode.plugin.scheduldedtask.service.TemplateTagService;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityAssignment;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateTagServiceImpl
implements TemplateTagService {
    private static final Logger log = LoggerFactory.getLogger(TemplateTagServiceImpl.class);
    private static final String DAY_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private UserSettingsService uss;

    @Override
    public String formatContent(String content, List<Map<String, String>> rows) {
        String tagRowsStart = "@@rows@@";
        String tagRowsEnd = "@@end_rows@@";
        int iStartPos = content.indexOf("@@rows@@");
        int iEndPos = content.indexOf("@@end_rows@@");
        if (iStartPos > 0 && iEndPos > 0) {
            StringBuilder sbNewRow = new StringBuilder();
            String sRow = content.substring(iStartPos + "@@rows@@".length(), iEndPos);
            for (Map<String, String> mapTaskParams : rows) {
                sbNewRow.append(this.formatContent(sRow, mapTaskParams));
            }
            String sStartPart = content.substring(0, iStartPos);
            String sEndPart = content.substring(iEndPos + "@@end_rows@@".length());
            sStartPart = this.formatContent(sStartPart, rows.get(0));
            sEndPart = this.formatContent(sEndPart, rows.get(0));
            return sStartPart + sbNewRow + sEndPart;
        }
        return this.formatContent(content, rows.get(0));
    }

    @Override
    public String formatContent(String content, Map<String, String> variables) {
        HashMap<String, String> mapExpressions = new HashMap<String, String>(variables);
        this.initDefaultTag(variables, mapExpressions, content);
        return this.replaceTags(content, mapExpressions);
    }

    private String replaceTags(String content, Map<String, String> mapExpressions) {
        for (String str : mapExpressions.keySet()) {
            if (!content.contains("@" + str + "@")) continue;
            content = content.replace("@" + str + "@", mapExpressions.get(str));
        }
        return content;
    }

    private void initDefaultTag(Map<String, String> variables, Map<String, String> mapExpressions, String content) {
        String colProcessIdName = "processid";
        String colActivityIdName = "activityid";
        mapExpressions.put("httplink", this.builHttpLink());
        if (variables.containsKey("processid".toUpperCase()) || variables.containsKey("processid".toLowerCase())) {
            String processId = variables.get("processid");
            this.processInfo(mapExpressions, content, processId);
            if (variables.containsKey("activityid".toUpperCase()) || variables.containsKey("activityid".toLowerCase())) {
                String activityId = variables.get("activityid");
                this.activityInfo(mapExpressions, processId, activityId);
            } else {
                log.debug("No column activityid");
            }
        } else {
            log.debug("No column processid");
        }
    }

    private void activityInfo(Map<String, String> mapExpressions, String processId, String activityId) {
        Activity activity = this.activityService.getActivity(processId, activityId, new String[0]);
        mapExpressions.put("activityname", activity.getName());
        mapExpressions.put("activitydescription", activity.getDescription());
        mapExpressions.put("activitydefid", activity.getActivityDefinitionId());
        mapExpressions.put("activityid", activity.getActivityId());
        mapExpressions.put("activitystarttime", new SimpleDateFormat(TIME_FORMAT).format(activity.getCreatedTime()));
        mapExpressions.put("activitystartday", new SimpleDateFormat(DAY_FORMAT).format(activity.getCreatedTime()));
        mapExpressions.put("activitycreatedtime", new SimpleDateFormat(TIME_FORMAT).format(activity.getCreatedTime()));
        mapExpressions.put("activitycreatedday", new SimpleDateFormat(DAY_FORMAT).format(activity.getCreatedTime()));
        mapExpressions.put("link", this.builActivityLink(processId, activityId));
        mapExpressions.put("taskUsers", this.getAssignedUsers(processId, activityId));
    }

    private String builActivityLink(String processId, String activityId) {
        String sHttpSystemLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        String sLink = sHttpSystemLink + "/ProcesActivity.do?processKey=" + processId + "&activityId=" + activityId;
        sLink = "<A Href=" + sLink + ">" + MessageHelper.getMessage((String)"Przejdz_do_zadania", (Locale)this.uss.getUserLocale("admin"), (Object[])new Object[0]) + "</A>";
        return sLink;
    }

    private String builHttpLink() {
        String sHttpSystemLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        sHttpSystemLink = "<A Href=" + sHttpSystemLink + ">PlusWorkflow</A>";
        return sHttpSystemLink;
    }

    private void processInfo(Map<String, String> mapExpressions, String content, String processId) {
        Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
        mapExpressions.put("processname", process.getName());
        mapExpressions.put("processdescription", process.getDescription());
        mapExpressions.put("processdefid", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processpackageid", process.getProcessDefinition().getPackageId());
        mapExpressions.put("processtype", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processstarttime", new SimpleDateFormat(TIME_FORMAT).format(process.getCreatedTime()));
        mapExpressions.put("processstartday", new SimpleDateFormat(DAY_FORMAT).format(process.getCreatedTime()));
        mapExpressions.put("processcreatedtime", new SimpleDateFormat(TIME_FORMAT).format(process.getCreatedTime()));
        mapExpressions.put("processcreatedday", new SimpleDateFormat(DAY_FORMAT).format(process.getCreatedTime()));
        mapExpressions.putAll(this.getTaskUsers(content, process.getProcessId()));
        mapExpressions.putAll(this.getRealUsersName(content, process.getProcessId()));
        mapExpressions.putAll(this.getLinks(content, process.getProcessId()));
    }

    private Map<String, String> getRealUsersName(String sData, String sProcessId) {
        Map mapProcessContext = this.processService.getProcessContext(sProcessId);
        HashMap<String, String> mapRealUsersName = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@realusername#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@realusername#", fromIndex) + "@realusername#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sProcessVariable = sData.substring(beginIndex, endIndex);
            try {
                String sUserName = mapProcessContext.get(sProcessVariable).toString();
                if (sUserName.length() <= 0) continue;
                try {
                    String sUserFullName = this.userService.getUser(sUserName, new String[0]).getFullName();
                    mapRealUsersName.put("realusername#" + sProcessVariable, sUserFullName);
                }
                catch (NullPointerException e) {
                    mapRealUsersName.put("realusername#" + sProcessVariable, "@u\u017cytkownik nie istnieje!@");
                }
            }
            catch (NullPointerException e) {
                mapRealUsersName.put("realusername#" + sProcessVariable, "@realusername#" + sProcessVariable + ": (brak zmiennej w procesie)@");
            }
        }
        return mapRealUsersName;
    }

    private Map<String, String> getTaskUsers(String content, String sProcessId) {
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapTaskUsers = new HashMap<String, String>();
        String tag = "@taskuser#";
        int fromIndex = 0;
        while (content.indexOf(tag, fromIndex) != -1) {
            User user;
            Object[] obj = this.readActivitydefId(content, tag, fromIndex);
            fromIndex = (Integer)obj[0];
            String sActivityDefId = obj[1].toString();
            String sActivityId = this.findActivityId(listActivity, sActivityDefId);
            ActivityEntity activity = (ActivityEntity)this.activityService.getActivity(sProcessId, sActivityId, new String[0]);
            if (activity == null || (user = this.userService.getUser(activity.getResourceId(), new String[0])) == null) continue;
            mapTaskUsers.put("taskuser#" + sActivityDefId, user.getFullName());
        }
        return mapTaskUsers;
    }

    private Map<String, String> getLinks(String content, String sProcessId) {
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapLinks = new HashMap<String, String>();
        String sHttpLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        this.addShowDetailHistoryLinks(content, sProcessId, listActivity, mapLinks, sHttpLink);
        String sHistoryLink = sHttpLink + "/ShowProcessHistory.do?ProcessId=" + sProcessId;
        sHistoryLink = "<A Href=" + sHistoryLink + ">" + MessageHelper.getMessage((String)"Przejdz_do_historii_procesu", (Locale)this.uss.getUserLocale("admin"), (Object[])new Object[0]) + "</A>";
        mapLinks.put("historylink", sHistoryLink);
        return mapLinks;
    }

    private void addShowDetailHistoryLinks(String content, String sProcessId, List<Activity> listActivity, Map<String, String> mapLinks, String sHttpLink) {
        String tag = "@link#";
        int fromIndex = 0;
        while (content.indexOf(tag, fromIndex) != -1) {
            Object[] obj = this.readActivitydefId(content, tag, fromIndex);
            fromIndex = (Integer)obj[0];
            String sActivityDefId = obj[1].toString();
            String sActivityId = this.findActivityId(listActivity, sActivityDefId);
            String link = sHttpLink + "/ShowDetailHistory.do?histActivityId=" + sActivityId + "&ProcessId=" + sProcessId;
            link = "<A Href=" + link + ">" + MessageHelper.getMessage((String)"Link_do_szczegolow_zadania", (Locale)this.uss.getUserLocale("admin"), (Object[])new Object[0]) + "</A>";
            mapLinks.put("link#" + sActivityDefId, link);
        }
    }

    private Object[] readActivitydefId(String content, String tag, int fromIndex) {
        Object[] result = new Object[2];
        int beginIndex = content.indexOf(tag, fromIndex) + tag.length();
        int endIndex = content.indexOf("@", beginIndex);
        result[0] = endIndex;
        result[1] = content.substring(beginIndex, endIndex);
        return result;
    }

    private String findActivityId(List<Activity> listActivity, String sActivityDefId) {
        String sActivityId = null;
        for (Activity activity : listActivity) {
            if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
            sActivityId = activity.getActivityId();
            break;
        }
        return sActivityId;
    }

    public String getAssignedUsers(String processId, String activityId) {
        List alTaskUsers = this.activityService.getAssignments(processId, activityId);
        String taskUsers = "";
        if (StringUtils.isNotBlank((String)activityId)) {
            ArrayList<User> users = new ArrayList<User>();
            if (CollectionUtils.isNotEmpty((Collection)alTaskUsers)) {
                for (String userName : alTaskUsers) {
                    users.add(this.userService.getUser(userName, new String[0]));
                }
            } else {
                String userName;
                ActivityEntity activity = (ActivityEntity)this.activityService.getActivity(processId, activityId, new String[]{"assignments"});
                userName = activity.getResourceId();
                if (StringUtils.isEmpty((String)userName)) {
                    Set assignments = activity.getAssignments();
                    if (CollectionUtils.isNotEmpty((Collection)assignments)) {
                        for (ActivityAssignment assignment : assignments) {
                            users.add(this.userService.getUser(assignment.getUserName(), new String[0]));
                        }
                    }
                } else {
                    users.add(this.userService.getUser(userName, new String[0]));
                }
            }
            for (User user : users) {
                String userFullName;
                if (user == null) continue;
                String string = userFullName = StringUtils.isBlank((String)user.getFullName()) ? user.getUserName() : user.getFullName();
                if (StringUtils.isBlank((String)taskUsers)) {
                    taskUsers = StringUtils.join((Object[])new String[]{taskUsers, userFullName});
                    continue;
                }
                taskUsers = StringUtils.join((Object[])new String[]{taskUsers, ", ", userFullName});
            }
        }
        return taskUsers;
    }
}

