/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.schemas;

import java.beans.ConstructorProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ImportStatistics {
    private int totalRows;
    private int successfulImports;
    private int skippedRows;
    private int failedImports;
    private List<String> failedFilePaths;
    private List<String> skippedFilePaths;

    public void addFailedFile(String filePath, String reason, long rowNumber) {
        this.failedFilePaths.add(String.format("Row %d: %s - %s", rowNumber + 1L, filePath, reason));
        ++this.failedImports;
    }

    public void addSkippedFile(String filePath, String reason, long rowNumber) {
        this.skippedFilePaths.add(String.format("Row %d: %s - %s", rowNumber + 1L, filePath, reason));
        ++this.skippedRows;
    }

    public void incrementSuccessful() {
        ++this.successfulImports;
    }

    public void incrementTotal() {
        ++this.totalRows;
    }

    public String generateSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append(MessageFormat.format("Import Summary:\nTotal Rows Processed: {0}\nSuccessfully Imported: {1}\nFailed Imports: {2}\nSkipped Rows: {3}\n", this.totalRows, this.successfulImports, this.failedImports, this.skippedRows));
        if (!this.failedFilePaths.isEmpty()) {
            summary.append("\nFailed Imports:\n");
            this.failedFilePaths.forEach(path -> summary.append("- ").append((String)path).append("\n"));
        }
        if (!this.skippedFilePaths.isEmpty()) {
            summary.append("\nSkipped Files:\n");
            this.skippedFilePaths.forEach(path -> summary.append("- ").append((String)path).append("\n"));
        }
        return summary.toString();
    }

    private static int $default$totalRows() {
        return 0;
    }

    private static int $default$successfulImports() {
        return 0;
    }

    private static int $default$skippedRows() {
        return 0;
    }

    private static int $default$failedImports() {
        return 0;
    }

    private static List<String> $default$failedFilePaths() {
        return new ArrayList<String>();
    }

    private static List<String> $default$skippedFilePaths() {
        return new ArrayList<String>();
    }

    @ConstructorProperties(value={"totalRows", "successfulImports", "skippedRows", "failedImports", "failedFilePaths", "skippedFilePaths"})
    ImportStatistics(int totalRows, int successfulImports, int skippedRows, int failedImports, List<String> failedFilePaths, List<String> skippedFilePaths) {
        this.totalRows = totalRows;
        this.successfulImports = successfulImports;
        this.skippedRows = skippedRows;
        this.failedImports = failedImports;
        this.failedFilePaths = failedFilePaths;
        this.skippedFilePaths = skippedFilePaths;
    }

    public static ImportStatisticsBuilder builder() {
        return new ImportStatisticsBuilder();
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getSuccessfulImports() {
        return this.successfulImports;
    }

    public int getSkippedRows() {
        return this.skippedRows;
    }

    public int getFailedImports() {
        return this.failedImports;
    }

    public List<String> getFailedFilePaths() {
        return this.failedFilePaths;
    }

    public List<String> getSkippedFilePaths() {
        return this.skippedFilePaths;
    }

    public static class ImportStatisticsBuilder {
        private boolean totalRows$set;
        private int totalRows;
        private boolean successfulImports$set;
        private int successfulImports;
        private boolean skippedRows$set;
        private int skippedRows;
        private boolean failedImports$set;
        private int failedImports;
        private boolean failedFilePaths$set;
        private List<String> failedFilePaths;
        private boolean skippedFilePaths$set;
        private List<String> skippedFilePaths;

        ImportStatisticsBuilder() {
        }

        public ImportStatisticsBuilder totalRows(int totalRows) {
            this.totalRows = totalRows;
            this.totalRows$set = true;
            return this;
        }

        public ImportStatisticsBuilder successfulImports(int successfulImports) {
            this.successfulImports = successfulImports;
            this.successfulImports$set = true;
            return this;
        }

        public ImportStatisticsBuilder skippedRows(int skippedRows) {
            this.skippedRows = skippedRows;
            this.skippedRows$set = true;
            return this;
        }

        public ImportStatisticsBuilder failedImports(int failedImports) {
            this.failedImports = failedImports;
            this.failedImports$set = true;
            return this;
        }

        public ImportStatisticsBuilder failedFilePaths(List<String> failedFilePaths) {
            this.failedFilePaths = failedFilePaths;
            this.failedFilePaths$set = true;
            return this;
        }

        public ImportStatisticsBuilder skippedFilePaths(List<String> skippedFilePaths) {
            this.skippedFilePaths = skippedFilePaths;
            this.skippedFilePaths$set = true;
            return this;
        }

        public ImportStatistics build() {
            return new ImportStatistics(this.totalRows$set ? this.totalRows : ImportStatistics.$default$totalRows(), this.successfulImports$set ? this.successfulImports : ImportStatistics.$default$successfulImports(), this.skippedRows$set ? this.skippedRows : ImportStatistics.$default$skippedRows(), this.failedImports$set ? this.failedImports : ImportStatistics.$default$failedImports(), this.failedFilePaths$set ? this.failedFilePaths : ImportStatistics.$default$failedFilePaths(), this.skippedFilePaths$set ? this.skippedFilePaths : ImportStatistics.$default$skippedFilePaths());
        }

        public String toString() {
            return "ImportStatistics.ImportStatisticsBuilder(totalRows=" + this.totalRows + ", successfulImports=" + this.successfulImports + ", skippedRows=" + this.skippedRows + ", failedImports=" + this.failedImports + ", failedFilePaths=" + this.failedFilePaths + ", skippedFilePaths=" + this.skippedFilePaths + ")";
        }
    }
}

