/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.db.service;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.database.Database;
import com.suncode.plugin.scheduldedtask.db.common.DBQueryConfig;
import com.suncode.plugin.scheduldedtask.db.entities.DBQuery;
import com.suncode.plugin.scheduldedtask.db.entities.DBQueryDao;
import com.suncode.plugin.scheduldedtask.db.service.DBService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DBServiceImpl
implements DBService {
    private static final Logger log = LoggerFactory.getLogger(DBServiceImpl.class);
    @Autowired
    private DBQueryDao dao;
    @Autowired
    private DatabaseExplorer databaseExplorer;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    @Override
    public DBQuery getQueryByName(String name) {
        return (DBQuery)this.dao.findOneByProperty("queryName", name, new String[0]);
    }

    @Override
    public List<Map<String, Object>> getDataFromQuery(String dbName, String query) {
        Database database = this.databaseExplorer.get(dbName);
        return (List)database.withinSession(session -> {
            Connection connection = session.getConnection();
            PreparedStatement statement = connection.prepareStatement(query);
            ResultSet resultSet = statement.executeQuery();
            return this.getResultData(resultSet);
        });
    }

    private List<Map<String, Object>> getResultData(ResultSet resultSet) throws SQLException {
        LinkedList<Map<String, Object>> resultData = new LinkedList<Map<String, Object>>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        while (resultSet.next() && !resultSet.isClosed()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                row.put(resultSetMetaData.getColumnName(i), resultSet.getObject(i));
            }
            resultData.add(row);
        }
        log.debug("Data returned from DB: {}", resultData);
        return resultData;
    }

    @Override
    public List<Map<String, Object>> getDataFromQuery(DBQueryConfig dbQueryCfg) {
        Database database = this.databaseExplorer.get(dbQueryCfg.getDbName());
        return (List)database.withinSession(session -> {
            DBQuery dbQuery = this.getQueryByName(dbQueryCfg.getQueryKey());
            Connection connection = session.getConnection();
            PreparedStatement statement = connection.prepareStatement(dbQuery.getQuery());
            if (dbQueryCfg.getMax() >= 0) {
                statement.setMaxRows(dbQueryCfg.getMax());
            }
            this.addParameters(statement, dbQueryCfg.getQueryParams());
            ResultSet resultSet = statement.executeQuery();
            if (dbQueryCfg.getFirst() != 0) {
                resultSet.absolute(dbQueryCfg.getFirst());
            }
            return this.getResultData(resultSet);
        });
    }

    @Override
    public List<Map<String, Object>> executeQueryAndReturnData(String database, String queryName, Object[] paramsValues) {
        DBQueryConfig dbQueryCfg = DBQueryConfig.builder().dbName(database).queryKey(queryName).queryParams(paramsValues).build();
        log.debug("DBQueryConfig: " + dbQueryCfg.toString());
        return this.getDataFromQuery(dbQueryCfg);
    }

    @Override
    public List<Map<String, Object>> getDataFromQueryName(String dbName, String queryName) {
        Database database = this.databaseExplorer.get(dbName);
        return (List)database.withinSession(session -> {
            DBQuery dbQuery = this.getQueryByName(queryName);
            Connection connection = session.getConnection();
            PreparedStatement statement = connection.prepareStatement(dbQuery.getQuery());
            ResultSet resultSet = statement.executeQuery();
            return this.getResultData(resultSet);
        });
    }

    private void addParameters(PreparedStatement statement, Object[] queryParams) throws SQLException {
        int index = 0;
        for (Object param : queryParams) {
            statement.setObject(++index, this.formatParameter(param));
        }
    }

    private Object formatParameter(Object param) {
        if (param instanceof LocalDate) {
            return ((LocalDate)param).toString(DATE_FORMATTER);
        }
        if (param instanceof LocalDateTime) {
            return ((LocalDateTime)param).toString(DATE_TIME_FORMATTER);
        }
        return param;
    }
}

