/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.excel.style;

import com.suncode.plugin.scheduldedtask.audit.excel.style.CellStyleType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleBuilder {
    private final Workbook workbook;
    private final Map<CellStyleType, CellStyle> memoryStyle;

    public CellStyleBuilder(Workbook workbook) {
        this.workbook = workbook;
        this.memoryStyle = new LinkedHashMap<CellStyleType, CellStyle>();
    }

    public CellStyle getHeaderStyle() {
        if (!this.memoryStyle.containsKey((Object)CellStyleType.HEADER)) {
            this.createHeaderStyle();
        }
        return this.memoryStyle.get((Object)CellStyleType.HEADER);
    }

    private void createHeaderStyle() {
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        Font font = this.workbook.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        this.memoryStyle.put(CellStyleType.HEADER, cellStyle);
    }

    public CellStyle getDateFormatStyle() {
        if (!this.memoryStyle.containsKey((Object)CellStyleType.DATE_FORMAT)) {
            this.createDateFormatStyle();
        }
        return this.memoryStyle.get((Object)CellStyleType.DATE_FORMAT);
    }

    private void createDateFormatStyle() {
        CellStyle cellStyle = this.workbook.createCellStyle();
        CreationHelper creationHelper = this.workbook.getCreationHelper();
        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
        this.memoryStyle.put(CellStyleType.DATE_FORMAT, cellStyle);
    }

    public CellStyle getAuditDetailStyle() {
        if (!this.memoryStyle.containsKey((Object)CellStyleType.AUDIT_DETAILS)) {
            this.createAuditDetailsStyle();
        }
        return this.memoryStyle.get((Object)CellStyleType.AUDIT_DETAILS);
    }

    private void createAuditDetailsStyle() {
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setWrapText(true);
        this.memoryStyle.put(CellStyleType.AUDIT_DETAILS, cellStyle);
    }
}

