/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.excel.builder;

import com.suncode.plugin.scheduldedtask.audit.excel.column.ColumnType;
import com.suncode.plugin.scheduldedtask.audit.excel.style.CellStyleBuilder;
import com.suncode.plugin.scheduldedtask.audit.tools.AuditTools;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.dto.AuditDto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelBuilder {
    private final Workbook workbook = new XSSFWorkbook();
    private final CellStyleBuilder cellStyleBuilder = new CellStyleBuilder(this.workbook);
    private final UserService userService;
    private final Map<String, User> userCache;

    public ExcelBuilder(UserService userService) {
        this.userService = userService;
        this.userCache = new HashMap<String, User>();
    }

    public void buildAuditReport(List<AuditDto> audits, List<ColumnType> columnTypes, File file) {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            Sheet sheet = this.workbook.createSheet();
            this.writeHeader(columnTypes, sheet);
            this.writeData(audits, columnTypes, sheet);
            IntStream.range(0, columnTypes.size()).forEach(columnNumber -> sheet.autoSizeColumn(columnNumber));
            this.workbook.write((OutputStream)outputStream);
            this.workbook.close();
        }
    }

    private void writeHeader(List<ColumnType> columnTypes, Sheet sheet) {
        Row row = sheet.createRow(0);
        for (int columnNumber = 0; columnNumber < columnTypes.size(); ++columnNumber) {
            Cell cell = row.createCell(columnNumber);
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.cellStyleBuilder.getHeaderStyle());
            cell.setCellValue(columnTypes.get(columnNumber).getTranslatedName());
        }
    }

    private void writeData(List<AuditDto> audits, List<ColumnType> columnTypes, Sheet sheet) {
        for (int rowNumber = 0; rowNumber < audits.size(); ++rowNumber) {
            AuditDto audit = audits.get(rowNumber);
            Row row = sheet.createRow(rowNumber + 1);
            int numberOfLines = 1;
            for (int columnNumber = 0; columnNumber < columnTypes.size(); ++columnNumber) {
                Cell cell;
                ColumnType columnType = columnTypes.get(columnNumber);
                int newNumberOfLines = this.setCell(rowNumber, audit, columnType, cell = row.createCell(columnNumber));
                if (newNumberOfLines <= numberOfLines) continue;
                numberOfLines = newNumberOfLines;
            }
            row.setHeightInPoints(row.getHeightInPoints() * (float)numberOfLines);
        }
    }

    private int setCell(int rowNumber, AuditDto audit, ColumnType columnType, Cell cell) {
        User user = this.getUser(audit.getUserName());
        switch (columnType) {
            case ORDINAL_NUMBER: {
                cell.setCellType(CellType.NUMERIC);
                cell.setCellValue((double)(rowNumber + 1));
                break;
            }
            case NAME: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(audit.getTranslatedName());
                break;
            }
            case TYPE: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(audit.getType());
                break;
            }
            case THREAD: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(audit.getThread());
                break;
            }
            case DETAILS: {
                List details = audit.getAuditDetails().stream().map(detail -> detail.getName() + ": " + detail.getValue()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                cell.setCellType(CellType.STRING);
                String content = String.join((CharSequence)"\n", details);
                cell.setCellStyle(this.cellStyleBuilder.getAuditDetailStyle());
                cell.setCellValue(StringUtils.abbreviate((String)content, (int)SpreadsheetVersion.EXCEL2007.getMaxTextLength()));
                return details.size() - 1;
            }
            case SUCCESS: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(String.valueOf(audit.getSuccess()));
                break;
            }
            case DURATION: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(AuditTools.getDurationValue(audit.getDuration()));
                break;
            }
            case USERNAME: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(audit.getUserName());
                break;
            }
            case USER_FIRSTNAME: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(user == null ? audit.getUserName() : user.getFirstName());
                break;
            }
            case USER_LASTNAME: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(user == null ? audit.getUserName() : user.getLastName());
                break;
            }
            case USER_FULLNAME: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(user == null ? audit.getUserName() : user.getFullName());
                break;
            }
            case IP_ADDRESS: {
                cell.setCellType(CellType.STRING);
                cell.setCellValue(audit.getIpAddress());
                break;
            }
            case STOP_DATE: {
                cell.setCellStyle(this.cellStyleBuilder.getDateFormatStyle());
                cell.setCellValue(audit.getStopped());
                break;
            }
            case START_DATE: {
                cell.setCellStyle(this.cellStyleBuilder.getDateFormatStyle());
                cell.setCellValue(audit.getStarted());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown column type");
            }
        }
        return 1;
    }

    private User getUser(String username) {
        if (this.userCache.containsKey(username)) {
            return this.userCache.get(username);
        }
        User user = this.userService.getUser(username, new String[0]);
        this.userCache.put(username, user);
        return user;
    }
}

