/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.activity.service;

import com.suncode.plugin.scheduldedtask.activity.common.MultipleValueSupport;
import com.suncode.plugin.scheduldedtask.activity.service.VariableProcessingService;
import com.suncode.plugin.scheduldedtask.tools.Converter;
import com.suncode.plugin.scheduldedtask.workflow.utils.WorkflowArrayUtils;
import com.suncode.pwfl.core.type.StringType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.variable.Variable;
import com.suncode.pwfl.workflow.variable.VariableFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
class VariableProcessingServiceImpl
implements VariableProcessingService {
    @Autowired
    private VariableFactory variableFactory;

    VariableProcessingServiceImpl() {
    }

    @Override
    public Object readNewValue(MultipleValueSupport multiValues, List<Object> rawValues, Variable respectiveVariable) {
        if (respectiveVariable.isArray()) {
            String stringRawValues = rawValues.stream().map(valueObj -> Objects.toString(valueObj, "")).collect(Collectors.joining(";"));
            return respectiveVariable.getType().convert(stringRawValues);
        }
        if (rawValues.size() > 1) {
            switch (multiValues) {
                case BLOCK: {
                    throw new IllegalArgumentException("Cannot add multiple values to a non-array variable with multiple value handling unspecified or set to BLOCK!");
                }
                case FIRST: {
                    return rawValues.get(0) == null ? null : respectiveVariable.getType().convert(rawValues.get(0).toString());
                }
                case UNIQUE: {
                    Assert.isTrue((respectiveVariable.getType() == Types.STRING ? 1 : 0) != 0, (String)"Cannot add multiple values to a non-array variable which is also of a different type than string!");
                    return this.setMultipleValuesToStringVariable(rawValues);
                }
            }
            throw new IllegalArgumentException("Incorrect multiple values handling method specified!");
        }
        return rawValues.get(0) == null ? null : respectiveVariable.getType().convert(rawValues.get(0).toString());
    }

    @Override
    public Object readValue(MultipleValueSupport multiValues, Boolean overwriteArray, List<Object> rawValues, Variable respectiveVariable) {
        if (respectiveVariable.isArray()) {
            return this.prepareArrayValueToSet(rawValues, respectiveVariable, overwriteArray);
        }
        if (rawValues.size() > 1) {
            return this.handleMultipleValuesForNonArrayVariable(rawValues, respectiveVariable.getType(), multiValues);
        }
        return this.setFirstValue(rawValues, respectiveVariable.getType());
    }

    private Object[] prepareArrayValueToSet(List<Object> returnedValues, Variable variable, boolean overwriteArray) {
        Object[] data = Converter.dbArrayToPWFLArray(returnedValues.toArray(), variable.getType());
        if (overwriteArray) {
            return data;
        }
        Object[] variableValueArray = (Object[])variable.getValue();
        int currentColumnLength = WorkflowArrayUtils.isColumnEmpty((Object[])variable.getValue()) ? 0 : variableValueArray.length;
        Object[] result = WorkflowArrayUtils.createTableOfType(currentColumnLength + data.length, variable.getType());
        System.arraycopy(variableValueArray, 0, result, 0, currentColumnLength);
        System.arraycopy(data, 0, result, currentColumnLength, data.length);
        return result;
    }

    private Object handleMultipleValuesForNonArrayVariable(List<Object> returnedValues, Type<?> type, MultipleValueSupport multiVals) {
        switch (multiVals) {
            case BLOCK: {
                throw new RuntimeException("Cannot add multiple values to a non-array variable with multiple value handling unspecified or set to BLOCK!");
            }
            case FIRST: {
                return this.setFirstValue(returnedValues, type);
            }
            case UNIQUE: {
                Assert.isTrue((type == Types.STRING ? 1 : 0) != 0, (String)"Cannot add multiple values to a non-array variable which is also of a different type than string!");
                return this.setMultipleValuesToStringVariable(returnedValues);
            }
        }
        throw new RuntimeException("Incorrect multiple values handling method specified!");
    }

    private Object setFirstValue(List<Object> returnedValues, Type<?> type) {
        return returnedValues.get(0) == null ? null : Converter.dbObjectToPWFLObject(returnedValues.get(0), type);
    }

    private Object setMultipleValuesToStringVariable(List<Object> returnedValues) {
        return returnedValues.stream().map(arg_0 -> ((StringType)Types.STRING).read(arg_0)).distinct().collect(Collectors.joining(";"));
    }

    @Override
    public Map<String, Variable> convertContextToVariables(String processId, String activityId, Map<String, Object> context) {
        return this.variableFactory.createVariables(processId, activityId, context, true);
    }

    @Override
    public Map<String, Variable> getProcessVariables(@NonNull Package pack, String processDefId, String activityDefId, Map<String, Object> context, boolean compatibleValuesTypes) {
        if (pack == null) {
            throw new NullPointerException("pack");
        }
        return this.variableFactory.createVariables(pack, processDefId, activityDefId, context, compatibleValuesTypes);
    }
}

