/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.tools;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyInjector {
    private static final Logger log = LoggerFactory.getLogger(PropertyInjector.class);

    private PropertyInjector() {
    }

    public static String injectLastInstanceExecutionDate(String input, ScheduledTaskInstanceInfo taskInstanceInfo) {
        String lastInstanceExecutionDateTag = "{last_scheduledtask_instance_execute_time}";
        if (input.isEmpty() || !input.contains(lastInstanceExecutionDateTag)) {
            return input;
        }
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select last_run from pm_scheduled_tasks where scheduled_task_id = :taskInstanceId");
        builder.setParameter("taskInstanceId", (Object)taskInstanceInfo.getId());
        builder.addScalar("last_run", StandardBasicTypes.TIMESTAMP);
        SQLFinder finder = FinderFactory.getSQLFinder();
        CountedResult data = finder.find(builder, Integer.valueOf(0), Integer.valueOf(1));
        if (data.getTotal() == 0L) {
            return input.replace(lastInstanceExecutionDateTag, new Timestamp(0L).toString());
        }
        return input.replace(lastInstanceExecutionDateTag, ((Map)data.getData().get(0)).get("last_run").toString());
    }

    public static String injectLastExecutionDate(String input, ScheduledTaskInstanceInfo taskInstanceInfo) {
        String lastExecutionDateTag = "{last_scheduledtask_execute_time}";
        if (input.isEmpty() || !input.contains(lastExecutionDateTag)) {
            return input;
        }
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select pm_scheduled_tasks.last_run from pm_scheduled_tasks inner join (select class_name, method_name from pm_scheduled_tasks where scheduled_task_id = :taskInstanceId) taskinstance on pm_scheduled_tasks.class_name = taskinstance.class_name and pm_scheduled_tasks.method_name = taskinstance.method_name where pm_scheduled_tasks.scheduled_task_id != :taskInstanceId group by pm_scheduled_tasks.last_run");
        builder.setParameter("taskInstanceId", (Object)taskInstanceInfo.getId());
        builder.addSorter(new Sorter("last_run", SortDirection.DESC));
        builder.addScalar("last_run", StandardBasicTypes.TIMESTAMP);
        SQLFinder finder = FinderFactory.getSQLFinder();
        CountedResult data = finder.find(builder, Integer.valueOf(0), Integer.valueOf(1));
        if (data.getTotal() == 0L) {
            return input.replace(lastExecutionDateTag, new Timestamp(0L).toString());
        }
        return input.replace(lastExecutionDateTag, ((Map)data.getData().get(0)).get("last_run").toString());
    }

    public static String injectLastSuccessfulExecutionTime(String replacedString, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        Timestamp timestamp;
        String[] markers;
        block5: {
            block4: {
                markers = new String[]{"{timestamp}", "{DD}", "{MM}", "{YY}", "{YYYY}", "{hh}", "{mm}", "{ss}", "{nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block4;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block5;
            }
            return replacedString;
        }
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("SELECT startdate FROM pm_scheduled_tasks_history");
        builder.addFilter((SQLFilter)new SimpleSQLFilter("taskid", (Object)scheduledTaskInstanceInfo.getId()));
        builder.addFilter((SQLFilter)new SimpleSQLFilter("success", (Object)true));
        builder.addSorter(new Sorter("startdate", SortDirection.DESC));
        builder.addScalar("startdate", StandardBasicTypes.TIMESTAMP);
        SQLFinder finder = FinderFactory.getSQLFinder();
        CountedResult data = finder.find(builder, Integer.valueOf(0), Integer.valueOf(1));
        try {
            timestamp = (Timestamp)((Map)data.getData().get(0)).get("startdate");
        }
        catch (IndexOutOfBoundsException e) {
            timestamp = new Timestamp(0L);
        }
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }

    public static String injectCurrentTime(String replacedString) {
        String[] markers;
        block3: {
            block2: {
                markers = new String[]{"{current_timestamp}", "{current_DD}", "{current_MM}", "{current_YY}", "{current_YYYY}", "{current_hh}", "{current_mm}", "{current_ss}", "{current_nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block2;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block3;
            }
            return replacedString;
        }
        Timestamp timestamp = Timestamp.from(Instant.now());
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }

    private static String replaceTime(String replacedString, String[] markers, Timestamp timestamp) {
        return replacedString.replace(markers[0], Long.toString(timestamp.getTime())).replace(markers[1], String.format("%02d", timestamp.toLocalDateTime().getDayOfMonth())).replace(markers[2], String.format("%02d", timestamp.toLocalDateTime().getMonthValue())).replace(markers[3], String.format("%02d", timestamp.toLocalDateTime().getYear()).substring(2)).replace(markers[4], Integer.toString(timestamp.toLocalDateTime().getYear())).replace(markers[5], String.format("%02d", timestamp.toLocalDateTime().getHour())).replace(markers[6], String.format("%02d", timestamp.toLocalDateTime().getMinute())).replace(markers[7], String.format("%02d", timestamp.toLocalDateTime().getSecond())).replace(markers[8], String.format("%03d", timestamp.toLocalDateTime().getNano() / 1000000));
    }
}

