/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.service;

import com.suncode.plugin.scheduldedtask.service.EmailTagService;
import com.suncode.plugin.scheduldedtask.service.EmailTags;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class EmailTagServiceImpl
implements EmailTagService {
    private static final Logger log = LoggerFactory.getLogger(EmailTagServiceImpl.class);
    private static final String EMAIL_PATERN = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$";
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UserService userService;
    @Autowired
    private ActivityService activityService;

    @Override
    public Set<String> getEmailsByTag(String tag, List<String> allowedGroups) {
        return (Set)new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager()).execute(status -> {
            try {
                return this.getEmails(tag, allowedGroups);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Set<String> getEmails(String tag, List<String> allowedGroups) throws Exception {
        HashSet<String> result = new HashSet<String>();
        log.debug("Find email by tag");
        Pattern paternEmail = Pattern.compile(EMAIL_PATERN, 2);
        if (paternEmail.matcher(tag).find()) {
            result.add(tag);
        } else if (tag.matches("^" + EmailTags.ROLE.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.ROLE.length());
            result.addAll(this.getEmailByRole(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.USER.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.USER.length());
            result.addAll(this.getEmailByUser(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.GROUP.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.GROUP.length());
            result.addAll(this.getEmailByGroup(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.POSITION_BY_NAME.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.POSITION_BY_NAME.length());
            result.addAll(this.getEmailByPositionByName(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.POSITION_BY_SYMBOL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.POSITION_BY_SYMBOL.length());
            result.addAll(this.getEmailByPositionBySymbol(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.OU_BY_NAME.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.OU_BY_NAME.length());
            result.addAll(this.getEmailByOuByName(tagValue, allowedGroups));
        } else if (tag.matches("^" + EmailTags.OU_BY_SYMBOL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.OU_BY_SYMBOL.length());
            result.addAll(this.getEmailByOuBySymbol(tagValue, allowedGroups));
        } else {
            throw new Exception("No emails or wrong comand:\t" + tag);
        }
        return result;
    }

    @Override
    public Set<String> getEmailsByColumnTag(final String tag, final Map<String, String> rowData, final List<String> allowedGroups) {
        return (Set)new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager()).execute((TransactionCallback)new TransactionCallback<Set<String>>(){

            public Set<String> doInTransaction(TransactionStatus status) {
                try {
                    return EmailTagServiceImpl.this.getEmailsByColumn(tag, rowData, allowedGroups);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Set<String> getEmailsByColumn(String tag, Map<String, String> rowData, List<String> allowedGroups) {
        Set<String> result = new HashSet<String>();
        log.debug("Find email by column tag");
        if (tag.matches("^" + EmailTags.EMAIL_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.EMAIL_COL.length());
            result.addAll(this.getEmailByColumn(tagValue, rowData));
        } else if (tag.matches("^" + EmailTags.EXECUTOR.getName() + "")) {
            result.addAll(this.getEmailByExecutorTask(rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.ROLE_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.ROLE_COL.length());
            result.addAll(this.getEmailByRole(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.USER_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.USER_COL.length());
            result.addAll(this.getEmailByUser(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.GROUP_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.GROUP_COL.length());
            result.addAll(this.getEmailByGroup(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.POSITION_BY_NAME_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.POSITION_BY_NAME_COL.length());
            result.addAll(this.getEmailByPositionByName(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.POSITION_BY_SYMBOL_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.POSITION_BY_SYMBOL_COL.length());
            result.addAll(this.getEmailByPositionBySymbol(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.OU_BY_NAME_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.OU_BY_NAME_COL.length());
            result.addAll(this.getEmailByOuByName(tagValue, rowData, allowedGroups));
        } else if (tag.matches("^" + EmailTags.OU_BY_SYMBOL_COL.getName() + ".+")) {
            String tagValue = tag.substring(EmailTags.OU_BY_SYMBOL_COL.length());
            result.addAll(this.getEmailByOuBySymbol(tagValue, rowData, allowedGroups));
        } else {
            result = this.getEmailsByTag(tag, allowedGroups);
        }
        return result;
    }

    private Set<String> getEmailByExecutorTask(Map<String, String> rowData, List<String> allowedGroups) {
        HashSet<String> result = new HashSet<String>();
        String colProcessIdName = "processid";
        String colActivityIdName = "activityid";
        if ((rowData.containsKey(colProcessIdName.toUpperCase()) || rowData.containsKey(colProcessIdName.toLowerCase())) && (rowData.containsKey(colActivityIdName.toUpperCase()) || rowData.containsKey(colActivityIdName.toLowerCase()))) {
            String processId = rowData.get(colProcessIdName);
            String activityId = rowData.get(colActivityIdName);
            List AssigmentUsers = this.activityService.getAssignments(processId, activityId);
            log.debug("AssigmentUsers: " + AssigmentUsers);
            for (String userName : AssigmentUsers) {
                User user = this.userService.getUser(userName, new String[0]);
                this.getEmailFromUser(result, user, allowedGroups);
            }
        }
        return result;
    }

    private Set<String> getEmailByColumn(String column, Map<String, String> rowData) {
        HashSet<String> result = new HashSet<String>();
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            Pattern paternEmail = Pattern.compile(EMAIL_PATERN, 2);
            if (paternEmail.matcher(columnValue).find()) {
                result.add(columnValue);
            } else {
                log.debug("Value is not email:\t" + columnValue);
            }
            return result;
        }
        log.debug("No column: " + column);
        return result;
    }

    private Set<String> getEmailByOuByName(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByOuByName(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByOuBySymbol(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByOuBySymbol(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByPositionBySymbol(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByPositionBySymbol(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByPositionByName(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByPositionByName(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByGroup(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByGroup(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByUser(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByUser(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByRole(String column, Map<String, String> rowData, List<String> allowedGroups) {
        if (rowData.containsKey(column)) {
            String columnValue = rowData.get(column);
            return this.getEmailByRole(columnValue, allowedGroups);
        }
        log.debug("No column: " + column);
        return new HashSet<String>();
    }

    private Set<String> getEmailByOuBySymbol(String ouSymbol, List<String> allowedGroups) {
        log.debug("Find Email by OU Symbol " + ouSymbol);
        ArrayList<User> users = new ArrayList<User>();
        try {
            users.addAll(this.userFinder.findByOU(ouSymbol));
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
        }
        return this.getEmailFromUsers(users, allowedGroups);
    }

    private Set<String> getEmailByOuByName(String ouName, List<String> allowedGroups) {
        log.debug("Find Email by OU Name " + ouName);
        ArrayList<User> users = new ArrayList<User>();
        try {
            List ouList = this.ouFinder.findByName(ouName, new String[0]);
            for (OrganizationalUnit organizationalUnit : ouList) {
                String ouSymbol = organizationalUnit.getSymbol();
                users.addAll(this.userFinder.findByOU(ouSymbol));
            }
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
        }
        return this.getEmailFromUsers(users, allowedGroups);
    }

    private Set<String> getEmailByPositionBySymbol(String positionSymbol, List<String> allowedGroups) {
        log.debug("Find Email by Position Symbol " + positionSymbol);
        HashSet<String> result = new HashSet<String>();
        Position positionUser = this.positionFinder.findBySymbol(positionSymbol, new String[0]);
        if (positionUser != null) {
            User user = positionUser.getUser();
            this.getEmailFromUser(result, user, allowedGroups);
        }
        return result;
    }

    private void getEmailFromUser(Set<String> result, User user, List<String> allowedGroups) {
        if (user != null && user.getEmail() != null && !user.getEmail().isEmpty() && (allowedGroups.isEmpty() || this.checkUserbelongsToGroup(user, allowedGroups).booleanValue())) {
            log.debug(user.getFullName() + " : " + user.getEmail());
            if (this.isEmailUserSettingOn(user.getUserName())) {
                result.add(user.getEmail());
            }
        }
    }

    private Boolean checkUserbelongsToGroup(User user, List<String> groups) {
        Set userGrups = user.getGroups();
        if (userGrups == null) {
            throw new RuntimeException("User Groups is NULL");
        }
        for (UserGroup userGroup : userGrups) {
            String userGroupName = userGroup.getName();
            if (!groups.contains(userGroupName)) continue;
            return true;
        }
        log.debug("User no belong to groups:" + groups);
        return false;
    }

    private boolean isEmailUserSettingOn(String userName) {
        String emailSettings = this.userSettingsService.getSetting(userName, UserSettingsService.UserSetting.EMAILS);
        log.debug("Send Emails:\t" + emailSettings);
        return emailSettings == null || emailSettings.toUpperCase().equals("ON");
    }

    private Set<String> getEmailByPositionByName(String positionName, List<String> allowedGroups) {
        log.debug("Find Email by PositionName " + positionName);
        HashSet<String> result = new HashSet<String>();
        List positonUsers = this.positionFinder.findByName(positionName, new String[0]);
        log.debug("Find position " + positonUsers.size());
        for (Position position : positonUsers) {
            User user = position.getUser();
            this.getEmailFromUser(result, user, allowedGroups);
        }
        return result;
    }

    private Set<String> getEmailByGroup(String group, List<String> allowedGroups) {
        List users;
        log.debug("Find Email by Group " + group);
        log.debug("Get users for group");
        try {
            users = this.userFinder.findByGroup(group);
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            throw new RuntimeException(e);
        }
        return this.getEmailFromUsers(users, allowedGroups);
    }

    private Set<String> getEmailByUser(String userName, List<String> allowedGroups) {
        HashSet<String> result = new HashSet<String>();
        log.debug("Find Email by User " + userName);
        User user = this.userFinder.findByUserName(userName, new String[0]);
        this.getEmailFromUser(result, user, allowedGroups);
        return result;
    }

    private Set<String> getEmailByRole(String role, List<String> allowedGroups) {
        List users;
        log.debug("Find Email by Role " + role);
        ArrayList<RoleFilter> filters = new ArrayList<RoleFilter>();
        RoleFilter roleFilter = new RoleFilter();
        roleFilter.setRoleIds(Collections.singletonList(role));
        filters.add(roleFilter);
        log.debug("Get users for role");
        try {
            users = this.userFinder.findByRoles(filters);
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            throw new RuntimeException(e);
        }
        return this.getEmailFromUsers(users, allowedGroups);
    }

    private Set<String> getEmailFromUsers(List<User> users, List<String> allowedGroups) {
        HashSet<String> result = new HashSet<String>();
        log.debug("find users " + users.size());
        for (User user : users) {
            this.getEmailFromUser(result, user, allowedGroups);
        }
        return result;
    }
}

