/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.service;

import com.suncode.plugin.scheduldedtask.service.EmailEngine;
import com.suncode.plugin.scheduldedtask.service.TemplateTagService;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailEngineImpl
implements EmailEngine {
    private static final Logger log = LoggerFactory.getLogger(EmailEngineImpl.class);
    @Autowired
    private TemplateTagService templateTagService;
    @Autowired
    private EmailService emailService;

    @Override
    public void send(EmailConfiguration emailConfiguration, EmailMessage emailMessage) throws MessagingException {
        this.emailService.send(emailMessage, emailConfiguration);
    }

    @Override
    public EmailMessage newEmailMessage(String subject, String content, Map<String, String> variables) {
        return EmailMessage.builder().subject(this.templateTagService.formatContent(subject, variables)).content(this.templateTagService.formatContent(content, variables)).params(variables).isHtml(true).build();
    }

    @Override
    public EmailMessage newEmailMessage(String subject, String content, List<Map<String, String>> variables) {
        return EmailMessage.builder().subject(this.templateTagService.formatContent(subject, variables)).content(this.templateTagService.formatContent(content, variables)).params(variables.get(0)).isHtml(true).build();
    }
}

