/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.email;

import com.suncode.cuf.mail.Addresses;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.MailSender;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.cuf.mail.TemplateMailContent;
import com.suncode.cuf.util.CufComponentFactory;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EmailSenderService {
    private static final Logger log = LoggerFactory.getLogger(EmailSenderService.class);

    public String sendAuditReport(List<String> recipients, String emailSubject, String emailTemplatePath, String attachmentPath, Boolean sendAsOne) {
        TemplateMailContent content = this.newTemplateMailContent(emailSubject, emailTemplatePath);
        content.addAttachment(this.buildAttachmentName(), attachmentPath);
        return this.buildSendReportLog(this.send((MailContent)content, recipients, sendAsOne));
    }

    private SendReport send(MailContent content, List<String> directAddresses, boolean sendAsOne) {
        SystemMailConfiguration cfg = SystemMailConfiguration.getInstance();
        MailSender mailSender = CufComponentFactory.getMailSender();
        Addresses addresses = new Addresses(directAddresses);
        addresses.setSendAsOne(sendAsOne);
        return mailSender.send((MailConfiguration)cfg, content, addresses);
    }

    private TemplateMailContent newTemplateMailContent(String subject, String templatePath) {
        TemplateMailContent mailContent = new TemplateMailContent();
        mailContent.setSubject(subject);
        mailContent.setTemplatePath(templatePath);
        return mailContent;
    }

    private String buildAttachmentName() {
        String dateFile = DateTime.now().toString("yyyy-MM-dd");
        return "AuditReport-" + dateFile + ".xlsx";
    }

    private String buildSendReportLog(SendReport sendReport) {
        StringBuilder stringBuilder = new StringBuilder("\nSend Report:");
        stringBuilder.append("\nsuccessfulEmails:\t").append(sendReport.getSuccessfulEmails()).append("\nfailedEmails:\t").append(sendReport.getFailedEmails());
        log.debug(stringBuilder.toString());
        return stringBuilder.toString();
    }
}

