/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.activity.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.suncode.plugin.scheduldedtask.activity.common.AcceptActivityConfig;
import com.suncode.plugin.scheduldedtask.activity.service.AcceptActivityService;
import com.suncode.plugin.scheduldedtask.activity.service.ActivityContextService;
import com.suncode.plugin.scheduldedtask.activity.service.VariableProcessingService;
import com.suncode.plugin.scheduldedtask.tools.Converter;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcceptActivityServiceImpl
implements AcceptActivityService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityContextService activityContextService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ProcessService processService;
    @Autowired
    private VariableProcessingService variableProcessingService;

    @Override
    public void acceptActivityWithData(AcceptActivityConfig acceptActivityConfig) {
        AcceptationDefinition acceptation = new AcceptationDefinition(acceptActivityConfig.getProcessId(), acceptActivityConfig.getActivityId(), acceptActivityConfig.getExecutor(), acceptActivityConfig.getActionName());
        acceptation.setIgnoreOwnerShip(Boolean.valueOf(true));
        acceptation.setContextMap(this.processService.getProcessContext(acceptActivityConfig.getProcessId()));
        acceptation.setIgnoreValidators(Boolean.valueOf(acceptActivityConfig.isIgnoreValidators()));
        if (acceptActivityConfig.isSaveDataToActivity()) {
            this.updateAcceptationContextMap(acceptation, acceptActivityConfig);
        }
        this.activityService.acceptActivity(acceptation);
    }

    private void updateAcceptationContextMap(AcceptationDefinition acceptation, AcceptActivityConfig acceptActivityConfig) {
        Map context = acceptation.getContextMap();
        Map<String, Variable> variables = this.variableProcessingService.convertContextToVariables(acceptActivityConfig.getProcessId(), acceptActivityConfig.getActivityId(), context);
        ListMultimap<String, Object> multimapData = Converter.convertMapListToMultimap(acceptActivityConfig.getNewValues());
        ArrayListMultimap multimapDataLowerCase = ArrayListMultimap.create();
        multimapData.entries().forEach(arg_0 -> AcceptActivityServiceImpl.lambda$updateAcceptationContextMap$0((ListMultimap)multimapDataLowerCase, arg_0));
        multimapDataLowerCase.asMap().entrySet().stream().filter(entry -> this.activityContextService.activityContextContainsVariable(variables, (String)entry.getKey(), acceptActivityConfig.getActivityId())).forEach(entry -> {
            Variable variable = (Variable)variables.get(entry.getKey());
            variable.setValue(this.variableProcessingService.readValue(acceptActivityConfig.getMultipleValueSupport(), acceptActivityConfig.isOverwriteArray(), (List)entry.getValue(), variable));
            context.put(entry.getKey(), variable.getValueAsBasicType());
        });
    }

    @Override
    public List<Activity> getOpenActivities(String userNames, String processDefId, String activityDefId) {
        if (StringUtils.isBlank((CharSequence)userNames)) {
            return this.activityFinder.findActivities(processDefId, activityDefId, Arrays.asList(ActivityState.RUNNING, ActivityState.NOT_STARTED, ActivityState.SUSPENDED), new String[]{"process.processDefinition"});
        }
        String[] userNamesArray = (String[])Arrays.stream(userNames.split(",")).map(String::trim).distinct().toArray(String[]::new);
        ArrayList activities = new ArrayList();
        for (String userName : userNamesArray) {
            activities.addAll(this.activityFinder.findActivitiesAssignedToUser(userName, new String[]{"process", "process.processDefinition"}));
        }
        return activities.stream().filter(this.matchOpenActivities(processDefId, activityDefId)).filter(this.distinctByKey(Activity::getProcessId)).collect(Collectors.toList());
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private Predicate<? super Activity> matchOpenActivities(String processDefId, String activityDefId) {
        return activity -> ActivityState.isOpen((ActivityState)activity.getState()) && activity.getActivityDefinitionId().equalsIgnoreCase(activityDefId) && activity.getProcess().getProcessDefinition().getProcessDefinitionId().equalsIgnoreCase(processDefId);
    }

    @Override
    public Object[] readParametersFromOpenActivity(String variableIds, String activityId, String processId) {
        if (StringUtils.isBlank((CharSequence)variableIds)) {
            return new Object[0];
        }
        return this.activityContextService.readParametersFromActivity(Arrays.asList(variableIds.split(",")), activityId, processId);
    }

    private static /* synthetic */ void lambda$updateAcceptationContextMap$0(ListMultimap multimapDataLowerCase, Map.Entry entry) {
        multimapDataLowerCase.put((Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
    }
}

