/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.google.common.collect.Lists;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.db.service.DBService;
import com.suncode.plugin.scheduldedtask.service.EmailEngine;
import com.suncode.plugin.scheduldedtask.service.EmailTagService;
import com.suncode.plugin.scheduldedtask.service.HolidaysService;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTaskScript;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
@ScheduledTaskScript(value="scripts/email-by-sql-form.js")
public class EmailBySQL {
    private static final Logger log = LoggerFactory.getLogger(EmailBySQL.class);
    private static final String GROUP_SEPARATOR = ";";
    @Autowired
    private EmailConfigurationService emailConfigurationService;
    @Autowired
    EmailEngine emailEngine;
    @Autowired
    DBService dbService;
    @Autowired
    HolidaysService holidayService;
    @Autowired
    EmailTagService emailTagService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.email-by-sql")).name("scheduledtask.email-by-sql.name")).description("scheduledtask.email-by-sql.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).parameter().id("email-config-id").name("scheduledtask.email-by-sql.email-config-id.name").description("scheduledtask.email-by-sql.email-config-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("quary-name").name("scheduledtask.email-by-sql.quary-name.name").description("scheduledtask.email-by-sql.quary-name.desc").type((Type)Types.STRING).create()).parameter().id("db-name").name("scheduledtask.email-by-sql.db-name.name").description("scheduledtask.email-by-sql.db-name.desc").type((Type)Types.STRING).defaultValue((Object)"PlusWorkflow").create()).parameter().id("subject").name("scheduledtask.email-by-sql.subject.name").description("scheduledtask.email-by-sql.subject.desc").type((Type)Types.STRING).create()).parameter().id("tempalte-path").name("scheduledtask.email-by-sql.tempalte-path.name").description("scheduledtask.email-by-sql.tempalte-path.desc").type((Type)Types.STRING).create()).parameter().id("address-to").name("scheduledtask.email-by-sql.address_to.name").description("scheduledtask.email-by-sql.address_to.desc").type((Type)Types.STRING).create()).parameter().id("check-holidays").name("scheduledtask.email-by-sql.check-holidays.name").description("scheduledtask.email-by-sql.check-holidays.desc").type((Type)Types.BOOLEAN).create()).parameter().id("group-by-email").name("scheduledtask.email-by-sql.group-by-email.name").description("scheduledtask.email-by-sql.group-by-email.desc").type((Type)Types.BOOLEAN).create()).parameter().id("allowed-groups").name("scheduledtask.email-by-sql.group-allow.name").description("scheduledtask.email-by-sql.group-allow.desc").type((Type)Types.STRING).optional().create()).parameter().id("ignore-errors").name("scheduledtask.email-by-sql.ignore-errors.name").description("scheduledtask.email-by-sql.ignore-errors.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public String execute(@Param(value="email-config-id") String emailConfigId, @Param(value="quary-name") String queryName, @Param(value="db-name") String dbName, @Param(value="subject") String subject, @Param(value="tempalte-path") String templatePath, @Param(value="address-to") String addressTo, @Param(value="check-holidays") Boolean checkHolidays, @Param(value="group-by-email") Boolean groupByEmail, @Param(value="allowed-groups") String allowedGroups, @Param(value="ignore-errors") Boolean ignoreErrors, org.apache.log4j.Logger taskLog) throws Exception {
        try {
            EmailConfiguration emailConfiguration;
            EmailConfiguration emailConfiguration2 = emailConfiguration = StringUtils.isNotEmpty((CharSequence)emailConfigId) ? (EmailConfiguration)this.emailConfigurationService.get((Serializable)Long.valueOf(emailConfigId), new String[]{"oauth2Connection"}) : SystemMailConfiguration.getInstance().getEmailConfiguration();
            if (checkHolidays.booleanValue() && this.holidayService.isHoliday(DateTime.now().toLocalDate()).booleanValue()) {
                taskLog.info((Object)"No messages will be sent because today is a holiday.");
                return "";
            }
            ArrayList<String> allowedGroupList = new ArrayList();
            if (allowedGroups != null) {
                allowedGroupList = Arrays.asList(allowedGroups.split(GROUP_SEPARATOR));
            }
            taskLog.debug((Object)("Query name: " + queryName));
            taskLog.debug((Object)"Executing query...");
            List<Map<String, Object>> result = this.dbService.getDataFromQueryName(dbName, queryName);
            taskLog.debug((Object)("Result size: " + result.size()));
            if (result.isEmpty()) {
                taskLog.info((Object)MessageFormat.format("Query \"{0}\" did not return any data. No messages will be sent.", queryName));
                return "";
            }
            ArrayList<SendReport> sendReports = new ArrayList<SendReport>();
            if (Boolean.FALSE.equals(groupByEmail)) {
                for (Map<String, Object> map : result) {
                    taskLog.debug((Object)("Row: " + map.toString()));
                    String string = FileUtils.readFileToString((File)new File(templatePath.trim()), (Charset)StandardCharsets.UTF_8);
                    Map<String, String> variables = this.convertMap(map);
                    EmailMessage emailMessage = this.emailEngine.newEmailMessage(subject, string, variables);
                    List<String> recipients = this.getAddressEmail(addressTo, variables, allowedGroupList);
                    sendReports.add(this.sendMail(emailConfiguration, emailMessage, recipients, ignoreErrors, taskLog));
                }
            } else {
                Map<String, List<Map<String, String>>> toSendData = this.groupData(addressTo, result, allowedGroupList);
                for (Map.Entry<String, List<Map<String, String>>> entry : toSendData.entrySet()) {
                    String content = FileUtils.readFileToString((File)new File(templatePath.trim()), (Charset)StandardCharsets.UTF_8);
                    List<Map<String, String>> data = entry.getValue();
                    EmailMessage emailMessage = this.emailEngine.newEmailMessage(subject, content, data);
                    String recipient = entry.getKey();
                    sendReports.add(this.sendMail(emailConfiguration, emailMessage, Lists.newArrayList((Object[])new String[]{recipient}), ignoreErrors, taskLog));
                }
            }
            int successCount = sendReports.stream().mapToInt(sendReport -> sendReport.getSuccessfulEmails().size()).sum();
            int n = sendReports.stream().mapToInt(sendReport -> sendReport.getFailedEmails().size()).sum();
            String string = MessageFormat.format("Successes: {0}, Errors: {1}.", successCount, n);
            taskLog.info((Object)string);
            return string;
        }
        catch (Exception e) {
            throw new AcceptanceException((Throwable)e);
        }
    }

    private SendReport sendMail(EmailConfiguration emailConfiguration, EmailMessage emailMessage, List<String> recipients, Boolean ignoreErrors, org.apache.log4j.Logger taskLog) throws Exception {
        SendReport report = new SendReport();
        for (String recipient : recipients) {
            try {
                emailMessage.setRecipients((List)Lists.newArrayList((Object[])new String[]{recipient}));
                this.emailEngine.send(emailConfiguration, emailMessage);
                report.getSuccessfulEmails().add(recipient);
                taskLog.info((Object)MessageFormat.format("Successfully sent message to {0}.", recipient));
            }
            catch (Exception e) {
                report.getFailedEmails().add(recipient);
                String exceptionMessage = this.getExceptionMessage(e);
                String details = MessageFormat.format("Could not send message to {0}. Reason: {1}.", recipient, exceptionMessage);
                if (Boolean.TRUE.equals(ignoreErrors)) {
                    taskLog.warn((Object)details);
                    log.warn(exceptionMessage, (Throwable)e);
                    continue;
                }
                taskLog.error((Object)details);
                log.error(exceptionMessage, (Throwable)e);
                throw e;
            }
        }
        return report;
    }

    private Map<String, String> convertMap(Map<String, Object> row) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            variables.put(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : "NULL");
        }
        return variables;
    }

    private Map<String, List<Map<String, String>>> groupData(String addressTo, List<Map<String, Object>> data, List<String> allowedGroup) throws Exception {
        HashMap<String, List<Map<String, String>>> result = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, Object> rowData : data) {
            Map<String, String> row = this.convertMap(rowData);
            Set<String> emailsList = this.emailTagService.getEmailsByColumnTag(addressTo, row, allowedGroup);
            for (String email : emailsList) {
                if (!StringUtils.isNotBlank((CharSequence)email)) continue;
                if (!result.containsKey(email)) {
                    result.put(email, new ArrayList());
                }
                ((List)result.get(email)).add(row);
            }
        }
        return result;
    }

    private List<String> getAddressEmail(String addressTo, Map<String, String> variables, List<String> allowedGroups) {
        return new ArrayList<String>(this.emailTagService.getEmailsByColumnTag(addressTo, variables, allowedGroups));
    }

    private String getExceptionMessage(Throwable throwable) {
        Throwable currentThrowable = throwable;
        String message = currentThrowable.getMessage();
        while (currentThrowable.getCause() != null && StringUtils.isEmpty((CharSequence)message)) {
            currentThrowable = currentThrowable.getCause();
            message = currentThrowable.getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = currentThrowable.getClass().getSimpleName();
        }
        return message;
    }
}

