/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.db.entities.CreatedProcesses;
import com.suncode.plugin.scheduldedtask.db.service.CreatedProcessesService;
import com.suncode.plugin.scheduldedtask.db.service.DBService;
import com.suncode.plugin.scheduldedtask.schemas.CreateProcessInfoDto;
import com.suncode.plugin.scheduldedtask.task.logger.LoggerFormatter;
import com.suncode.plugin.scheduldedtask.tools.Converter;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class CreateProcessWithDBexplorer {
    private static final Logger log = LoggerFactory.getLogger(CreateProcessWithDBexplorer.class);
    @Autowired
    private DBService dbService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private CreatedProcessesService createdProcessesService;
    private final String SEPARATOR = ";;";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.create-process-with-dbexplorer")).name("scheduledtask.create-process-with-dbexplorer.name")).description("scheduledtask.create-process-with-dbexplorer.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).cancelable().parameter().id("db-name").name("scheduledtask.create-process-with-dbexplorer.db-name.name").description("scheduledtask.create-process-with-dbexplorer.db-name.desc").type((Type)Types.STRING).create()).parameter().id("quary-name").name("scheduledtask.create-process-with-dbexplorer.quary-name.name").description("scheduledtask.create-process-with-dbexplorer.quary-name.desc").type((Type)Types.STRING).create()).parameter().id("process-def-id").name("scheduledtask.create-process-with-dbexplorer.process-def-id.name").description("scheduledtask.create-process-with-dbexplorer.process-def-id.desc").type((Type)Types.STRING).create()).parameter().id("primal-key").name("scheduledtask.create-process-with-dbexplorerl.primal-key.name").description("scheduledtask.create-process-with-dbexplorer.primal-key.desc").type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param(value="db-name") String dbName, @Param(value="quary-name") String queryName, @Param(value="process-def-id") String processDefId, @Param(value="primal-key") String columnNames, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLogger) {
        taskLogger.info((Object)("Start task " + scheduledTaskInfo.getName()));
        List<Map<String, Object>> data = this.dbService.getDataFromQueryName(dbName, queryName);
        ProcessDefinition processDef = this.getProcessDefinition(processDefId, taskLogger);
        List<String> columnNamesKey = this.readColumnNames(columnNames);
        Boolean saveTable = this.isSaveTable(columnNames, data, columnNamesKey, taskLogger);
        int successCreateProcessCount = 0;
        int errorCreateProcessCount = 0;
        for (Map<String, Object> dataRow : data) {
            if (cancelationHandler.isCanceled().booleanValue()) {
                taskLogger.info((Object)"Cancel by user");
                taskLogger.info((Object)("End task " + scheduledTaskInfo.getName()));
                return "Cancel by User";
            }
            Boolean createdProcess = false;
            String key = this.buildKey(dataRow, columnNamesKey);
            if (saveTable.booleanValue()) {
                CreatedProcesses entity = this.createdProcessesService.findOne(key, scheduledTaskInfo.getId());
                if (entity == null) {
                    this.createdProcessesService.save(scheduledTaskInfo, key);
                } else {
                    createdProcess = entity.getCreatedProcess();
                }
            }
            if (createdProcess.booleanValue()) continue;
            CreateProcessInfoDto createProcessInfoDto = this.createProcess(processDefId, processDef.getPackageId(), scheduledTaskInfo, saveTable, dataRow, key);
            if (createProcessInfoDto.getSuccess().booleanValue()) {
                taskLogger.info((Object)("Created:\t" + createProcessInfoDto.getProcessId()));
                taskLogger.info((Object)LoggerFormatter.toStringContext(createProcessInfoDto.getContext()));
                ++successCreateProcessCount;
                continue;
            }
            ++errorCreateProcessCount;
            StringBuilder sb = new StringBuilder();
            sb.append(createProcessInfoDto.getErrorMessage());
            sb.append(LoggerFormatter.toStringContext(createProcessInfoDto.getContext()));
            taskLogger.info((Object)sb.toString());
        }
        String summarize = this.summarize(successCreateProcessCount, errorCreateProcessCount, data.size());
        taskLogger.info((Object)summarize);
        taskLogger.info((Object)("End task " + scheduledTaskInfo.getName()));
        return summarize;
    }

    private String summarize(int success, int errors, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append("Success\t").append(success).append("/").append(size).append("\t");
        sb.append("Error\t").append(errors).append("/").append(size).append("\t");
        sb.append("Skip\t").append(size - errors - success).append("/").append(size).append("\t");
        return sb.toString();
    }

    private CreateProcessInfoDto createProcess(String processDefId, String packageId, ScheduledTaskInstanceInfo scheduledTaskInfo, Boolean saveTable, Map<String, Object> dataRow, String key) {
        CreateProcessInfoDto cpInfoDto = new CreateProcessInfoDto(processDefId, packageId);
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setCreator("admin");
        definition.setPackageId(packageId);
        definition.setProcessDefId(processDefId);
        try {
            definition.setVariables(this.buildProcesContext(processDefId, dataRow));
            cpInfoDto.setContext(definition.getVariables());
        }
        catch (Exception e) {
            log.debug("Error creating context", (Throwable)e);
            cpInfoDto.setErrorMessage("Error creating context:\t" + e.getMessage());
            cpInfoDto.setContext(dataRow);
            return cpInfoDto;
        }
        try {
            String processId = this.processService.createProcess(definition);
            cpInfoDto.setProcessId(processId);
            cpInfoDto.setSuccess(true);
            if (saveTable.booleanValue()) {
                this.createdProcessesService.update(processId, scheduledTaskInfo, true, key);
            }
        }
        catch (Exception e) {
            log.debug("Error creating process", (Throwable)e);
            cpInfoDto.setErrorMessage("Error creating process:\t" + e.getMessage());
        }
        return cpInfoDto;
    }

    private Boolean isSaveTable(String columnNames, List<Map<String, Object>> data, List<String> columnNamesKey, org.apache.log4j.Logger taskLogger) {
        if (columnNamesKey.isEmpty()) {
            return false;
        }
        if (this.correctColumnNames(data, columnNamesKey)) {
            return true;
        }
        taskLogger.info((Object)("ERROR:\t Incorrect parameter columnNames [" + columnNames + "] . One or more ColumnName doesn't exists"));
        throw new IllegalArgumentException("ERROR:\t Incorrect parameter columnNames [" + columnNames + "] . One or more ColumnName doesn't exists");
    }

    private ProcessDefinition getProcessDefinition(String processDefId, org.apache.log4j.Logger taskLogger) {
        ProcessDefinition processDef = this.processService.getProcessDefinition(processDefId);
        if (processDef == null) {
            taskLogger.info((Object)("ERROR:\t Incorrect parameter processDefId [" + processDefId + "] . ProcessDef doesn't exists"));
            throw new IllegalArgumentException("ERROR:\t Incorrect parameter processDefId [" + processDefId + "] . ProcessDef doesn't exists");
        }
        return processDef;
    }

    private List<String> readColumnNames(String columnNames) {
        String[] array;
        ArrayList<String> listColumnNames = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)columnNames)) {
            return listColumnNames;
        }
        for (String columnName : array = columnNames.split(";")) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{columnName})) continue;
            listColumnNames.add(columnName.trim());
        }
        return listColumnNames;
    }

    private boolean correctColumnNames(List<Map<String, Object>> data, List<String> columnNames) {
        if (data.isEmpty()) {
            return true;
        }
        Map<String, Object> oneRow = data.get(0);
        for (String columnName : columnNames) {
            if (oneRow.containsKey(columnName.trim())) continue;
            return false;
        }
        return true;
    }

    private String buildKey(Map<String, Object> dataRow, List<String> columnNames) {
        StringBuilder sb = new StringBuilder();
        for (String columnName : columnNames) {
            if (!dataRow.containsKey(columnName)) continue;
            Object obj = dataRow.get(columnName);
            sb.append(obj != null ? obj.toString() : "NULL").append(";;");
        }
        return sb.toString();
    }

    private Map<String, Object> buildProcesContext(String processDefId, Map<String, Object> dataRow) throws ParseException {
        HashMap<String, ProcessIndex> idsProcessIndex = new HashMap<String, ProcessIndex>();
        for (ProcessIndex processIndex : this.processService.getProcessIndexes(processDefId)) {
            idsProcessIndex.put(processIndex.getId(), processIndex);
        }
        HashMap<String, Object> variable2Update = new HashMap<String, Object>();
        for (String columnName : dataRow.keySet()) {
            String variableID = columnName.toLowerCase();
            if (!idsProcessIndex.containsKey(variableID)) continue;
            variable2Update.put(variableID, Converter.convertObject2ProcessObj(dataRow.get(columnName), (ProcessIndex)idsProcessIndex.get(variableID)));
        }
        return variable2Update;
    }
}

