/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.activity.common.AcceptActivityConfig;
import com.suncode.plugin.scheduldedtask.activity.common.MultipleValueSupport;
import com.suncode.plugin.scheduldedtask.activity.service.AcceptActivityService;
import com.suncode.plugin.scheduldedtask.db.common.DBQueryConfig;
import com.suncode.plugin.scheduldedtask.db.service.DBService;
import com.suncode.plugin.scheduldedtask.exceptions.TaskCanceledException;
import com.suncode.plugin.scheduldedtask.exceptions.checker.ExceptionChecker;
import com.suncode.plugin.scheduldedtask.summary.TaskSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@ScheduledTask
public class AcceptActivityWithDBexplorer {
    private static final Logger log = LoggerFactory.getLogger(AcceptActivityWithDBexplorer.class);
    @Autowired
    private DBService dbService;
    @Autowired
    private AcceptActivityService acceptActivityService;
    private static final String ADMINISTRATOR_LOGIN = "admin";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.accept-activity-with-dbexplorer")).name("scheduledtask.accept-activity-with-dbexplorer.name")).description("scheduledtask.accept-activity-with-dbexplorer.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).cancelable().parameter().id("dbName").name("scheduledtask.default.dbName.name").description("scheduledtask.default.dbName.desc").type((Type)Types.STRING).create()).parameter().id("queryName").name("scheduledtask.default.quaryName.name").description("scheduledtask.default.quaryName.desc").type((Type)Types.STRING).create()).parameter().id("userName").name("scheduledtask.accept-activity-with-dbexplorer.userName.name").description("scheduledtask.accept-activity-with-dbexplorer.userName.desc").type((Type)Types.STRING).optional().create()).parameter().id("processDefId").name("scheduledtask.default.processDefId.name").description("scheduledtask.default.processDefId.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("scheduledtask.default.activityDefId.name").description("scheduledtask.default.activityDefId.desc").type((Type)Types.STRING).create()).parameter().id("actionName").name("scheduledtask.accept-activity-with-dbexplorer.actionName.name").description("scheduledtask.accept-activity-with-dbexplorer.actionName.desc").type((Type)Types.STRING).optional().create()).parameter().id("inputVariableIds").name("scheduledtask.accept-activity-with-dbexplorer.inputVariableIds.name").description("scheduledtask.accept-activity-with-dbexplorer.inputVariableIds.desc").type((Type)Types.STRING).optional().create()).parameter().id("saveDataToActivity").name("scheduledtask.accept-activity-with-dbexplorer.saveDataToActivity.name").description("scheduledtask.accept-activity-with-dbexplorer.saveDataToActivity.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("multiVals").name("scheduledtask.accept-activity-with-dbexplorer.multiVals.name").description("scheduledtask.accept-activity-with-dbexplorer.multiVals.desc").type((Type)Types.STRING).defaultValue((Object)"BLOCK").create()).parameter().id("overwriteArray").name("scheduledtask.accept-activity-with-dbexplorer.overwriteArray.name").description("scheduledtask.accept-activity-with-dbexplorer.overwriteArray.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("invokeValidators").name("scheduledtask.accept-activity-with-dbexplorer.invokeValidators.name").description("scheduledtask.accept-activity-with-dbexplorer.invokeValidators.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public String execute(@Param String dbName, @Param String queryName, @Param String userName, @Param String processDefId, @Param String activityDefId, @Param String actionName, @Param String inputVariableIds, @Param Boolean saveDataToActivity, @Param String multiVals, @Param Boolean overwriteArray, @Param Boolean invokeValidators, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLog) {
        taskLog.info((Object)("Start task: " + scheduledTaskInfo.getName()));
        if (!UserContext.isActive()) {
            UserContext.activate((String)ADMINISTRATOR_LOGIN);
        }
        TaskSummary taskSummary = new TaskSummary(taskLog);
        try {
            this.assertParameters(dbName, queryName, processDefId, activityDefId, multiVals);
            List<Activity> activities = this.acceptActivityService.getOpenActivities(userName, processDefId, activityDefId);
            taskSummary.setTotal(activities.size());
            taskLog.info((Object)("Found " + activities.size() + " activities"));
            activities.forEach(activity -> {
                ExceptionChecker.checkTaskCancellation(cancelationHandler);
                this.acceptActivityByDBExplorer(dbName, queryName, actionName, inputVariableIds, saveDataToActivity, multiVals, overwriteArray, invokeValidators, taskSummary, (Activity)activity);
            });
        }
        catch (TaskCanceledException cte) {
            taskLog.info((Object)"Cancelled by user");
            String string = "Cancelled by user. " + taskSummary.summary();
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)"ERROR:", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.info((Object)taskSummary.summary());
            taskLog.info((Object)("End task: " + scheduledTaskInfo.getName()));
        }
        return taskSummary.summary();
    }

    private void assertParameters(String dbName, String queryName, String processDefId, String activityDefId, String multiVals) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dbName), (String)"The parameter dbName cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)queryName), (String)"The parameter queryName cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)processDefId), (String)"The parameter processDefId cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)activityDefId), (String)"The parameter activityDefId cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)multiVals), (String)"The parameter multiVals cannot be empty");
    }

    private void acceptActivityByDBExplorer(String dbName, String queryName, String actionName, String inputVariableIds, Boolean saveDataToActivity, String multiVals, Boolean overwriteArray, Boolean invokeValidators, TaskSummary taskSummary, Activity activity) {
        String activityId = activity.getActivityId();
        String processId = activity.getProcessId();
        try {
            DBQueryConfig dbQueryCfg = DBQueryConfig.builder().dbName(dbName).queryKey(queryName).queryParams(this.acceptActivityService.readParametersFromOpenActivity(inputVariableIds, activityId, processId)).build();
            List<Map<String, Object>> data = this.dbService.getDataFromQuery(dbQueryCfg);
            taskSummary.logDebug(data.size() + " results have been returned from database for the task with id " + activityId);
            if (!data.isEmpty()) {
                AcceptActivityConfig acceptActivityConfig = AcceptActivityConfig.builder().actionName(actionName).activityId(activityId).multipleValueSupport(MultipleValueSupport.valueOf(multiVals.toUpperCase())).newValues(data).overwriteArray(overwriteArray).processId(processId).saveDataToActivity(saveDataToActivity).ignoreValidators(invokeValidators == false).build();
                this.acceptActivityService.acceptActivityWithData(acceptActivityConfig);
                taskSummary.incrementSuccess();
                taskSummary.logDebug("Activity with id " + activityId + " accepted");
                log.info("Accepted activity id: " + activityId + ", process id: " + processId);
            }
        }
        catch (Exception e) {
            taskSummary.incrementErrors();
            taskSummary.logError("Error with acceptance activity by id: " + activityId, e);
        }
    }
}

