/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.service;

import com.suncode.plugin.scheduldedtask.db.entities.ImportedDocument;
import com.suncode.plugin.scheduldedtask.db.entities.ImportedDocumentDao;
import com.suncode.plugin.scheduldedtask.service.ImportedDocumentService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImportedDocumentServiceImpl
extends EditableServiceImpl<ImportedDocument, Long, ImportedDocumentDao>
implements ImportedDocumentService {
    private static final Logger log = LoggerFactory.getLogger(ImportedDocumentServiceImpl.class);
    private static final Map<String, Boolean> cache = new LinkedHashMap<String, Boolean>();
    private static final int CACHE_SIZE = 100;

    @Autowired
    public void setDao(ImportedDocumentDao dao) {
        this.dao = dao;
    }

    private ImportedDocument findOne(String filePath, String docClassName) {
        HibernateCriteria dc = HibernateCriteria.forClass(ImportedDocument.class).add(Restrictions.eq((String)"filePath", (Object)filePath)).add(Restrictions.eq((String)"docClassName", (Object)docClassName));
        return (ImportedDocument)((ImportedDocumentDao)this.dao).findOne(dc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrSave(ImportedDocument entity) {
        Map<String, Boolean> map = cache;
        synchronized (map) {
            this.removeCache(entity.getFilePath(), entity.getDocClassName());
        }
        ImportedDocument entityFound = this.findOne(entity.getFilePath(), entity.getDocClassName());
        if (entityFound == null) {
            log.debug("Save new ");
            log.debug(entity.toString());
            ((ImportedDocumentDao)this.dao).save(entity);
        } else {
            log.debug("Don't save. Data with filePath:\t" + entity.getFilePath() + " and DocClassName:\t" + entity.getDocClassName() + " already exist");
            log.debug(entityFound.toString());
            entityFound.setErrorMsg(entity.getErrorMsg());
            entityFound.setDocId(entity.getDocId());
            entityFound.setDocClassName(entity.getDocClassName());
            entityFound.setImported(entity.getImported());
            entityFound.setUpdateTime(entity.getUpdateTime());
            entityFound.setVersion(entity.getVersion());
            ((ImportedDocumentDao)this.dao).update(entityFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isImported(String filePath, String docClassName) {
        Map<String, Boolean> map = cache;
        synchronized (map) {
            String cacheKey = this.cacheKey(filePath, docClassName);
            Boolean result = this.getCache(cacheKey);
            if (result == null) {
                ImportedDocument entityFinded = this.findOne(filePath, docClassName);
                if (entityFinded == null) {
                    this.putCache(cacheKey, false);
                    return false;
                }
                this.putCache(cacheKey, entityFinded.getImported());
                return entityFinded.getImported();
            }
            return result;
        }
    }

    private String cacheKey(String filePath, String docClassName) {
        return filePath + "::" + docClassName;
    }

    private void putCache(String key, Boolean value) {
        int size = cache.size();
        if (size >= 100) {
            String firstKey = (String)cache.keySet().stream().findFirst().get();
            cache.remove(firstKey);
        }
        cache.put(key, value);
    }

    private void removeCache(String filePath, String docClassName) {
        cache.remove(this.cacheKey(filePath, docClassName));
    }

    private Boolean getCache(String cacheKey) {
        if (cache.containsKey(cacheKey)) {
            return cache.get(cacheKey);
        }
        return null;
    }
}

