/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.tools;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditTools {
    private static final Logger log = LoggerFactory.getLogger(AuditTools.class);

    public static String getDurationValue(long duration) {
        try {
            long days = TimeUnit.MILLISECONDS.toDays(duration);
            long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
            long milliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
            DecimalFormat twoPlacesFormat = new DecimalFormat("00");
            DecimalFormat threePlacesFormat = new DecimalFormat("000");
            if (days > 0L) {
                return days + ":" + twoPlacesFormat.format(hours) + ":" + twoPlacesFormat.format(minutes) + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(milliseconds);
            }
            if (hours > 0L) {
                return hours + ":" + twoPlacesFormat.format(minutes) + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(milliseconds);
            }
            if (minutes > 0L) {
                return minutes + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(milliseconds);
            }
            if (seconds > 0L) {
                return seconds + "." + threePlacesFormat.format(milliseconds);
            }
            if (milliseconds > 0L) {
                return "0." + threePlacesFormat.format(milliseconds);
            }
            return "< 0.001";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    private AuditTools() {
    }
}

