/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.service;

import com.suncode.plugin.scheduldedtask.audit.model.EventStatus;
import com.suncode.pwfl.audit.AuditFinder;
import com.suncode.pwfl.audit.dto.AuditDto;
import com.suncode.pwfl.audit.util.AuditCategories;
import com.suncode.pwfl.audit.util.AuditSortProperty;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class STAuditService {
    @Autowired
    private AuditFinder auditFinder;

    public CountedResult<AuditDto> getAudits(List<AuditTypes> auditTypes, Long dayOffset, int limit, EventStatus eventStatus) {
        LocalDateTime startTime = LocalDateTime.now().minusDays(dayOffset);
        LocalDateTime stopTime = LocalDateTime.now();
        CountedResult result = this.auditFinder.getAuditsByTypes(auditTypes, startTime, stopTime, Integer.valueOf(0), Integer.valueOf(limit), AuditSortProperty.AUDIT_STARTED, SortDirection.DESC);
        return this.auditFilter((CountedResult<AuditDto>)result, eventStatus);
    }

    private CountedResult<AuditDto> auditFilter(CountedResult<AuditDto> result, EventStatus eventStatus) {
        switch (eventStatus) {
            case SUCCESS: {
                List dataSuccess = result.getData().stream().filter(AuditDto::getSuccess).collect(Collectors.toList());
                return new CountedResult((long)dataSuccess.size(), dataSuccess);
            }
            case FAIL: {
                List dataFails = result.getData().stream().filter(auditDto -> auditDto.getSuccess() == false).collect(Collectors.toList());
                return new CountedResult((long)dataFails.size(), dataFails);
            }
            case ALL: {
                return result;
            }
        }
        throw new IllegalArgumentException("Parameter eventStatus: " + eventStatus.name() + "  not supported");
    }

    public List<AuditTypes> getAuditTypes(String auditTypes, String auditCategory) {
        TreeSet types = new TreeSet();
        if (StringUtils.isBlank((CharSequence)auditTypes) && StringUtils.isBlank((CharSequence)auditCategory)) {
            return Arrays.asList(AuditTypes.values());
        }
        if (StringUtils.isNotBlank((CharSequence)auditTypes)) {
            types.addAll(Stream.of(auditTypes.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(AuditTypes::valueOf).collect(Collectors.toSet()));
        }
        if (StringUtils.isNotBlank((CharSequence)auditCategory)) {
            types.addAll(Stream.of(auditCategory.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(AuditCategories::valueOf).map(AuditTypes::getByCategory).flatMap(Collection::stream).collect(Collectors.toSet()));
        }
        return new ArrayList<AuditTypes>(types);
    }
}

