/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.activity.service;

import com.suncode.plugin.scheduldedtask.activity.service.ActivityContextService;
import com.suncode.plugin.scheduldedtask.activity.service.VariableProcessingService;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
class ActivityContextServiceImpl
implements ActivityContextService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private VariableProcessingService variableProcessingService;

    ActivityContextServiceImpl() {
    }

    @Override
    public Object[] readParametersFromActivity(List<String> variableIds, String activityId, String processId) {
        ActivityContextMap activityContextMap = this.getActivityContextMap(processId, activityId);
        return variableIds.stream().filter(StringUtils::isNotBlank).map(String::trim).filter(variableId -> this.activityContextContainsVariable(activityContextMap.getVariables(), (String)variableId, activityId)).map(variableId -> activityContextMap.getVariable(variableId).getValue()).toArray();
    }

    private ActivityContextMap getActivityContextMap(String processId, String activityId) {
        Map<String, Object> context = this.getActivityContext(processId, activityId);
        Map<String, Variable> variables = this.variableProcessingService.convertContextToVariables(processId, activityId, context);
        return new ActivityContextMap(processId, activityId, variables);
    }

    private Map<String, Object> getActivityContext(String processId, String activityId) {
        return this.activityService.getActivityContext(processId, activityId);
    }

    @Override
    public Boolean activityContextContainsVariable(Map<String, Variable> variables, String variableId, String activityId) {
        Assert.isTrue((boolean)variables.containsKey(variableId), (String)("The activity with id " + activityId + " does not contain a variable with the id " + variableId));
        return true;
    }
}

