/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.google.common.collect.ListMultimap;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.activity.common.MultipleValueSupport;
import com.suncode.plugin.scheduldedtask.activity.service.VariableProcessingService;
import com.suncode.plugin.scheduldedtask.db.entities.CreatedProcesses;
import com.suncode.plugin.scheduldedtask.db.service.CreatedProcessesService;
import com.suncode.plugin.scheduldedtask.exceptions.InvalidDatasourceIDException;
import com.suncode.plugin.scheduldedtask.exceptions.TaskCanceledException;
import com.suncode.plugin.scheduldedtask.exceptions.checker.ExceptionChecker;
import com.suncode.plugin.scheduldedtask.process.ProcessInfo;
import com.suncode.plugin.scheduldedtask.summary.TaskSummary;
import com.suncode.plugin.scheduldedtask.task.logger.LoggerFormatter;
import com.suncode.plugin.scheduldedtask.tools.Converter;
import com.suncode.plugin.scheduldedtask.tools.JsonConverter;
import com.suncode.plugin.scheduldedtask.tools.PropertyInjector;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.CreateProcessResult;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ScheduledTask
public class CreateProcessWithDatasource {
    private static final String PROCESS_CREATOR = "admin";
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private CreatedProcessesService createdProcessesService;
    @Autowired
    private VariableProcessingService variableProcessingService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.create-process-with-datasource")).name("scheduledtask.create-process-with-datasource.name")).description("scheduledtask.create-process-with-datasource.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).cancelable().parameter().id("datasourceId").name("scheduledtask.create-process-with-datasource.datasourceId.name").description("scheduledtask.create-process-with-datasource.datasourceId.desc").type((Type)Types.STRING).create()).parameter().id("jsonDatasourceParameters").name("scheduledtask.create-process-with-datasource.jsonDatasourceParameters.name").description("scheduledtask.create-process-with-datasource.jsonDatasourceParameters.desc").type((Type)Types.STRING).optional().create()).parameter().id("processDefId").name("scheduledtask.create-process-with-datasource.processDefId.name").description("scheduledtask.create-process-with-datasource.processDefId.desc").type((Type)Types.STRING).create()).parameter().id("jsonMappingParameters").name("scheduledtask.create-process-with-datasource.jsonMappingParameters.name").description("scheduledtask.create-process-with-datasource.jsonMappingParameters.desc").type((Type)Types.STRING).optional().create()).parameter().id("keyOfCreatedProcesses").name("scheduledtask.create-process-with-datasource.keyOfCreatedProcesses.name").description("scheduledtask.create-process-with-datasource.keyOfCreatedProcesses.desc").type((Type)Types.STRING).create()).parameter().id("repeatCreateProcesses").name("scheduledtask.create-process-with-datasource.repeatCreateProcesses.name").description("scheduledtask.create-process-with-datasource.repeatCreateProcesses.desc").type((Type)Types.BOOLEAN).create()).parameter().id("multipleValuesSupport").name("scheduledtask.create-process-with-datasource.multipleValuesSupport.name").description("scheduledtask.create-process-with-datasource.multipleValuesSupport.desc").type((Type)Types.STRING).defaultValue((Object)"BLOCK").create();
    }

    public String execute(@Param String datasourceId, @Param String jsonDatasourceParameters, @Param String processDefId, @Param String jsonMappingParameters, @Param String keyOfCreatedProcesses, @Param Boolean repeatCreateProcesses, @Param String multipleValuesSupport, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, Logger taskLogger) {
        taskLogger.debug((Object)("Start task " + scheduledTaskInfo.getName()));
        TaskSummary taskSummary = new TaskSummary(taskLogger);
        try {
            ExceptionChecker.checkTaskCancellation(cancelationHandler);
            Package pack = this.getProcessPackage(processDefId);
            MultipleValueSupport multipleValuesSupportType = MultipleValueSupport.valueOf(multipleValuesSupport);
            List<String> keysOfPreviouslyCreatedProcesses = this.getKeysOfPreviouslyCreatedProcesses(scheduledTaskInfo);
            List<Map<String, Object>> data = this.getDataFromDatasource(datasourceId, jsonDatasourceParameters, scheduledTaskInfo);
            ExceptionChecker.checkTaskCancellation(cancelationHandler);
            List<ProcessInfo> createdProcesesInfo = this.createProcessesByDatasourceData(pack, processDefId, jsonMappingParameters, repeatCreateProcesses, keyOfCreatedProcesses, keysOfPreviouslyCreatedProcesses, data, multipleValuesSupportType, cancelationHandler, taskSummary);
            createdProcesesInfo.forEach(processInfo -> this.createdProcessesService.saveOrUpdateCreatedProcesses(repeatCreateProcesses, scheduledTaskInfo, (ProcessInfo)processInfo));
        }
        catch (TaskCanceledException cte) {
            taskLogger.debug((Object)"Cancel By user");
            String string = "Cancel By user. " + taskSummary.summary();
            return string;
        }
        catch (Exception e) {
            taskLogger.error((Object)"ERROR", (Throwable)e);
            throw e;
        }
        finally {
            taskLogger.debug((Object)taskSummary.summary());
            taskLogger.debug((Object)("End task: " + scheduledTaskInfo.getName()));
        }
        return taskSummary.summary();
    }

    private List<ProcessInfo> createProcessesByDatasourceData(Package pack, String processDefId, String jsonMappingParameters, boolean repeatCreateProcesses, String keyOfCreatedProcesses, List<String> keysOfPreviouslyCreatedProcesses, List<Map<String, Object>> datasourceData, MultipleValueSupport multipleValuesSupportType, CancelationHandler cancelationHandler, TaskSummary taskSummary) {
        Map<String, List<Map<String, Object>>> groupedDataByProcessKey = this.groupBy(datasourceData, this.readKeysOfPreviouslyCreatedProcesses(keyOfCreatedProcesses));
        taskSummary.setTotal(groupedDataByProcessKey.size());
        return this.createNewProcesses(pack, processDefId, jsonMappingParameters, repeatCreateProcesses, keysOfPreviouslyCreatedProcesses, multipleValuesSupportType, cancelationHandler, taskSummary, groupedDataByProcessKey);
    }

    private String[] readKeysOfPreviouslyCreatedProcesses(String keyOfCreatedProcesses) {
        if (StringUtils.isBlank((CharSequence)keyOfCreatedProcesses)) {
            throw new IllegalArgumentException("Parametr keyOfCreatedProcesses is blank");
        }
        return keyOfCreatedProcesses.split(",");
    }

    private List<ProcessInfo> createNewProcesses(Package pack, String processDefId, String jsonMappingParameters, boolean repeatCreateProcesses, List<String> keysOfPreviouslyCreatedProcesses, MultipleValueSupport multipleValuesSupportType, CancelationHandler cancelationHandler, TaskSummary taskSummary, Map<String, List<Map<String, Object>>> groupedDataByProcessKey) {
        LinkedList<ProcessInfo> createdProcesesInfo = new LinkedList<ProcessInfo>();
        groupedDataByProcessKey.forEach((groupKey, dataToProcess) -> {
            ExceptionChecker.checkTaskCancellation(cancelationHandler);
            if (repeatCreateProcesses || !keysOfPreviouslyCreatedProcesses.contains(groupKey)) {
                ProcessInfo processInfo = ProcessInfo.builder().success(false).key((String)groupKey).build();
                try {
                    CreateProcessResult createProcessResult = this.createNewProcess(processDefId, jsonMappingParameters, taskSummary, pack, multipleValuesSupportType, (List<Map<String, Object>>)dataToProcess);
                    keysOfPreviouslyCreatedProcesses.add((String)groupKey);
                    processInfo.setSuccess(true);
                    processInfo.setProcessId(createProcessResult.getProcessId());
                    processInfo.setTime(DateTime.now());
                }
                catch (Exception e) {
                    taskSummary.incrementErrors();
                    taskSummary.logError("Error while creating process for key: " + groupKey, e);
                    processInfo.setError(e);
                    processInfo.setTime(DateTime.now());
                }
                finally {
                    createdProcesesInfo.add(processInfo);
                }
            }
        });
        return createdProcesesInfo;
    }

    private CreateProcessResult createNewProcess(String processDefId, String jsonMappingParameters, TaskSummary taskSummary, Package pack, MultipleValueSupport multipleValuesSupportType, List<Map<String, Object>> dataToProcess) {
        HashMap<String, String> mappingParametersIdToVariableId = StringUtils.isBlank((CharSequence)jsonMappingParameters) ? new HashMap() : JsonConverter.convertJsonToMap(jsonMappingParameters);
        ProcessBuilderDefinition processBuilderDefinition = this.buildProcessDefinition(pack, processDefId, dataToProcess, mappingParametersIdToVariableId, multipleValuesSupportType);
        CreateProcessResult createProcessResult = this.processService.createProcessWithResult(processBuilderDefinition);
        taskSummary.incrementSuccess();
        taskSummary.logDebug("Created processId:\t" + createProcessResult.getProcessId() + " , activityId:\t" + createProcessResult.getActivityId());
        taskSummary.logDebug("Process context:\t" + LoggerFormatter.toStringContext(processBuilderDefinition.getVariables()));
        return createProcessResult;
    }

    private List<String> getKeysOfPreviouslyCreatedProcesses(ScheduledTaskInstanceInfo scheduledTaskInfo) {
        return this.createdProcessesService.getAllCreatedProcessesByTaskId(scheduledTaskInfo.getId()).stream().map(CreatedProcesses::getKey).collect(Collectors.toList());
    }

    private Package getProcessPackage(String processDefId) {
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
        if (pack == null) {
            throw new IllegalArgumentException("No process package found for processDefId:" + processDefId);
        }
        return pack;
    }

    private ProcessBuilderDefinition buildProcessDefinition(Package pack, String processDefId, List<Map<String, Object>> dataToProcess, Map<String, String> mappingParametersIdToVariableId, MultipleValueSupport multipleValueSupport) {
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId(pack.getId());
        definition.setProcessDefId(processDefId);
        definition.setCreator(PROCESS_CREATOR);
        definition.setAutoStart(true);
        if (!mappingParametersIdToVariableId.isEmpty()) {
            definition.setVariables(this.createVariables(pack, processDefId, dataToProcess, mappingParametersIdToVariableId, multipleValueSupport));
        } else {
            definition.setVariables(new HashMap());
        }
        return definition;
    }

    private Map<String, Object> createVariables(Package pack, String processDefId, List<Map<String, Object>> dataFromDatasource, Map<String, String> mappingParametersIdToVariableId, MultipleValueSupport multipleValueSupport) {
        HashMap<String, Object> variablesToProcess = new HashMap<String, Object>();
        ListMultimap<String, Object> multimapDataFromDatasource = Converter.convertMapListToMultimap(dataFromDatasource);
        Map<String, Variable> variables = this.variableProcessingService.getProcessVariables(pack, processDefId, null, new HashMap<String, Object>(), false);
        mappingParametersIdToVariableId.forEach((parameterId, variableId) -> {
            if (!multimapDataFromDatasource.containsKey(parameterId)) {
                throw new IllegalArgumentException("The datasource output parameter with id '" + parameterId + "' does not exist. Available parameters: " + String.join((CharSequence)", ", multimapDataFromDatasource.keySet()));
            }
            List dataList = multimapDataFromDatasource.get(parameterId);
            if (!variables.containsKey(variableId)) {
                throw new IllegalArgumentException("The variable with id '" + variableId + "' does not exist. Available variables: " + String.join((CharSequence)", ", variables.keySet()));
            }
            Variable variable = (Variable)variables.get(variableId);
            Object value = this.variableProcessingService.readNewValue(multipleValueSupport, dataList, variable);
            variable.setValue(value);
            variablesToProcess.put((String)variableId, variable.getValueAsBasicType());
        });
        return variablesToProcess;
    }

    private Map<String, List<Map<String, Object>>> groupBy(List<Map<String, Object>> datas, String[] keyOfCreatedProcesses) {
        return datas.stream().collect(Collectors.groupingBy(data -> this.generateProcessKey((Map<String, Object>)data, keyOfCreatedProcesses)));
    }

    private String generateProcessKey(Map<String, Object> stringObjectMap, String[] parameterIds) {
        String KEY_SEPARATOR = ";;";
        StringBuilder sb = new StringBuilder("");
        for (String parametrId : parameterIds) {
            if (!stringObjectMap.containsKey(parametrId)) {
                throw new IllegalArgumentException("The datasource output parameter with id '" + parametrId + "' does not exist. Available parameters: " + String.join((CharSequence)", ", stringObjectMap.keySet()));
            }
            String value = stringObjectMap.get(parametrId.trim()).toString();
            sb.append(value).append(";;");
        }
        return sb.toString();
    }

    private List<Map<String, Object>> getDataFromDatasource(String datasourceId, String jsonParameters, ScheduledTaskInstanceInfo scheduledTaskInfo) {
        DataSourceInstance dataSource = this.dataSourceService.getDataSource(datasourceId);
        if (dataSource == null) {
            throw new InvalidDatasourceIDException("Incorrect datasource id: " + datasourceId);
        }
        Map<String, String> values = this.getParameters(jsonParameters, scheduledTaskInfo);
        return dataSource.execute(values, null).getData();
    }

    private Map<String, String> getParameters(String json, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        return JsonConverter.convertJsonToMap(json).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.injectProperty((String)e.getValue(), scheduledTaskInstanceInfo)));
    }

    private String injectProperty(String property, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        String replacedString = PropertyInjector.injectLastSuccessfulExecutionTime(property, scheduledTaskInstanceInfo);
        return PropertyInjector.injectCurrentTime(replacedString);
    }
}

