/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooser;
import com.plusmpm.CUF.database.queryDataChooser.QueryDataChooserManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.suncode.plugin.scheduldedtask.tools.CreatorSettings;
import com.suncode.plugin.scheduldedtask.tools.ExternalDBIntegration;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Deprecated
@ScheduledTask
public class CreateNewProcessWithDataFromDB {
    public Logger log = Logger.getLogger(CreateNewProcessWithDataFromDB.class);
    public Logger taskLog = Logger.getLogger(CreateNewProcessWithDataFromDB.class);
    private boolean useResultTable;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.create-new-process-with-data-from-db")).name("scheduledtask.create-new-process-with-data-from-db.name")).description("scheduledtask.create-new-process-with-data-from-db.desc")).cancelable().parameter().id("external-db-config-name").name("scheduledtask.create-new-process-with-data-from-db.param.external-db-config-name.name").description("scheduledtask.create-new-process-with-data-from-db.param.external-db-config-name.desc").type((Type)Types.STRING).optional().create()).parameter().id("quary-name").name("scheduledtask.create-new-process-with-data-from-db.param.quary-name.name").description("scheduledtask.create-new-process-with-data-from-db.param.quary-name.desc").type((Type)Types.STRING).create()).parameter().id("packgae-id").name("scheduledtask.create-new-process-with-data-from-db.param.packgae-id.name").description("scheduledtask.create-new-process-with-data-from-db.param.packgae-id.desc").type((Type)Types.STRING).create()).parameter().id("process-def-id").name("scheduledtask.create-new-process-with-data-from-db.param.process-def-id.name").description("scheduledtask.create-new-process-with-data-from-db.param.process-def-id.desc").type((Type)Types.STRING).create()).parameter().id("table-name-for-result").name("scheduledtask.create-new-process-with-data-from-db.param.table-name-for-result.name").description("scheduledtask.create-new-process-with-data-from-db.param.table-name-for-result.desc").type((Type)Types.STRING).optional().create()).parameter().id("primal-key").name("scheduledtask.create-new-process-with-data-from-db.param.primal-key.name").description("scheduledtask.create-new-process-with-data-from-db.param.primal-key.desc").type((Type)Types.STRING).optional().create()).parameter().id("separator").name("scheduledtask.create-new-process-with-data-from-db.param.separator.name").description("scheduledtask.create-new-process-with-data-from-db.param.separator.desc").type((Type)Types.STRING).optional().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@Param(value="external-db-config-name") String externalDBConfigName, @Param(value="quary-name") String queryId, @Param(value="packgae-id") String packageId, @Param(value="process-def-id") String processDefId, @Param(value="table-name-for-result") String tableNameForResult, @Param(value="primal-key") String keyTable, @Param(value="separator") String separator, Logger logger) {
        this.taskLog = logger;
        this.useResultTable = false;
        if (StringUtils.isNotBlank((CharSequence)keyTable) && StringUtils.isNotBlank((CharSequence)tableNameForResult)) {
            this.useResultTable = true;
            if (StringUtils.isBlank((CharSequence)separator)) {
                separator = ",";
            }
        }
        Connection conInternal = null;
        try {
            if (this.useResultTable) {
                conInternal = this.createResultTable(tableNameForResult);
            }
            String query = "";
            List listOfQueries = QueryDataChooserManager.getQueryDataChooserForName((String)queryId);
            if (listOfQueries != null && listOfQueries.size() > 0) {
                query = ((QueryDataChooser)listOfQueries.get(0)).getQuery();
            } else {
                this.log.debug((Object)("No finded  queryId:" + queryId + " in pm_querydatachooser"));
                this.taskLog.info((Object)("No finded  queryId:" + queryId + " in pm_querydatachooser"));
            }
            List<HashMap<String, String>> results = this.executeQueryForExternalDB(externalDBConfigName, query);
            if (!results.isEmpty()) {
                List<ProcessBuilderDefinition> errorCreateProcess = this.createNewProcesses(packageId, processDefId, tableNameForResult, keyTable, separator, conInternal, results);
                this.log.debug((Object)"End scheduled task");
                this.log.debug((Object)("Can not created number of new process:\t" + errorCreateProcess.size()));
                this.taskLog.info((Object)"End scheduled task");
                this.taskLog.info((Object)("Can not created number of new process:\t" + errorCreateProcess.size()));
                this.taskLog.info((Object)this.showProcessDefinitionInfo(errorCreateProcess));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
            this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
            e.printStackTrace();
            this.taskLog.error((Object)e);
        }
        finally {
            this.log.debug((Object)"Close conections");
            if (conInternal != null) {
                try {
                    conInternal.close();
                }
                catch (SQLException e) {
                    this.log.error((Object)e);
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    this.taskLog.error((Object)e);
                    this.taskLog.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                }
            }
        }
    }

    private List<ProcessBuilderDefinition> createNewProcesses(String packageId, String processDefId, String tableNameForResult, String keyTable, String separator, Connection conInternal, List<HashMap<String, String>> results) {
        this.log.debug((Object)"Prepare to create new proces");
        this.taskLog.debug((Object)"Prepare to create new proces");
        CreatorSettings creatorSet = new CreatorSettings();
        String creator = creatorSet.getUser();
        String creatorPassword = creatorSet.getPassword();
        ProcessService processService = ServiceFactory.getProcessService();
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId(packageId);
        definition.setCreator(creator);
        definition.setCreatorPassword(creatorPassword);
        definition.setProcessDefId(processDefId);
        this.log.debug((Object)("PackageId:\t" + packageId));
        this.log.debug((Object)("ProcessDefId:\t" + processDefId));
        this.log.debug((Object)("User:\t" + creator));
        this.log.debug((Object)"Password:\t************");
        List listProcessIdx = processService.getProcessIndexes(processDefId);
        HashMap<String, ProcessIndex> idsProcessIndex = new HashMap<String, ProcessIndex>();
        for (ProcessIndex processIndex : listProcessIdx) {
            idsProcessIndex.put(processIndex.getId(), processIndex);
        }
        ArrayList<ProcessBuilderDefinition> errorCreateProcess = new ArrayList<ProcessBuilderDefinition>();
        int numberOfResult = 1;
        for (HashMap<String, String> dataFromDB : results) {
            this.log.debug((Object)("number result" + numberOfResult + "/" + results.size()));
            this.taskLog.debug((Object)("number result" + numberOfResult + "/" + results.size()));
            Boolean existNewProcess = false;
            String keyDataValue = "";
            if (this.useResultTable) {
                keyDataValue = this.prepareKeyDataValue(dataFromDB, keyTable, separator);
                this.addToTableResult(keyDataValue, conInternal, tableNameForResult);
                existNewProcess = this.checkItUse(keyDataValue, conInternal, tableNameForResult);
                this.log.debug((Object)("check 'was process created?' key: " + keyDataValue + " answer:  " + existNewProcess));
                this.taskLog.debug((Object)("check 'was process created?' key: " + keyDataValue + " answer:  " + existNewProcess));
            }
            if (!existNewProcess.booleanValue()) {
                this.log.debug((Object)"If answer was 'false'");
                Map<Object, Object> contextVar = new HashMap();
                contextVar = this.convertVariable(idsProcessIndex, dataFromDB);
                definition.setVariables(contextVar);
                this.log.debug((Object)"Context value for new process");
                this.log.debug((Object)("key:\t" + new ArrayList<Map.Entry<Object, Object>>(contextVar.entrySet())));
                this.log.debug((Object)("value:\t" + new ArrayList<Object>(contextVar.values())));
                try {
                    this.log.debug((Object)"create new process");
                    this.taskLog.debug((Object)"create new process");
                    String processId = processService.createProcess(definition);
                    this.log.debug((Object)("success:\t" + processId));
                    this.taskLog.debug((Object)("success:\t" + processId));
                    if (this.useResultTable) {
                        this.updateToTableResult(keyDataValue, conInternal, tableNameForResult, processId);
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    this.log.debug((Object)"Error created new process");
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    this.taskLog.debug((Object)"Error created new process");
                    this.taskLog.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    errorCreateProcess.add(new ProcessBuilderDefinition(definition.getProcessDefId(), definition.getCreator(), definition.getCreatorPassword(), definition.getPackageId(), definition.getVariables()));
                }
            } else {
                this.log.debug((Object)"Skip data");
            }
            ++numberOfResult;
        }
        return errorCreateProcess;
    }

    private List<HashMap<String, String>> executeQueryForExternalDB(String externalDBConfigName, String query) {
        Connection conExternal;
        this.log.debug((Object)"Get Data From external DB");
        Statement pStatement = null;
        if (StringUtils.isNotBlank((CharSequence)externalDBConfigName)) {
            ExternalDBIntegration extDB = new ExternalDBIntegration();
            conExternal = extDB.GetExternalDBConnection(externalDBConfigName);
        } else {
            try {
                conExternal = InternalDataBase.connect();
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        try {
            this.log.debug((Object)("Using query\t" + query));
            this.taskLog.debug((Object)("Using query\t" + query));
            pStatement = conExternal.prepareStatement(query);
            ResultSet rs = pStatement.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            while (rs.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String oneValue = rs.getString(columnName);
                    columnName = columnName.toLowerCase();
                    if (oneValue == null) {
                        this.log.debug((Object)"change null to emptyString ('')");
                        oneValue = "";
                    }
                    oneRow.put(columnName, oneValue);
                }
                results.add(oneRow);
            }
            this.log.debug((Object)("Get number of result:\t" + results.size()));
        }
        catch (SQLException e) {
            this.log.error((Object)e);
            this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.log.debug((Object)"Close conections");
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    this.log.error((Object)e);
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (conExternal != null) {
                try {
                    conExternal.close();
                }
                catch (SQLException e) {
                    this.log.error((Object)e);
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        return results;
    }

    private Connection createResultTable(String tableNameForResult) throws NamingException, SQLException, CUFException {
        Connection conInternal = InternalDataBase.connect();
        if (conInternal == null || conInternal.isClosed()) {
            throw new CUFException("Brak polaczania z wewnetrzna baza danych");
        }
        String dataBaseName = conInternal.getMetaData().getDatabaseProductName();
        this.executeCREATE_QUERY(dataBaseName, tableNameForResult, conInternal);
        return conInternal;
    }

    private void executeCREATE_QUERY(String databaseName, String tableName, Connection conInternal) throws SQLException {
        if (databaseName.contains("Microsoft")) {
            String createTable = " CREATE TABLE " + tableName + " ( id decimal(19,0) IDENTITY(1,1) PRIMARY KEY, key_data VARCHAR(4000) UNIQUE,  execute_process tinyint NOT NULL,  process_name VARCHAR(1024) );  ";
            this.executeQuery(createTable, conInternal);
        } else if (databaseName.contains("Oracle")) {
            String createTable = " CREATE TABLE " + tableName + " ( id NUMBER(19) PRIMARY KEY NOT NULL, key_data VARCHAR(4000) UNIQUE,  execute_process NUMBER(1) NOT NULL,  process_name VARCHAR(1024)  ) ";
            this.executeQuery(createTable, conInternal);
            String createSeq = " CREATE SEQUENCE seq_" + tableName + " START WITH     1 INCREMENT BY   1 NOCACHE  NOCYCLE ";
            this.executeQuery(createSeq, conInternal);
            String creteTrigger = " CREATE TRIGGER trig_" + tableName + " BEFORE INSERT ON " + tableName + " FOR EACH ROW BEGIN  SELECT seq_" + tableName + ".NEXTVAL  INTO   :new.id  FROM   dual; END; ";
            this.executeQuery(creteTrigger, conInternal);
        } else {
            String createTable = " CREATE TABLE IF NOT EXISTS " + tableName + " ( id BIGSERIAL PRIMARY KEY, key_data VARCHAR(8000) UNIQUE,  execute_process BOOLEAN,  process_name VARCHAR(1024) );  ";
            this.executeQuery(createTable, conInternal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(String query, Connection conInternal) throws SQLException {
        try (Statement statement = conInternal.createStatement();){
            statement.execute(query);
            this.log.debug((Object)("execute query\t" + query));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToTableResult(String keyDataValue, Connection conn, String tableName) {
        this.log.debug((Object)("Add new row in Table result:\t" + tableName));
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append(" INSERT INTO ").append(tableName).append(" ( key_data , execute_process ) VALUES ( ?, ? )");
        this.log.debug((Object)"INSERT Query");
        this.log.debug((Object)sbQuery.toString());
        PreparedStatement pStatement = null;
        try {
            pStatement = conn.prepareStatement(sbQuery.toString());
            pStatement.setString(1, keyDataValue);
            pStatement.setBoolean(2, false);
            pStatement.execute();
            this.log.debug((Object)"Add success");
        }
        catch (SQLException e) {
            this.log.debug((Object)"This row is existing");
            this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
        }
        finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToTableResult(String keyDataValue, Connection conn, String tableName, String processName) {
        this.log.debug((Object)("Update row in Table Results:\t" + tableName));
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append(" UPDATE ").append(tableName).append(" SET execute_process = ?").append(" , process_name = ? WHERE key_data = ?");
        this.log.debug((Object)"UPDATE Query");
        this.log.debug((Object)sbQuery.toString());
        PreparedStatement pStatement = null;
        try {
            pStatement = conn.prepareStatement(sbQuery.toString());
            pStatement.setBoolean(1, true);
            pStatement.setString(2, processName);
            pStatement.setString(3, keyDataValue);
            pStatement.execute();
            this.log.debug((Object)"UPDATE success");
        }
        catch (SQLException e) {
            this.log.debug((Object)"UPDATE ERROR");
            this.log.error((Object)e);
            this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
        }
        finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean checkItUse(String keyDataValue, Connection conn, String tableName) {
        boolean result = false;
        this.log.debug((Object)("Check existing \t" + keyDataValue + "in key_data column and status of execute_process column "));
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append(" SELECT  execute_process FROM ").append(tableName).append(" WHERE key_data = '").append(keyDataValue).append("' ");
        this.log.debug((Object)"Check Query");
        this.log.debug((Object)sbQuery.toString());
        PreparedStatement pStatement = null;
        try {
            pStatement = conn.prepareStatement(sbQuery.toString());
            ResultSet resultSet = pStatement.executeQuery();
            resultSet.next();
            result = resultSet.getBoolean("execute_process");
            this.log.debug((Object)"Check success");
        }
        catch (SQLException e) {
            this.log.debug((Object)"Check error");
            this.log.error((Object)e);
            this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
            result = false;
        }
        finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    this.log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        this.log.debug((Object)("Status:\t" + result));
        return result;
    }

    private String prepareKeyDataValue(HashMap<String, String> dataFromDB, String keyTable, String separator) {
        this.log.debug((Object)"prepare key value for Table results");
        String[] keys = keyTable.split(separator);
        StringBuilder sb = new StringBuilder();
        for (String stringKey : keys) {
            if (!dataFromDB.containsKey(stringKey)) continue;
            sb.append(dataFromDB.get(stringKey)).append(separator);
        }
        String keyDataValue = sb.toString();
        this.log.debug((Object)("separator:\t" + separator));
        this.log.debug((Object)("key Foramt:\t" + keyTable));
        this.log.debug((Object)("key value:\t" + keyDataValue));
        return keyDataValue;
    }

    private Map<String, Object> convertVariable(Map<String, ProcessIndex> idsProcessIndex, Map<String, String> hmResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : hmResult.keySet()) {
            if (!idsProcessIndex.containsKey(key) || hmResult.get(key) == null) continue;
            try {
                switch (idsProcessIndex.get(key).getType()) {
                    case BOOLEAN: {
                        if (hmResult.get(key).equalsIgnoreCase("t")) {
                            result.put(key, true);
                            break;
                        }
                        if (hmResult.get(key).equalsIgnoreCase("f")) {
                            result.put(key, false);
                            break;
                        }
                        result.put(key, Boolean.parseBoolean(hmResult.get(key)));
                        break;
                    }
                    case DATE: {
                        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                        result.put(key, DateTime.parse((String)hmResult.get(key), (DateTimeFormatter)fmt).toDate());
                        break;
                    }
                    case DOUBLE: {
                        result.put(key, Double.parseDouble(hmResult.get(key)));
                        break;
                    }
                    case INTEGER: {
                        result.put(key, Long.parseLong(hmResult.get(key)));
                        break;
                    }
                    case STRING: {
                        result.put(key, hmResult.get(key));
                        break;
                    }
                    default: {
                        this.log.debug((Object)("Nieobs\u0142ugiwany typ zmiennej" + key));
                        this.taskLog.info((Object)("Nieobs\u0142ugiwany typ zmiennej " + key));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.taskLog.info((Object)e.getLocalizedMessage());
                this.log.debug((Object)e.getLocalizedMessage());
                System.out.println(e.getClass().getName() + " : " + e.getMessage());
            }
        }
        return result;
    }

    private String showProcessDefinitionInfo(List<ProcessBuilderDefinition> errorCreateProcess) {
        StringBuilder sb = new StringBuilder("");
        if (!errorCreateProcess.isEmpty()) {
            int procesNumber = 0;
            for (ProcessBuilderDefinition processBuilderDefinition : errorCreateProcess) {
                sb.append("ProcessNumber: ").append(procesNumber).append(":").append("\n");
                Map var = processBuilderDefinition.getVariables();
                sb.append("\tid\t->\tvalue\n");
                for (String keyMap : new ArrayList(var.keySet())) {
                    sb.append("\t").append(keyMap).append("\t->\t").append(var.get(keyMap)).append("\n");
                }
                ++procesNumber;
            }
        }
        return sb.toString();
    }
}

