/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.audit.email.EmailSenderService;
import com.suncode.plugin.scheduldedtask.audit.excel.builder.ExcelBuilder;
import com.suncode.plugin.scheduldedtask.audit.excel.column.ColumnType;
import com.suncode.plugin.scheduldedtask.audit.model.EventStatus;
import com.suncode.plugin.scheduldedtask.audit.recipient.RecipientService;
import com.suncode.plugin.scheduldedtask.audit.service.STAuditService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.dto.AuditDto;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.TempFile;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class AuditReportTask {
    private static final int MAX_EXCEL_ROWS_LIMIT = 1048575;
    @Autowired
    private STAuditService auditService;
    @Autowired
    private EmailSenderService emailSenderService;
    @Autowired
    private RecipientService recipientService;
    @Autowired
    private UserService userService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.audit-report.task")).name("scheduledtask.audit-report.name")).description("scheduledtask.audit-report.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).parameter().id("recipientType").name("scheduledtask.audit-report.recipientType.name").description("scheduledtask.audit-report.recipientType.desc").type((Type)Types.STRING).create()).parameter().id("recipient").name("scheduledtask.audit-report.recipient.name").description("scheduledtask.audit-report.recipient.desc").type((Type)Types.STRING).create()).parameter().id("emailSubject").name("scheduledtask.audit-report.emailSubject.name").description("scheduledtask.audit-report.emailSubject.desc").type((Type)Types.STRING).create()).parameter().id("emailTemplatePath").name("scheduledtask.audit-report.emailTemplatePath.name").description("scheduledtask.audit-report.emailTemplatePath.desc").type((Type)Types.STRING).create()).parameter().id("sendAsOne").name("scheduledtask.audit-report.sendAsOne.name").description("scheduledtask.audit-report.sendAsOne.desc").type((Type)Types.BOOLEAN).create()).parameter().id("auditCategory").name("scheduledtask.audit-report.auditCategory.name").description("scheduledtask.audit-report.auditCategory.desc").type((Type)Types.STRING).optional().create()).parameter().id("auditTypes").name("scheduledtask.audit-report.auditTypes.name").description("scheduledtask.audit-report.auditTypes.desc").type((Type)Types.STRING).optional().create()).parameter().id("auditCategory").name("scheduledtask.audit-report.auditCategory.name").description("scheduledtask.audit-report.auditCategory.desc").type((Type)Types.STRING).optional().create()).parameter().id("eventStatusParam").name("scheduledtask.audit-report.eventStatusParam.name").description("scheduledtask.audit-report.eventStatusParam.desc").type((Type)Types.STRING).defaultValue((Object)"ALl").create()).parameter().id("columnTypes").name("scheduledtask.audit-report.columnTypes.name").description("scheduledtask.audit-report.columnTypes.desc").type((Type)Types.STRING).create()).parameter().id("dayOffset").name("scheduledtask.audit-report.dayOffset.name").description("scheduledtask.audit-report.dayOffset.desc").type((Type)Types.INTEGER).create();
    }

    public String execute(@Param String recipientType, @Param String recipient, @Param Long dayOffset, @Param String auditTypes, @Param String auditCategory, @Param String columnTypes, @Param String emailSubject, @Param String emailTemplatePath, @Param Boolean sendAsOne, @Param String eventStatusParam, ScheduledTaskInstanceInfo scheduledTaskInfo, Logger taskLog) {
        TempFile tempFile = new TempFile();
        try {
            taskLog.debug((Object)("Start task: " + scheduledTaskInfo.getName()));
            this.recipientService.validRecipients(taskLog, recipient, recipientType);
            List<String> recipients = this.recipientService.getRecipientsEmails(recipient, recipientType);
            EventStatus eventStatus = EventStatus.valueOf(eventStatusParam.trim().toUpperCase());
            taskLog.debug((Object)"Finding audits");
            List<AuditTypes> audits = this.auditService.getAuditTypes(auditTypes, auditCategory);
            CountedResult<AuditDto> result = this.auditService.getAudits(audits, dayOffset, 1048575, eventStatus);
            taskLog.debug((Object)("Found audits: " + result.getTotal()));
            taskLog.debug((Object)("Create temporary excel file: " + tempFile.getFile().getAbsolutePath()));
            ExcelBuilder excelBuilder = new ExcelBuilder(this.userService);
            excelBuilder.buildAuditReport(result.getData(), this.getColumnTypes(columnTypes), tempFile.getFile());
            taskLog.debug((Object)("Send email to: " + recipients));
            String log = this.emailSenderService.sendAuditReport(recipients, emailSubject, emailTemplatePath, tempFile.getFile().getAbsolutePath(), sendAsOne);
            taskLog.debug((Object)log);
            String string = "Success send email. Found " + result.getTotal() + " audits";
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            tempFile.delete();
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
        }
    }

    private List<ColumnType> getColumnTypes(String columns) {
        return Stream.of(columns.split(",")).filter(StringUtils::isNotBlank).map(ColumnType::valueOf).collect(Collectors.toList());
    }
}

