/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.task;

import com.suncode.plugin.scheduldedtask.Categories;
import com.suncode.plugin.scheduldedtask.activity.common.AcceptActivityConfig;
import com.suncode.plugin.scheduldedtask.activity.common.MultipleValueSupport;
import com.suncode.plugin.scheduldedtask.activity.service.AcceptActivityService;
import com.suncode.plugin.scheduldedtask.exceptions.TaskCanceledException;
import com.suncode.plugin.scheduldedtask.exceptions.checker.ExceptionChecker;
import com.suncode.plugin.scheduldedtask.summary.TaskSummary;
import com.suncode.plugin.scheduldedtask.tools.JsonConverter;
import com.suncode.plugin.scheduldedtask.tools.PropertyInjector;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@ScheduledTask
public class AcceptActivityWithDataSource {
    @Autowired
    private AcceptActivityService acceptActivityService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ActivityService activityService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("scheduledtask.accept-activity-with-data-source")).name("scheduledtask.accept-activity-with-data-source.name")).description("scheduledtask.accept-activity-with-data-source.desc")).category(new Category[]{Categories.PLUS_SCHEDULED_TASK})).cancelable().parameter().id("dsName").name("scheduledtask.accept-activity-with-data-source.dsName.name").description("scheduledtask.accept-activity-with-data-source.dsName.desc").type((Type)Types.STRING).create()).parameter().id("params").name("scheduledtask.accept-activity-with-data-source.params.name").description("scheduledtask.accept-activity-with-data-source.params.desc").type((Type)Types.STRING).create()).parameter().id("userName").name("scheduledtask.accept-activity-with-data-source.userName.name").description("scheduledtask.accept-activity-with-data-source.userName.desc").type((Type)Types.STRING).optional().create()).parameter().id("processDefId").name("scheduledtask.accept-activity-with-data-source.processDefId.name").description("scheduledtask.accept-activity-with-data-source.processDefId.desc").type((Type)Types.STRING).create()).parameter().id("activityDefId").name("scheduledtask.accept-activity-with-data-source.activityDefId.name").description("scheduledtask.accept-activity-with-data-source.activityDefId.desc").type((Type)Types.STRING).create()).parameter().id("actionName").name("scheduledtask.accept-activity-with-data-source.actionName.name").description("scheduledtask.accept-activity-with-data-source.actionName.desc").type((Type)Types.STRING).create()).parameter().id("saveDataToActivity").name("scheduledtask.accept-activity-with-data-source.saveDataToActivity.name").description("scheduledtask.accept-activity-with-data-source.saveDataToActivity.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("multipleValueHandling").name("scheduledtask.accept-activity-with-data-source.multipleValueHandling.name").description("scheduledtask.accept-activity-with-data-source.multipleValueHandling.desc").type((Type)Types.STRING).defaultValue((Object)"BLOCK").create()).parameter().id("overwriteArray").name("scheduledtask.accept-activity-with-data-source.overwriteArray.name").description("scheduledtask.accept-activity-with-data-source.overwriteArray.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("invokeValidators").name("scheduledtask.accept-activity-with-data-source.invokeValidators.name").description("scheduledtask.accept-activity-with-data-source.invokeValidators.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create();
    }

    public String execute(@Param String dsName, @Param String params, @Param String userName, @Param String processDefId, @Param String activityDefId, @Param String actionName, @Param String multipleValueHandling, @Param Boolean saveDataToActivity, @Param Boolean overwriteArray, @Param Boolean invokeValidators, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, Logger taskLog) {
        taskLog.debug((Object)("Start task: " + scheduledTaskInfo.getName()));
        TaskSummary taskSummary = new TaskSummary(taskLog);
        try {
            this.assertParameters(dsName, params, processDefId, activityDefId, multipleValueHandling);
            List<Activity> activities = this.acceptActivityService.getOpenActivities(userName, processDefId, activityDefId);
            taskSummary.setTotal(activities.size());
            taskLog.debug((Object)("Found " + activities.size() + " activities"));
            activities.forEach(activity -> {
                ExceptionChecker.checkTaskCancellation(cancelationHandler);
                this.acceptActivityByDataSource(dsName, params, actionName, multipleValueHandling, saveDataToActivity, overwriteArray, invokeValidators, taskSummary, (Activity)activity, scheduledTaskInfo);
            });
        }
        catch (TaskCanceledException cte) {
            taskLog.debug((Object)"Cancel By user");
            String string = "Cancel By user. " + taskSummary.summary();
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)"ERROR:", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)taskSummary.summary());
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
        }
        return taskSummary.summary();
    }

    private void assertParameters(String dsName, String params, String processDefId, String activityDefId, String multipleValueHandling) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dsName), (String)"The parameter dsName cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)params), (String)"The parameter params cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)processDefId), (String)"The parameter processDefId cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)activityDefId), (String)"The parameter activityDefId cannot be empty");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)multipleValueHandling), (String)"The parameter multipleValueHandling cannot be empty");
    }

    private void acceptActivityByDataSource(String dsName, String params, String actionName, String multipleValueHandling, Boolean saveDataToActivity, Boolean overwriteArray, Boolean invokeValidators, TaskSummary taskSummary, Activity activity, ScheduledTaskInstanceInfo scheduledTaskInfo) {
        String activityId = activity.getActivityId();
        String processId = activity.getProcessId();
        try {
            Map<String, String> paramsMap = JsonConverter.convertJsonToMap(params);
            Map activityContext = this.activityService.getActivityContext(processId, activityId);
            paramsMap.replaceAll((key, value) -> value.startsWith("@") ? activityContext.get(value.substring(1)).toString() : this.injectProperty((String)value, scheduledTaskInfo));
            DataSourceInstance dataSource = this.dataSourceService.getDataSource(dsName);
            List data = dataSource.execute(paramsMap, null).getData();
            taskSummary.logDebug(data.size() + " results have been returned from database for the task with id " + activityId);
            if (!data.isEmpty()) {
                AcceptActivityConfig acceptActivityConfig = AcceptActivityConfig.builder().actionName(actionName).activityId(activityId).multipleValueSupport(MultipleValueSupport.valueOf(multipleValueHandling.toUpperCase())).newValues(data).overwriteArray(overwriteArray).processId(processId).saveDataToActivity(saveDataToActivity).ignoreValidators(invokeValidators == false).build();
                this.acceptActivityService.acceptActivityWithData(acceptActivityConfig);
                taskSummary.incrementSuccess();
                taskSummary.logDebug("Activity with id " + activityId + " accepted");
            }
        }
        catch (Exception e) {
            taskSummary.incrementErrors();
            taskSummary.logError("Error with acceptance activity by id: " + activityId, e);
        }
    }

    private String injectProperty(String property, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        String replacedString = PropertyInjector.injectLastSuccessfulExecutionTime(property, scheduledTaskInstanceInfo);
        return PropertyInjector.injectCurrentTime(replacedString);
    }
}

