/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.service;

import com.suncode.plugin.scheduldedtask.service.HolidaysService;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HolidaysServiceImpl
implements HolidaysService {
    @Autowired
    private SystemParameterService systemParameterService;

    @Override
    public DateTime getDate(DateTime lastDate, Long days) {
        List<LocalDate> customHolidays = this.getSystemCustomHolidays();
        DateTime earlierDate = DateTime.now();
        while (days > 0L) {
            LocalDate dayInCheck = earlierDate.toLocalDate();
            if (!customHolidays.contains(dayInCheck) && !this.isHolidayOrWeekend(dayInCheck)) {
                Long l = days;
                Long l2 = days = Long.valueOf(days - 1L);
            }
            earlierDate = earlierDate.minusDays(1);
        }
        return earlierDate;
    }

    @Override
    public Boolean isHoliday(LocalDate date) {
        List<LocalDate> customHolidays = this.getSystemCustomHolidays();
        return customHolidays.contains(date) || this.isHolidayOrWeekend(date);
    }

    private List<LocalDate> getSystemCustomHolidays() {
        ArrayList<LocalDate> result = new ArrayList<LocalDate>();
        SystemParameter systemCustomHolidays = this.systemParameterService.getParameter("CustomHolidays");
        if (systemCustomHolidays != null) {
            String[] customHolidays;
            String holidaysString = systemCustomHolidays.getValueString();
            if (StringUtils.isBlank((CharSequence)holidaysString)) {
                return result;
            }
            for (String freeCustomDay : customHolidays = holidaysString.split(";")) {
                LocalDate tempDate;
                if (StringUtils.isBlank((CharSequence)freeCustomDay)) continue;
                if (freeCustomDay.length() == 5) {
                    tempDate = new LocalDate((Object)(new LocalDate().getYear() + "-" + freeCustomDay));
                } else {
                    if (freeCustomDay.length() != 10) continue;
                    tempDate = new LocalDate((Object)freeCustomDay);
                }
                result.add(tempDate);
            }
        }
        return result;
    }

    private boolean isHolidayOrWeekend(LocalDate dayInCheck) {
        if (this.belongsToWeekend(dayInCheck) || this.isStaticHoliday(dayInCheck)) {
            return true;
        }
        if (dayInCheck.getMonthOfYear() >= 3 || dayInCheck.getMonthOfYear() <= 6) {
            return this.isMovingHoliday(dayInCheck);
        }
        return false;
    }

    private boolean belongsToWeekend(LocalDate dayInCheck) {
        return dayInCheck.getDayOfWeek() == 6 || dayInCheck.getDayOfWeek() == 7;
    }

    private boolean isStaticHoliday(LocalDate dayInCheck) {
        switch (dayInCheck.getMonthOfYear()) {
            case 1: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 6) break;
                return true;
            }
            case 5: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 3) break;
                return true;
            }
            case 8: {
                if (dayInCheck.getDayOfMonth() != 15) break;
                return true;
            }
            case 11: {
                if (dayInCheck.getDayOfMonth() != 1 && dayInCheck.getDayOfMonth() != 11) break;
                return true;
            }
            case 12: {
                if (dayInCheck.getDayOfMonth() != 25 && dayInCheck.getDayOfMonth() != 26) break;
                return true;
            }
        }
        return false;
    }

    private boolean isMovingHoliday(LocalDate dayInCheck) {
        int a = dayInCheck.getYear() % 19;
        int b = (int)Math.floor(dayInCheck.getYear() / 100);
        int c = dayInCheck.getYear() % 100;
        int d = (int)Math.floor(b / 4);
        int e = b % 4;
        int f = (int)Math.floor((b + 8) / 25);
        int g = (int)Math.floor((b - f + 1) / 3);
        int h = (19 * a + b - d - g + 15) % 30;
        int i = (int)Math.floor(c / 4);
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (int)Math.floor((a + 11 * h + 22 * l) / 451);
        int p = (h + l - 7 * m + 114) % 31;
        int day = p + 1;
        int month = (int)Math.floor((h + l - 7 * m + 114) / 31);
        LocalDate easterFirst = new LocalDate(dayInCheck.getYear(), month, day);
        LocalDate easterSecond = new LocalDate((Object)easterFirst.plusDays(1));
        LocalDate ZDS = easterFirst.plusDays(49);
        LocalDate BC = easterFirst.plusDays(60);
        return dayInCheck.equals((Object)easterFirst) || dayInCheck.equals((Object)easterSecond) || dayInCheck.equals((Object)ZDS) || dayInCheck.equals((Object)BC);
    }
}

