/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.db.service;

import com.suncode.plugin.scheduldedtask.db.entities.CreatedProcesses;
import com.suncode.plugin.scheduldedtask.db.entities.CreatedProcessesDao;
import com.suncode.plugin.scheduldedtask.db.service.CreatedProcessesService;
import com.suncode.plugin.scheduldedtask.process.ProcessInfo;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CreatedProcessesServiceImpl
extends EditableServiceImpl<CreatedProcesses, Long, CreatedProcessesDao>
implements CreatedProcessesService {
    @Autowired
    public void setDao(CreatedProcessesDao dao) {
        this.dao = dao;
    }

    @Override
    public void save(ScheduledTaskInstanceInfo scheduledTaskInfo, String key) {
        CreatedProcesses entity = this.createProcess(scheduledTaskInfo, key, false, "");
        ((CreatedProcessesDao)this.dao).save(entity);
    }

    @Override
    public CreatedProcesses findOne(String key, Long taskId) {
        HibernateCriteria dc = HibernateCriteria.forClass(CreatedProcesses.class).add(Restrictions.eq((String)"key", (Object)key)).add(Restrictions.eq((String)"taskId", (Object)taskId));
        return (CreatedProcesses)((CreatedProcessesDao)this.dao).findOne(dc);
    }

    @Override
    public List<CreatedProcesses> getAllCreatedProcessesByTaskId(Long taskId) {
        HibernateCriteria dc = HibernateCriteria.forClass(CreatedProcesses.class).add(Restrictions.eq((String)"createdProcess", (Object)true)).add(Restrictions.eq((String)"taskId", (Object)taskId));
        return ((CreatedProcessesDao)this.dao).findByCriteria(dc);
    }

    @Override
    public void update(String processId, ScheduledTaskInstanceInfo scheduledTaskInfo, Boolean createdProcess, String key) {
        CreatedProcesses entity = this.findOne(key, scheduledTaskInfo.getId());
        this.updateEntity(processId, scheduledTaskInfo.getName(), createdProcess, DateTime.now().getMillis(), entity);
    }

    private void updateEntity(String processId, String taskName, Boolean createdProcess, Long time, CreatedProcesses entity) {
        entity.setProcessId(processId);
        entity.setTaskName(taskName);
        entity.setCreatedProcess(createdProcess);
        entity.setCreatedDate(new Timestamp(time));
    }

    @Override
    public void saveOrUpdateCreatedProcesses(boolean repeatCreateProcesses, ScheduledTaskInstanceInfo scheduledTaskInfo, ProcessInfo processInfo) {
        boolean createdProcess;
        CreatedProcesses entity = this.findOne(processInfo.getKey(), scheduledTaskInfo.getId());
        boolean bl = createdProcess = !repeatCreateProcesses && processInfo.isSuccess();
        if (entity == null) {
            entity = this.createProcess(scheduledTaskInfo, processInfo.getKey(), createdProcess, processInfo.getProcessId());
            entity.setCreatedDate(new Timestamp(processInfo.getTime().getMillis()));
            ((CreatedProcessesDao)this.dao).save(entity);
        } else {
            this.updateEntity(processInfo.getProcessId(), scheduledTaskInfo.getName(), createdProcess, processInfo.getTime().getMillis(), entity);
        }
    }

    private CreatedProcesses createProcess(ScheduledTaskInstanceInfo scheduledTaskInfo, String key, boolean createdProcess, String processId) {
        CreatedProcesses entity = new CreatedProcesses();
        entity.setKey(key);
        entity.setTaskId(scheduledTaskInfo.getId());
        entity.setTaskName(scheduledTaskInfo.getName());
        entity.setCreatedProcess(createdProcess);
        entity.setProcessId(processId);
        return entity;
    }
}

