/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.scheduldedtask.audit.recipient;

import com.suncode.plugin.scheduldedtask.audit.recipient.RecipientType;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RecipientService {
    private static final EmailValidator EMAIL_VALIDATOR = EmailValidator.getInstance((boolean)true, (boolean)true);
    @Autowired
    private UserService userService;

    public List<String> getRecipientsEmails(String recipients, String recipientType) {
        List<String> emailRecipients;
        switch (RecipientType.valueOf(recipientType)) {
            case USER: {
                emailRecipients = this.getEmailsByUsers(recipients);
                break;
            }
            case EMAIL: {
                emailRecipients = this.getEmailsByText(recipients);
                break;
            }
            default: {
                emailRecipients = new ArrayList<String>();
            }
        }
        if (emailRecipients.isEmpty()) {
            throw new Exception("There are no recipients for the email");
        }
        return emailRecipients;
    }

    private List<String> getEmailsByText(String recipients) {
        return Stream.of(recipients.split(",")).map(String::trim).filter(StringUtils::isNotBlank).filter(arg_0 -> ((EmailValidator)EMAIL_VALIDATOR).isValid(arg_0)).collect(Collectors.toList());
    }

    private List<String> getEmailsByUsers(String recipients) {
        return Stream.of(recipients.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(x$0 -> this.userService.getUser(x$0, new String[0])).filter(Objects::nonNull).map(User::getEmail).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void validRecipients(Logger taskLog, String recipients, String recipientType) {
        switch (RecipientType.valueOf(recipientType)) {
            case USER: {
                Arrays.stream(recipients.split(",")).map(String::trim).filter(recipient -> !StringUtils.isBlank((CharSequence)recipient)).forEach(recipient -> {
                    User user = this.userService.getUser(recipient, new String[0]);
                    if (user == null) {
                        taskLog.warn((Object)("User not found: " + recipient));
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)user.getEmail())) {
                        taskLog.warn((Object)("User not have email: " + recipient));
                        return;
                    }
                    taskLog.warn((Object)("User is correct: " + recipient));
                });
                break;
            }
            case EMAIL: {
                Arrays.stream(recipients.split(",")).map(String::trim).filter(recipient -> !StringUtils.isBlank((CharSequence)recipient)).forEach(recipient -> {
                    if (EMAIL_VALIDATOR.isValid(recipient)) {
                        taskLog.warn((Object)("Email is correct: " + recipient));
                    } else {
                        taskLog.warn((Object)("Email is not correct: " + recipient));
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Parameter recipientType: " + recipientType + "  not supported");
            }
        }
    }
}

