/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.workers;

import com.suncode.plugin.rpa.workers.WorkersRepository;
import com.suncode.plugin.rpa.workers.dto.WorkerDto;
import com.suncode.plugin.rpa.workers.entities.Worker;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class WorkersRepositoryImpl
implements WorkersRepository {
    private static final LinkedHashSet<Worker> WORKERS = new LinkedHashSet();

    @Override
    @Transactional
    public Set<Worker> getAll() {
        return WORKERS;
    }

    @Override
    public Worker get(String id) {
        return WORKERS.stream().filter(worker -> Objects.equals(worker.getId(), id)).findFirst().orElse(null);
    }

    @Override
    public void add(WorkerDto workerDto, String ip) {
        Worker worker = this.workerDtoToEntity(workerDto, ip);
        WORKERS.add(worker);
    }

    @Override
    public void update(WorkerDto workerDto, String ip) {
        Worker workerToUpdate = this.workerDtoToEntity(workerDto, ip);
        WORKERS.removeIf(worker -> worker.getId().equals(workerToUpdate.getId()));
        WORKERS.add(workerToUpdate);
    }

    @Override
    public void remove(Worker worker) {
        WORKERS.remove(worker);
    }

    private Worker workerDtoToEntity(WorkerDto workerDto, String ip) {
        return new Worker(workerDto.getId(), workerDto.getName(), ip, workerDto.getStatus(), DateTime.now());
    }
}

