/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.workers;

import com.suncode.plugin.rpa.exceptions.NotFoundException;
import com.suncode.plugin.rpa.workers.WorkersService;
import com.suncode.plugin.rpa.workers.dto.WorkerDto;
import com.suncode.plugin.rpa.workers.entities.Worker;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"workers"})
public class WorkersController {
    private final WorkersService workersService;

    @Autowired
    public WorkersController(WorkersService workersService) {
        this.workersService = workersService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Set<Worker> getAllWorkers() {
        return this.workersService.getAllWorkers();
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"{workerId}"})
    @ResponseBody
    public Worker getWorker(@PathVariable String workerId) {
        Worker worker = this.workersService.getWorkerById(workerId);
        if (worker == null) {
            throw new NotFoundException();
        }
        return worker;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST}, value={"heartbeat"})
    public void heartbeat(@RequestBody WorkerDto workerDto, HttpServletRequest request) {
        this.workersService.heartbeat(workerDto, request.getRemoteAddr());
    }
}

