/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.tasks;

import com.suncode.plugin.rpa.exceptions.NotFoundException;
import com.suncode.plugin.rpa.tasks.TasksService;
import com.suncode.plugin.rpa.tasks.dto.TaskDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tasks"})
public class TasksController {
    private static final Logger log = LoggerFactory.getLogger(TasksController.class);
    private final TasksService tasksService;

    @Autowired
    public TasksController(TasksService tasksService) {
        this.tasksService = tasksService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"{configId}"})
    @ResponseBody
    public TaskDto getTask(@PathVariable String configId) {
        log.debug("getTask:" + configId);
        TaskDto task = this.tasksService.pollOne(configId);
        log.debug("return getTask");
        if (task == null) {
            throw new NotFoundException();
        }
        return task;
    }
}

