/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.logs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.suncode.plugin.rpa.logs.LogsService;
import com.suncode.plugin.rpa.logs.dto.LogResponseDto;
import com.suncode.plugin.rpa.logs.dto.LogWorkerMessageDto;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"logs"})
public class LogsController {
    private final LogsService logsService;
    private final ObjectMapper mapper;

    @Autowired
    public LogsController(LogsService logsService) {
        this.logsService = logsService;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JodaModule());
        this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public void log(@RequestBody String logWorkerMessage) throws IOException {
        logWorkerMessage = logWorkerMessage.substring(1, logWorkerMessage.length() - 1);
        logWorkerMessage = StringEscapeUtils.unescapeJson((String)logWorkerMessage);
        LogWorkerMessageDto logWorkerMessageDto = (LogWorkerMessageDto)this.mapper.readValue(logWorkerMessage, (TypeReference)new TypeReference<LogWorkerMessageDto>(){});
        this.logsService.log(logWorkerMessageDto);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"{workerId}"})
    @ResponseBody
    public LogResponseDto getLog(@PathVariable String workerId) {
        return this.logsService.getLog(workerId);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"updated/{workerId}"})
    @ResponseBody
    public LogResponseDto updatedLog(@PathVariable String workerId, @RequestParam int lastLine) {
        return this.logsService.updatedLog(workerId, lastLine);
    }
}

