/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.files;

import com.suncode.plugin.rpa.files.FilesService;
import com.suncode.plugin.rpa.files.dto.FilesWorkerMessageDto;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesServiceImpl
implements FilesService {
    private static final Logger log = LoggerFactory.getLogger(FilesServiceImpl.class);
    @Autowired
    DocumentService documentService;

    @Override
    public void uploadFile(FilesWorkerMessageDto fileWorkerMessage) {
        try {
            DocumentDefinition documentDefinition = new DocumentDefinition();
            documentDefinition.setActivityId(fileWorkerMessage.getActivityId());
            documentDefinition.setProcessId(fileWorkerMessage.getProcessId());
            documentDefinition.setDescription(fileWorkerMessage.getDescription());
            documentDefinition.setDocumentClassId(Long.valueOf(fileWorkerMessage.getDocclassId()));
            documentDefinition.setSaveAsNewVersion(true);
            documentDefinition.setFileName(fileWorkerMessage.getFileName());
            documentDefinition.setUserName("admin");
            documentDefinition.setInputStream(this.getInputStreamFromBase64(fileWorkerMessage.getContent()));
            this.documentService.addDocument(documentDefinition);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private InputStream getInputStreamFromBase64(String base64content) throws UnsupportedEncodingException {
        String result = URLDecoder.decode(base64content, StandardCharsets.UTF_8.name());
        byte[] decodedString = Base64.getDecoder().decode(result.getBytes(StandardCharsets.UTF_8));
        return new ByteArrayInputStream(decodedString);
    }
}

