/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.configs;

import com.suncode.plugin.rpa.configs.ConfigsService;
import com.suncode.plugin.rpa.configs.dto.CreateConfigDto;
import com.suncode.plugin.rpa.configs.dto.UpdateConfigDto;
import com.suncode.plugin.rpa.configs.entities.Config;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"configs"})
public class ConfigsController {
    private static final Logger log = LoggerFactory.getLogger(ConfigsController.class);
    private final ConfigsService configsService;

    @Autowired
    public ConfigsController(ConfigsService configsService) {
        this.configsService = configsService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Config> getConfigs() {
        log.debug("Get configs");
        return this.configsService.getConfigs();
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Config getConfig(@PathVariable String id) {
        log.debug("Get config");
        return this.configsService.getConfig(id);
    }

    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Config createConfig(@RequestBody CreateConfigDto createConfigDto) {
        log.debug("Create config");
        return this.configsService.createConfig(createConfigDto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public Config updateConfig(@PathVariable String id, @RequestBody UpdateConfigDto updateConfigDto) {
        log.debug("Update config");
        return this.configsService.updateConfig(id, updateConfigDto);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public Config deleteConfig(@PathVariable String id) {
        log.debug("Delete config");
        return this.configsService.deleteConfig(id);
    }
}

