/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.workers.events;

import com.suncode.plugin.rpa.workers.events.WorkerEventsDao;
import com.suncode.plugin.rpa.workers.events.WorkerEventsService;
import com.suncode.plugin.rpa.workers.events.dto.WorkerConnectionEventDto;
import com.suncode.plugin.rpa.workers.events.entities.WorkerConnectionEvent;
import com.suncode.plugin.rpa.workers.events.enums.WorkerConnectionEventType;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Order;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkerEventsServiceImpl
implements WorkerEventsService {
    private final WorkerEventsDao workerEventsDao;

    @Autowired
    public WorkerEventsServiceImpl(WorkerEventsDao workerEventsDao) {
        this.workerEventsDao = workerEventsDao;
    }

    @Override
    @Transactional
    public List<WorkerConnectionEvent> getAll() {
        return this.workerEventsDao.getAll(new String[0]);
    }

    @Override
    @Transactional
    public List<WorkerConnectionEvent> getAllByWorkerId(String workerId) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(WorkerConnectionEvent.class).add(Restrictions.eq((String)"workerId", (Object)workerId));
        return this.workerEventsDao.findByCriteria(exportedDocument);
    }

    @Override
    @Transactional
    public WorkerConnectionEvent get(Long id) {
        return (WorkerConnectionEvent)this.workerEventsDao.get(id);
    }

    @Override
    @Transactional
    public void create(String workerId, String workerName, WorkerConnectionEventType type) {
        WorkerConnectionEvent workerConnectionEvent = new WorkerConnectionEvent();
        workerConnectionEvent.setWorkerId(workerId);
        workerConnectionEvent.setWorkerName(workerName);
        workerConnectionEvent.setType(type);
        workerConnectionEvent.setOccuredAt(new Date());
        this.workerEventsDao.save(workerConnectionEvent);
    }

    @Override
    @Transactional
    public void remove(Long id) {
        WorkerConnectionEvent workerConnectionEvent = (WorkerConnectionEvent)this.workerEventsDao.get(id);
        this.workerEventsDao.delete(workerConnectionEvent);
    }

    @Override
    @Transactional
    @Scheduled(cron="0 0 8 * * *")
    public void removeEventsOlderThanYear() {
        HibernateCriteria criteria = HibernateCriteria.forClass(WorkerConnectionEvent.class).add(Restrictions.lt((String)"occuredAt", (Object)DateTime.now().minusYears(1).toDate()));
        List workerEventsToDelete = this.workerEventsDao.findByCriteria(criteria);
        workerEventsToDelete.forEach(arg_0 -> ((WorkerEventsDao)this.workerEventsDao).delete(arg_0));
    }

    @Override
    @Transactional
    public List<String> getAllWorkerIds() {
        return this.workerEventsDao.getAll(new String[0]).stream().map(WorkerConnectionEvent::getWorkerId).distinct().sorted().collect(Collectors.toList());
    }

    @Override
    @Transactional
    public List<WorkerConnectionEventDto> getAllEventsByWorkerId(String workerId) {
        HibernateCriteria criteria = HibernateCriteria.forClass(WorkerConnectionEvent.class).add(Restrictions.eq((String)"workerId", (Object)workerId)).addOrder(Order.desc((String)"occuredAt"));
        return this.workerEventsDao.findByCriteria(criteria).stream().map(event -> new WorkerConnectionEventDto(event.getWorkerId(), event.getOccuredAt().getTime(), event.getType())).collect(Collectors.toList());
    }
}

