/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.workers.events;

import com.suncode.plugin.rpa.workers.events.WorkerEventsService;
import com.suncode.plugin.rpa.workers.events.dto.WorkerConnectionEventDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"worker-events"})
public class WorkerEventsController {
    private final WorkerEventsService workerEventsService;

    @Autowired
    public WorkerEventsController(WorkerEventsService workerEventsService) {
        this.workerEventsService = workerEventsService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"workers"}, produces={"application/json"})
    @ResponseBody
    public List<String> getAllWorkerIds() {
        return this.workerEventsService.getAllWorkerIds();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"{workerId}"}, produces={"application/json"})
    @ResponseBody
    public List<WorkerConnectionEventDto> getAllEventsByWorkerId(@PathVariable String workerId) {
        return this.workerEventsService.getAllEventsByWorkerId(workerId);
    }
}

