/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.workers;

import com.suncode.plugin.rpa.workers.WorkersRepository;
import com.suncode.plugin.rpa.workers.WorkersService;
import com.suncode.plugin.rpa.workers.dto.WorkerDto;
import com.suncode.plugin.rpa.workers.entities.Worker;
import com.suncode.plugin.rpa.workers.events.WorkerEventsService;
import com.suncode.plugin.rpa.workers.events.enums.WorkerConnectionEventType;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WorkersServiceImpl
implements WorkersService {
    private final WorkersRepository workersRepository;
    private final WorkerEventsService workerEventsService;

    @Autowired
    public WorkersServiceImpl(WorkersRepository workersRepository, WorkerEventsService workerEventsService) {
        this.workersRepository = workersRepository;
        this.workerEventsService = workerEventsService;
    }

    @Override
    public Set<Worker> getAllWorkers() {
        return this.workersRepository.getAll();
    }

    @Override
    public Worker getWorkerById(String id) {
        return this.workersRepository.get(id);
    }

    @Override
    public void heartbeat(WorkerDto workerDto, String ip) {
        Worker worker = this.workersRepository.get(workerDto.getId());
        if (worker == null) {
            this.workerEventsService.create(workerDto.getId(), workerDto.getName(), WorkerConnectionEventType.CONNECTED);
            this.workersRepository.add(workerDto, ip);
        } else {
            this.workersRepository.update(workerDto, ip);
        }
    }

    @Override
    @Scheduled(fixedRate=5000L)
    public void removeDisconnectedWorkers() {
        Set<Worker> workers = this.workersRepository.getAll();
        Set<Worker> workersToRemove = workers.stream().filter(worker -> worker.getLastActive().isBefore((ReadableInstant)DateTime.now().minusSeconds(10))).collect(Collectors.toSet());
        workersToRemove.forEach(worker -> {
            this.workerEventsService.create(worker.getId(), worker.getName(), WorkerConnectionEventType.DISCONNECTED);
            this.workersRepository.remove((Worker)worker);
        });
    }
}

