/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.tasks;

import com.suncode.plugin.rpa.activities.RpaActivitiesService;
import com.suncode.plugin.rpa.configs.ConfigsService;
import com.suncode.plugin.rpa.configs.entities.Config;
import com.suncode.plugin.rpa.scripts.ScriptsService;
import com.suncode.plugin.rpa.tasks.TasksService;
import com.suncode.plugin.rpa.tasks.dto.TaskDto;
import com.suncode.plugin.rpa.tasks.entities.Task;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.InvalidAttributeValueException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TasksServiceImpl
implements TasksService {
    private static final Logger log = LoggerFactory.getLogger(TasksServiceImpl.class);
    private static final Map<String, Set<Task>> PROCESSING_TASKS = new HashMap<String, Set<Task>>();
    private static final Map<String, ArrayDeque<Task>> WAITING_TASKS = new HashMap<String, ArrayDeque<Task>>();
    private static final String SCRIPT_WRAPPER_NAME = "script-wrapper.txt";
    private final ActivityService activityService;
    private final ConfigsService configsService;
    private final RpaActivitiesService rpaActivitiesService;
    private final ScriptsService scriptsService;

    @Autowired
    public TasksServiceImpl(ActivityService activityService, ConfigsService configsService, RpaActivitiesService rpaActivitiesService, ScriptsService scriptsService) {
        this.activityService = activityService;
        this.configsService = configsService;
        this.rpaActivitiesService = rpaActivitiesService;
        this.scriptsService = scriptsService;
    }

    @Override
    public void add(String rpaConfigId, Task task) {
        this.ensureTaskCollectionsExist(rpaConfigId);
        if (!PROCESSING_TASKS.get(rpaConfigId).contains(task)) {
            WAITING_TASKS.get(rpaConfigId).add(task);
        }
    }

    @Override
    public void addAll(String rpaConfigId, List<Task> tasks) {
        this.ensureTaskCollectionsExist(rpaConfigId);
        List filteredTasks = tasks.stream().filter(task -> !PROCESSING_TASKS.get(rpaConfigId).contains(task) && !WAITING_TASKS.get(rpaConfigId).contains(task)).collect(Collectors.toList());
        WAITING_TASKS.get(rpaConfigId).addAll(filteredTasks);
    }

    @Override
    public void finishProcessing(String rpaConfigId, String processId, String activityId) {
        this.ensureTaskCollectionsExist(rpaConfigId);
        PROCESSING_TASKS.get(rpaConfigId).removeIf(config -> config.getProcessId().equals(processId) && config.getActivityId().equals(activityId));
    }

    private void ensureTaskCollectionsExist(String rpaConfigId) {
        PROCESSING_TASKS.computeIfAbsent(rpaConfigId, key -> new HashSet());
        WAITING_TASKS.computeIfAbsent(rpaConfigId, key -> new ArrayDeque());
    }

    @Override
    public TaskDto pollOne(String rpaConfigId) {
        this.syncQueues(rpaConfigId);
        ArrayDeque<Task> tasksQueue = WAITING_TASKS.get(rpaConfigId);
        if (tasksQueue == null) {
            return null;
        }
        Task task = tasksQueue.poll();
        if (task == null) {
            return null;
        }
        PROCESSING_TASKS.get(rpaConfigId).add(task);
        return this.createTaskDto(task);
    }

    private TaskDto createTaskDto(Task task) {
        return new TaskDto(task.getProcessId(), task.getActivityId(), task.getScriptId(), task.getContextMap(), this.wrapScriptContent(this.scriptsService.getScript(task.getScriptId()).getContent(), task.getContextMap()), task.getSuccessActionName(), task.getErrorActionName(), task.getScreenshotDocClassId());
    }

    private void syncQueues(String rpaConfigId) {
        Config config = this.configsService.getConfig(rpaConfigId);
        if (config.getAcceptUserName().equals("<BUFFER_USERNAME>")) {
            config.setAcceptUserName(this.resolveSystemBufferUserName());
        }
        log.debug("syncQueues with config:" + rpaConfigId);
        List<Activity> openActivities = this.rpaActivitiesService.findOpenActivitiesByIds(config.getProcessDefId(), config.getActivityDefId());
        log.debug("openActivities count:" + openActivities.size());
        openActivities.sort(Comparator.comparing(Activity::getObjectId));
        List<Task> tasks = openActivities.stream().map(activity -> new Task(activity.getProcessId(), activity.getActivityId(), this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId()), config.getScriptId(), config.getSuccessActionName(), config.getErrorActionName(), config.getScreenshotDocClassId())).collect(Collectors.toList());
        this.addAll(rpaConfigId, tasks);
        this.filterAbortedActivities(rpaConfigId);
    }

    private void filterAbortedActivities(String rpaConfigId) {
        Set tasksToDelete = WAITING_TASKS.get(rpaConfigId).stream().filter(task -> {
            Activity activity = this.activityService.getActivity(task.getProcessId(), task.getActivityId(), new String[0]);
            return !activity.getState().equals((Object)ActivityState.NOT_STARTED) && !activity.getState().equals((Object)ActivityState.RUNNING);
        }).collect(Collectors.toSet());
        WAITING_TASKS.get(rpaConfigId).removeAll(tasksToDelete);
    }

    private String resolveSystemBufferUserName() throws InvalidAttributeValueException {
        String bufferUsername = SystemProperties.getString((String)"Bufor.username");
        if (bufferUsername == null) {
            throw new InvalidAttributeValueException("Buffer username does not exist in system properties!");
        }
        return bufferUsername;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String wrapScriptContent(String scriptContent, Map<String, Object> contextMap) {
        StringBuilder contextMapToStringBuilder = new StringBuilder();
        for (String variableId : contextMap.keySet()) {
            contextMapToStringBuilder.append(variableId).append(" := \"\"\r\n");
        }
        contextMapToStringBuilder.append("\r\nfor n, param in A_Args\r\n{\r\n  splitted_param := StrSplit(param,\"=\")\r\n");
        for (String variableId : contextMap.keySet()) {
            contextMapToStringBuilder.append("  if (splitted_param[1] == \"").append(variableId).append("\") {\r\n    ").append(variableId).append(" := splitted_param[2]\r\n  }\r\n");
        }
        String contextMapAsString = contextMapToStringBuilder.append("}").toString();
        try (InputStream wrapperInputStream = this.getClass().getClassLoader().getResourceAsStream(SCRIPT_WRAPPER_NAME);){
            String string = IOUtils.toString((InputStream)Objects.requireNonNull(wrapperInputStream), (Charset)StandardCharsets.UTF_8).replace("@CONTEXT_MAP@", contextMapAsString).replace("@SCRIPT_CONTENT@", scriptContent);
            return string;
        }
    }
}

