/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.rpa.scripts;

import com.suncode.plugin.rpa.scripts.ScriptsDao;
import com.suncode.plugin.rpa.scripts.ScriptsService;
import com.suncode.plugin.rpa.scripts.dto.CreateScriptDto;
import com.suncode.plugin.rpa.scripts.dto.UpdateScriptDto;
import com.suncode.plugin.rpa.scripts.entities.Script;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ScriptsServiceImpl
implements ScriptsService {
    private final ScriptsDao scriptsDao;

    @Autowired
    public ScriptsServiceImpl(ScriptsDao scriptsDao) {
        this.scriptsDao = scriptsDao;
    }

    @Override
    @Transactional
    public List<Script> getScripts() {
        List scripts = this.scriptsDao.getAll(new String[0]);
        scripts.sort(Comparator.comparing(Script::getName));
        return scripts;
    }

    @Override
    @Transactional
    public Script getScript(String id) {
        return (Script)this.scriptsDao.get((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public Script createScript(CreateScriptDto createScriptDto) {
        Script script = new Script();
        script.setId(createScriptDto.getId());
        script.setName(createScriptDto.getName());
        script.setContent(createScriptDto.getContent());
        String id = (String)((Object)this.scriptsDao.save(script));
        return (Script)this.scriptsDao.get((Serializable)((Object)id));
    }

    @Override
    @Transactional
    public Script updateScript(String id, UpdateScriptDto updateScriptDto) {
        Script script = (Script)this.scriptsDao.get((Serializable)((Object)id));
        script.setName(updateScriptDto.getName());
        script.setContent(updateScriptDto.getContent());
        this.scriptsDao.update(script);
        return script;
    }

    @Override
    @Transactional
    public Script deleteScript(String id) {
        Script script = (Script)this.scriptsDao.get((Serializable)((Object)id));
        this.scriptsDao.delete(script);
        return script;
    }
}

